//STorM32 Web App v0.25
// (c) www.OlliW.eu 2017

/*TODO:
- always do a read before a write ?
- check validity after a write
- version check, as in GUI
- several tries before alert in updateRead, updateStatus
*/


'use strict';


//http://geekswithblogs.net/lorint/archive/2006/03/07/71625.aspx
//https://stackoverflow.com/questions/1018705/how-to-detect-timeout-on-an-ajax-xmlhttprequest-call-in-the-browser
function ajaxDo(type, url, content, func) {

    if( XhttpTransferInProgress ){ alert("A Xhttp transfer is currently in progress. Wait and repeat."); return; }
    XhttpTransferInProgress = true;
    
    var xhttp = new XMLHttpRequest();
    xhttp.onreadystatechange = function() {
        if( this.readyState == 4 ){ 
            clearTimeout(xhttpTimeout); 
            if( (this.readyState == 4) && (this.status == 200) ){ 
                ConnectionIsValid = true; 
                func(this); 
            }else{
                ConnectionIsValid = false;
                setPAllToInvalid();                
            }
        }
    };
    xhttp.open(type, url, true); //xhttp.open('POST', url, true); //xhttp.open('GET', url, true);
    if( content.length ) xhttp.send(content); else xhttp.send();
    // timeout to abort in 5 seconds
    function ajaxTimeout(){
        xhttp.abort();
        ConnectionIsValid = false;
        setPAllToInvalid();
        alert("Xhttp request timed out");
    }    
    var xhttpTimeout = setTimeout(ajaxTimeout,3000);
    
    XhttpTransferInProgress = false;
}


function ajaxPost(url, content, func) {
    ajaxDo('POST', url, content, func);
}

function ajaxGet(url, content, func) {
    ajaxDo('GET', url, content, func);
}


//-----------------------------------------------------
// parameter description
//-----------------------------------------------------

//capability constants
var BOARD_CAPABILITY_FOC           =  0x0100;

var FocIsEnabled = false;

//this is a flag to avoid that more than one xhhtp transfer is going on at a time
// is this really working????
var XhttpTransferInProgress = false;

//this is flag tells about the connection to the ESP and/or STorM32
// it holds the success result of the last XhttpRequest, as well as that of the returned resposne, if it was 'o' or not
var ConnectionIsValid = false;

//this is the string of hex received via read, i.e. g
// it is needed to keep the scripts, and to keep values not available or changed
// it has to be maintained
var PValues = '';

//this is to maintain the status of the PValues
var INVALID = 0;
var VALID = 1;
var MODIFIED = 2;
var PStatus = INVALID;  //this can be invalid = 0, valid = 1, modified; 

var P =
{
/*
  'FirmwareVersion' : {'default' : '', 'column' : 1, 'unit' : '', 'size' : 16, 'hidden' : 0, 
                       'page' : 'dashboard', 'type' : 'OPTTYPE_STR+OPTTYPE_READONLY', 'name' : 'Firmware Version'},
  'GyroLPF' : {'steps' : 1, 'default' : 1, 'adr' : 12, 'max' : 6, 'len' : 0, 
               'page' : 'pid', 'min' : 0, 
               'choices' : ['off', '1.5 ms', '3.0 ms', '4.5 ms', '6.0 ms', '7.5 ms', '9 ms'], 
               'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'pos' : [1, 1], 
               'name' : 'Gyro LPF', 'ppos' : 0},
  'PitchP' : {'steps' : 10, 'default' : 400, 'adr' : 0, 'max' : 3000, 
              'page' : 'pid', 'min' : 0, 'len' : 5, 'size' : 2, 'ppos' : 2, 
              'type' : 'OPTTYPE_UI', 'hidden' : 0, 'pos' : [2, 1], 
              'name' : 'Pitch P', 'unit' : ''},
*/              
  'FirmwareVersion' : {'steps' : 1, 'default' : '', 'column' : 1, 'unit' : '', 'size' : 16, 'hidden' : 0, 'page' : 'dashboard', 'type' : 'OPTTYPE_STR+OPTTYPE_READONLY', 'name' : 'Firmware Version'},
  'Board' : {'steps' : 1, 'default' : '', 'unit' : '', 'size' : 16, 'page' : 'dashboard', 'hidden' : 0, 'type' : 'OPTTYPE_STR+OPTTYPE_READONLY', 'name' : 'Board'},
  'Name' : {'steps' : 1, 'default' : '', 'unit' : '', 'size' : 16, 'page' : 'dashboard', 'hidden' : 0, 'type' : 'OPTTYPE_STR+OPTTYPE_READONLY', 'name' : 'Name'},
  'GyroLPF' : {'steps' : 1, 'default' : 1, 'adr' : 12, 'max' : 6, 'len' : 0, 'page' : 'pid', 'min' : 0, 'choices' : ['off', '1.5 ms', '3.0 ms', '4.5 ms', '6.0 ms', '7.5 ms', '9 ms'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'pos' : [1, 1], 'name' : 'Gyro LPF', 'ppos' : 0},
  'FocGyroLPF' : {'steps' : 1, 'default' : 1, 'adr' : 41, 'max' : 6, 'len' : 0, 'page' : 'pid', 'min' : 0, 'choices' : ['off', '1.5 ms', '3.0 ms', '4.5 ms', '6.0 ms', '7.5 ms', '9 ms'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'pos' : [1, 1], 'name' : 'Foc Gyro LPF', 'ppos' : 0},
  'Imu2FeedForwardLPF' : {'steps' : 1, 'default' : 1, 'adr' : 72, 'max' : 6, 'len' : 0, 'page' : 'pid', 'min' : 0, 'choices' : ['off', '1.5 ms', '4 ms', '10 ms', '22 ms', '46 ms', '94 ms'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'name' : 'Imu2 FeedForward LPF', 'ppos' : 0},
  'VoltageCorrection' : {'steps' : 1, 'default' : 0, 'adr' : 75, 'max' : 200, 'page' : 'pid', 'min' : 0, 'len' : 7, 'size' : 2, 'ppos' : 0, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'pos' : [1, 4], 'name' : 'Voltage Correction', 'unit' : '%'},
  'RollYawPDMixing' : {'steps' : 1, 'default' : 0, 'adr' : 73, 'max' : 100, 'page' : 'pid', 'min' : 0, 'len' : 5, 'size' : 2, 'ppos' : 0, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Roll Yaw PD Mixing', 'unit' : '%'},
  'PitchP' : {'steps' : 10, 'default' : 400, 'adr' : 0, 'max' : 3000, 'page' : 'pid', 'min' : 0, 'len' : 5, 'size' : 2, 'ppos' : 2, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'pos' : [2, 1], 'name' : 'Pitch P', 'unit' : ''},
  'PitchI' : {'steps' : 50, 'default' : 1000, 'adr' : 1, 'max' : 32000, 'page' : 'pid', 'min' : 0, 'len' : 7, 'size' : 2, 'ppos' : 1, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Pitch I', 'unit' : ''},
  'PitchD' : {'steps' : 50, 'default' : 500, 'adr' : 2, 'max' : 8000, 'page' : 'pid', 'min' : 0, 'len' : 3, 'size' : 2, 'ppos' : 4, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Pitch D', 'unit' : ''},
  'PitchMotorVmax' : {'steps' : 1, 'default' : 150, 'adr' : 3, 'max' : 255, 'page' : 'pid', 'min' : 0, 'len' : 5, 'size' : 2, 'ppos' : 0, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Pitch Motor Vmax', 'unit' : ''},
  'RollP' : {'steps' : 10, 'default' : 400, 'adr' : 4, 'max' : 3000, 'page' : 'pid', 'min' : 0, 'len' : 5, 'size' : 2, 'ppos' : 2, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'pos' : [3, 1], 'name' : 'Roll P', 'unit' : ''},
  'RollI' : {'steps' : 50, 'default' : 1000, 'adr' : 5, 'max' : 32000, 'page' : 'pid', 'min' : 0, 'len' : 7, 'size' : 2, 'ppos' : 1, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Roll I', 'unit' : ''},
  'RollD' : {'steps' : 50, 'default' : 500, 'adr' : 6, 'max' : 8000, 'page' : 'pid', 'min' : 0, 'len' : 3, 'size' : 2, 'ppos' : 4, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Roll D', 'unit' : ''},
  'RollMotorVmax' : {'steps' : 1, 'default' : 150, 'adr' : 7, 'max' : 255, 'page' : 'pid', 'min' : 0, 'len' : 5, 'size' : 2, 'ppos' : 0, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Roll Motor Vmax', 'unit' : ''},
  'YawP' : {'steps' : 10, 'default' : 400, 'adr' : 8, 'max' : 3000, 'page' : 'pid', 'min' : 0, 'len' : 5, 'size' : 2, 'ppos' : 2, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'pos' : [4, 1], 'name' : 'Yaw P', 'unit' : ''},
  'YawI' : {'steps' : 50, 'default' : 1000, 'adr' : 9, 'max' : 32000, 'page' : 'pid', 'min' : 0, 'len' : 7, 'size' : 2, 'ppos' : 1, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Yaw I', 'unit' : ''},
  'YawD' : {'steps' : 50, 'default' : 500, 'adr' : 10, 'max' : 8000, 'page' : 'pid', 'min' : 0, 'len' : 3, 'size' : 2, 'ppos' : 4, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Yaw D', 'unit' : ''},
  'YawMotorVmax' : {'steps' : 1, 'default' : 150, 'adr' : 11, 'max' : 255, 'page' : 'pid', 'min' : 0, 'len' : 5, 'size' : 2, 'ppos' : 0, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Yaw Motor Vmax', 'unit' : ''},
  'FocPitchP' : {'steps' : 10, 'default' : 400, 'adr' : 23, 'max' : 3000, 'page' : 'pid', 'min' : 0, 'len' : 5, 'size' : 2, 'ppos' : 2, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'pos' : [2, 1], 'name' : 'Foc Pitch P', 'unit' : ''},
  'FocPitchI' : {'steps' : 50, 'default' : 100, 'adr' : 24, 'max' : 32000, 'page' : 'pid', 'min' : 0, 'len' : 7, 'size' : 2, 'ppos' : 1, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Foc Pitch I', 'unit' : ''},
  'FocPitchD' : {'steps' : 50, 'default' : 2000, 'adr' : 25, 'max' : 8000, 'page' : 'pid', 'min' : 0, 'len' : 3, 'size' : 2, 'ppos' : 4, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Foc Pitch D', 'unit' : ''},
  'FocPitchK' : {'steps' : 1, 'default' : 10, 'adr' : 26, 'max' : 100, 'page' : 'pid', 'min' : 1, 'len' : 5, 'size' : 2, 'ppos' : 1, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Foc Pitch K', 'unit' : ''},
  'FocRollP' : {'steps' : 10, 'default' : 400, 'adr' : 29, 'max' : 3000, 'page' : 'pid', 'min' : 0, 'len' : 5, 'size' : 2, 'ppos' : 2, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'pos' : [3, 1], 'name' : 'Foc Roll P', 'unit' : ''},
  'FocRollI' : {'steps' : 50, 'default' : 100, 'adr' : 30, 'max' : 32000, 'page' : 'pid', 'min' : 0, 'len' : 7, 'size' : 2, 'ppos' : 1, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Foc Roll I', 'unit' : ''},
  'FocRollD' : {'steps' : 50, 'default' : 2000, 'adr' : 31, 'max' : 8000, 'page' : 'pid', 'min' : 0, 'len' : 3, 'size' : 2, 'ppos' : 4, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Foc Roll D', 'unit' : ''},
  'FocRollK' : {'steps' : 1, 'default' : 10, 'adr' : 32, 'max' : 100, 'page' : 'pid', 'min' : 1, 'len' : 5, 'size' : 2, 'ppos' : 1, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Foc Roll K', 'unit' : ''},
  'FocYawP' : {'steps' : 10, 'default' : 400, 'adr' : 35, 'max' : 3000, 'page' : 'pid', 'min' : 0, 'len' : 5, 'size' : 2, 'ppos' : 2, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'pos' : [4, 1], 'name' : 'Foc Yaw P', 'unit' : ''},
  'FocYawI' : {'steps' : 50, 'default' : 100, 'adr' : 36, 'max' : 32000, 'page' : 'pid', 'min' : 0, 'len' : 7, 'size' : 2, 'ppos' : 1, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Foc Yaw I', 'unit' : ''},
  'FocYawD' : {'steps' : 50, 'default' : 2000, 'adr' : 37, 'max' : 8000, 'page' : 'pid', 'min' : 0, 'len' : 3, 'size' : 2, 'ppos' : 4, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Foc Yaw D', 'unit' : ''},
  'FocYawK' : {'steps' : 1, 'default' : 10, 'adr' : 38, 'max' : 100, 'page' : 'pid', 'min' : 1, 'len' : 5, 'size' : 2, 'ppos' : 1, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Foc Yaw K', 'unit' : ''},
  'PanModeControl' : {'steps' : 1, 'default' : 0, 'column' : 1, 'adr' : 79, 'max' : 42, 'len' : 0, 'page' : 'pan', 'min' : 0, 'choices' : ['off', 'Rc-0', 'Rc-1', 'Rc-2', 'Rc2-0', 'Rc2-1', 'Rc2-2', 'Rc2-3', 'Pot-0', 'Pot-1', 'Pot-2', 'Virtual-1', 'Virtual-2', 'Virtual-3', 'Virtual-4', 'Virtual-5', 'Virtual-6', 'Virtual-7', 'Virtual-8', 'Virtual-9', 'Virtual-10', 'Virtual-11', 'Virtual-12', 'Virtual-13', 'Virtual-14', 'Virtual-15', 'Virtual-16', 'But switch', 'But latch', 'But step', 'Aux-0 switch', 'Aux-1 switch', 'Aux-2 switch', 'Aux-01 switch', 'Aux-012 switch', 'Aux-0 latch', 'Aux-1 latch', 'Aux-2 latch', 'Aux-01 latch', 'Aux-012 latch', 'Aux-0 step', 'Aux-1 step', 'Aux-2 step'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'name' : 'Pan Mode Control', 'ppos' : 0},
  'PanModeDefaultSetting' : {'steps' : 1, 'default' : 0, 'adr' : 80, 'max' : 5, 'len' : 0, 'page' : 'pan', 'min' : 0, 'choices' : ['hold hold pan', 'hold hold hold', 'pan pan pan', 'pan hold hold', 'pan hold pan', 'hold pan pan', 'off'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'name' : 'Pan Mode Default Setting', 'ppos' : 0},
  'PanModeSetting1' : {'steps' : 1, 'default' : 1, 'adr' : 81, 'max' : 6, 'len' : 0, 'page' : 'pan', 'min' : 0, 'choices' : ['hold hold pan', 'hold hold hold', 'pan pan pan', 'pan hold hold', 'pan hold pan', 'hold pan pan', 'off'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'name' : 'Pan Mode Setting #1', 'ppos' : 0},
  'PanModeSetting2' : {'steps' : 1, 'default' : 4, 'adr' : 82, 'max' : 6, 'len' : 0, 'page' : 'pan', 'min' : 0, 'choices' : ['hold hold pan', 'hold hold hold', 'pan pan pan', 'pan hold hold', 'pan hold pan', 'hold pan pan', 'off'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'name' : 'Pan Mode Setting #2', 'ppos' : 0},
  'PanModeSetting3' : {'steps' : 1, 'default' : 2, 'adr' : 83, 'max' : 6, 'len' : 0, 'page' : 'pan', 'min' : 0, 'choices' : ['hold hold pan', 'hold hold hold', 'pan pan pan', 'pan hold hold', 'pan hold pan', 'hold pan pan', 'off'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'name' : 'Pan Mode Setting #3', 'ppos' : 0},
  'PitchPan' : {'steps' : 1, 'default' : 20, 'column' : 2, 'adr' : 84, 'max' : 50, 'page' : 'pan', 'min' : 0, 'len' : 5, 'size' : 2, 'ppos' : 1, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Pitch Pan', 'unit' : ''},
  'PitchPanDeadband' : {'steps' : 10, 'default' : 0, 'adr' : 85, 'max' : 600, 'page' : 'pan', 'min' : 0, 'len' : 5, 'size' : 2, 'ppos' : 1, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'pos' : [2, 3], 'name' : 'Pitch Pan Deadband', 'unit' : '\u00b0'},
  'PitchPanExpo' : {'steps' : 1, 'default' : 0, 'adr' : 86, 'max' : 100, 'page' : 'pan', 'min' : 0, 'len' : 5, 'size' : 2, 'ppos' : 0, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Pitch Pan Expo', 'unit' : '%'},
  'RollPan' : {'steps' : 1, 'default' : 20, 'column' : 3, 'adr' : 87, 'max' : 50, 'page' : 'pan', 'min' : 0, 'len' : 5, 'size' : 2, 'ppos' : 1, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Roll Pan', 'unit' : ''},
  'RollPanDeadband' : {'steps' : 10, 'default' : 0, 'adr' : 88, 'max' : 600, 'page' : 'pan', 'min' : 0, 'len' : 5, 'size' : 2, 'ppos' : 1, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'pos' : [3, 3], 'name' : 'Roll Pan Deadband', 'unit' : '\u00b0'},
  'RollPanExpo' : {'steps' : 1, 'default' : 0, 'adr' : 89, 'max' : 100, 'page' : 'pan', 'min' : 0, 'len' : 5, 'size' : 2, 'ppos' : 0, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Roll Pan Expo', 'unit' : '%'},
  'YawPan' : {'steps' : 1, 'default' : 20, 'column' : 4, 'adr' : 90, 'max' : 50, 'page' : 'pan', 'min' : 0, 'len' : 5, 'size' : 2, 'ppos' : 1, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Yaw Pan', 'unit' : ''},
  'YawPanDeadband' : {'steps' : 5, 'default' : 50, 'adr' : 91, 'max' : 100, 'page' : 'pan', 'min' : 0, 'len' : 5, 'size' : 2, 'ppos' : 1, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'pos' : [4, 3], 'name' : 'Yaw Pan Deadband', 'unit' : '\u00b0'},
  'YawPanExpo' : {'steps' : 1, 'default' : 0, 'adr' : 92, 'max' : 100, 'page' : 'pan', 'min' : 0, 'len' : 5, 'size' : 2, 'ppos' : 0, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Yaw Pan Expo', 'unit' : '%'},
  'YawPanDeadbandLPF' : {'steps' : 5, 'default' : 150, 'adr' : 93, 'max' : 300, 'page' : 'pan', 'min' : 0, 'len' : 5, 'size' : 2, 'ppos' : 2, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Yaw Pan Deadband LPF', 'unit' : 's'},
  'YawPanDeadbandHysteresis' : {'steps' : 1, 'default' : 0, 'adr' : 94, 'max' : 50, 'page' : 'pan', 'min' : 0, 'len' : 5, 'size' : 2, 'ppos' : 1, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'pos' : [4, 6], 'name' : 'Yaw Pan Deadband Hysteresis', 'unit' : '\u00b0'},
  'RcDeadBand' : {'steps' : 1, 'default' : 10, 'adr' : 96, 'max' : 50, 'page' : 'rcinputs', 'min' : 0, 'len' : 0, 'size' : 2, 'ppos' : 0, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Rc Dead Band', 'unit' : 'us'},
  'RcHysteresis' : {'steps' : 1, 'default' : 5, 'adr' : 97, 'max' : 50, 'page' : 'rcinputs', 'min' : 0, 'len' : 0, 'size' : 2, 'ppos' : 0, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Rc Hysteresis', 'unit' : 'us'},
  'RcPitchTrim' : {'steps' : 1, 'default' : 0, 'adr' : 104, 'max' : 100, 'page' : 'rcinputs', 'min' : -100, 'len' : 0, 'size' : 2, 'ppos' : 0, 'type' : 'OPTTYPE_SI', 'hidden' : 0, 'pos' : [1, 4], 'name' : 'Rc Pitch Trim', 'unit' : 'us'},
  'RcRollTrim' : {'steps' : 1, 'default' : 0, 'adr' : 111, 'max' : 100, 'page' : 'rcinputs', 'min' : -100, 'len' : 0, 'size' : 2, 'ppos' : 0, 'type' : 'OPTTYPE_SI', 'hidden' : 0, 'name' : 'Rc Roll Trim', 'unit' : 'us'},
  'RcYawTrim' : {'steps' : 1, 'default' : 0, 'adr' : 118, 'max' : 100, 'page' : 'rcinputs', 'min' : -100, 'len' : 0, 'size' : 2, 'ppos' : 0, 'type' : 'OPTTYPE_SI', 'hidden' : 0, 'name' : 'Rc Yaw Trim', 'unit' : 'us'},
  'RcPitch' : {'steps' : 1, 'default' : 0, 'column' : 2, 'adr' : 102, 'max' : 42, 'len' : 0, 'page' : 'rcinputs', 'min' : 0, 'choices' : ['off', 'Rc-0', 'Rc-1', 'Rc-2', 'Rc2-0', 'Rc2-1', 'Rc2-2', 'Rc2-3', 'Pot-0', 'Pot-1', 'Pot-2', 'Virtual-1', 'Virtual-2', 'Virtual-3', 'Virtual-4', 'Virtual-5', 'Virtual-6', 'Virtual-7', 'Virtual-8', 'Virtual-9', 'Virtual-10', 'Virtual-11', 'Virtual-12', 'Virtual-13', 'Virtual-14', 'Virtual-15', 'Virtual-16', 'But switch', 'But latch', 'But step', 'Aux-0 switch', 'Aux-1 switch', 'Aux-2 switch', 'Aux-01 switch', 'Aux-012 switch', 'Aux-0 latch', 'Aux-1 latch', 'Aux-2 latch', 'Aux-01 latch', 'Aux-012 latch', 'Aux-0 step', 'Aux-1 step', 'Aux-2 step'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'name' : 'Rc Pitch', 'ppos' : 0},
  'RcPitchMode' : {'steps' : 1, 'default' : 0, 'adr' : 103, 'max' : 2, 'len' : 0, 'page' : 'rcinputs', 'min' : 0, 'choices' : ['absolute', 'relative', 'absolute centered'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'name' : 'Rc Pitch Mode', 'ppos' : 0},
  'RcPitchMin' : {'steps' : 5, 'default' : -250, 'adr' : 105, 'max' : 1200, 'page' : 'rcinputs', 'min' : -1200, 'len' : 0, 'size' : 2, 'ppos' : 1, 'type' : 'OPTTYPE_SI', 'hidden' : 0, 'name' : 'Rc Pitch Min', 'unit' : '\u00b0'},
  'RcPitchMax' : {'steps' : 5, 'default' : 250, 'adr' : 106, 'max' : 1200, 'page' : 'rcinputs', 'min' : -1200, 'len' : 0, 'size' : 2, 'ppos' : 1, 'type' : 'OPTTYPE_SI', 'hidden' : 0, 'name' : 'Rc Pitch Max', 'unit' : '\u00b0'},
  'RcPitchSpeedLimit' : {'steps' : 5, 'default' : 400, 'adr' : 107, 'max' : 1000, 'page' : 'rcinputs', 'min' : 0, 'len' : 0, 'size' : 2, 'ppos' : 1, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Rc Pitch Speed Limit', 'unit' : '\u00b0/s'},
  'RcPitchAccelLimit' : {'steps' : 10, 'default' : 300, 'adr' : 108, 'max' : 1000, 'page' : 'rcinputs', 'min' : 0, 'len' : 0, 'size' : 2, 'ppos' : 3, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Rc Pitch Accel Limit', 'unit' : ''},
  'RcRoll' : {'steps' : 1, 'default' : 0, 'column' : 3, 'adr' : 109, 'max' : 42, 'len' : 0, 'page' : 'rcinputs', 'min' : 0, 'choices' : ['off', 'Rc-0', 'Rc-1', 'Rc-2', 'Rc2-0', 'Rc2-1', 'Rc2-2', 'Rc2-3', 'Pot-0', 'Pot-1', 'Pot-2', 'Virtual-1', 'Virtual-2', 'Virtual-3', 'Virtual-4', 'Virtual-5', 'Virtual-6', 'Virtual-7', 'Virtual-8', 'Virtual-9', 'Virtual-10', 'Virtual-11', 'Virtual-12', 'Virtual-13', 'Virtual-14', 'Virtual-15', 'Virtual-16', 'But switch', 'But latch', 'But step', 'Aux-0 switch', 'Aux-1 switch', 'Aux-2 switch', 'Aux-01 switch', 'Aux-012 switch', 'Aux-0 latch', 'Aux-1 latch', 'Aux-2 latch', 'Aux-01 latch', 'Aux-012 latch', 'Aux-0 step', 'Aux-1 step', 'Aux-2 step'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'name' : 'Rc Roll', 'ppos' : 0},
  'RcRollMode' : {'steps' : 1, 'default' : 0, 'adr' : 110, 'max' : 2, 'len' : 0, 'page' : 'rcinputs', 'min' : 0, 'choices' : ['absolute', 'relative', 'absolute centered'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'name' : 'Rc Roll Mode', 'ppos' : 0},
  'RcRollMin' : {'steps' : 5, 'default' : -250, 'adr' : 112, 'max' : 450, 'page' : 'rcinputs', 'min' : -450, 'len' : 0, 'size' : 2, 'ppos' : 1, 'type' : 'OPTTYPE_SI', 'hidden' : 0, 'name' : 'Rc Roll Min', 'unit' : '\u00b0'},
  'RcRollMax' : {'steps' : 5, 'default' : 250, 'adr' : 113, 'max' : 450, 'page' : 'rcinputs', 'min' : -450, 'len' : 0, 'size' : 2, 'ppos' : 1, 'type' : 'OPTTYPE_SI', 'hidden' : 0, 'name' : 'Rc Roll Max', 'unit' : '\u00b0'},
  'RcRollSpeedLimit' : {'steps' : 5, 'default' : 400, 'adr' : 114, 'max' : 1000, 'page' : 'rcinputs', 'min' : 0, 'len' : 0, 'size' : 2, 'ppos' : 1, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Rc Roll Speed Limit', 'unit' : '\u00b0/s'},
  'RcRollAccelLimit' : {'steps' : 10, 'default' : 300, 'adr' : 115, 'max' : 1000, 'page' : 'rcinputs', 'min' : 0, 'len' : 0, 'size' : 2, 'ppos' : 3, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Rc Roll Accel Limit', 'unit' : ''},
  'RcYaw' : {'steps' : 1, 'default' : 0, 'column' : 4, 'adr' : 116, 'max' : 42, 'len' : 0, 'page' : 'rcinputs', 'min' : 0, 'choices' : ['off', 'Rc-0', 'Rc-1', 'Rc-2', 'Rc2-0', 'Rc2-1', 'Rc2-2', 'Rc2-3', 'Pot-0', 'Pot-1', 'Pot-2', 'Virtual-1', 'Virtual-2', 'Virtual-3', 'Virtual-4', 'Virtual-5', 'Virtual-6', 'Virtual-7', 'Virtual-8', 'Virtual-9', 'Virtual-10', 'Virtual-11', 'Virtual-12', 'Virtual-13', 'Virtual-14', 'Virtual-15', 'Virtual-16', 'But switch', 'But latch', 'But step', 'Aux-0 switch', 'Aux-1 switch', 'Aux-2 switch', 'Aux-01 switch', 'Aux-012 switch', 'Aux-0 latch', 'Aux-1 latch', 'Aux-2 latch', 'Aux-01 latch', 'Aux-012 latch', 'Aux-0 step', 'Aux-1 step', 'Aux-2 step'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'name' : 'Rc Yaw', 'ppos' : 0},
  'RcYawMode' : {'steps' : 1, 'default' : 0, 'adr' : 117, 'max' : 3, 'len' : 0, 'page' : 'rcinputs', 'min' : 0, 'choices' : ['absolute', 'relative', 'absolute centered', 'relative turn around'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'name' : 'Rc Yaw Mode', 'ppos' : 0},
  'RcYawMin' : {'steps' : 10, 'default' : -250, 'adr' : 119, 'max' : 2700, 'page' : 'rcinputs', 'min' : -2700, 'len' : 0, 'size' : 2, 'ppos' : 1, 'type' : 'OPTTYPE_SI', 'hidden' : 0, 'name' : 'Rc Yaw Min', 'unit' : '\u00b0'},
  'RcYawMax' : {'steps' : 10, 'default' : 250, 'adr' : 120, 'max' : 2700, 'page' : 'rcinputs', 'min' : -2700, 'len' : 0, 'size' : 2, 'ppos' : 1, 'type' : 'OPTTYPE_SI', 'hidden' : 0, 'name' : 'Rc Yaw Max', 'unit' : '\u00b0'},
  'RcYawSpeedLimit' : {'steps' : 5, 'default' : 400, 'adr' : 121, 'max' : 1000, 'page' : 'rcinputs', 'min' : 0, 'len' : 0, 'size' : 2, 'ppos' : 1, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Rc Yaw Speed Limit', 'unit' : '\u00b0/s'},
  'RcYawAccelLimit' : {'steps' : 10, 'default' : 300, 'adr' : 122, 'max' : 1000, 'page' : 'rcinputs', 'min' : 0, 'len' : 0, 'size' : 2, 'ppos' : 3, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Rc Yaw Accel Limit', 'unit' : ''},
  'Standby' : {'steps' : 1, 'default' : 0, 'column' : 1, 'adr' : 123, 'max' : 42, 'len' : 0, 'page' : 'functions', 'min' : 0, 'choices' : ['off', 'Rc-0', 'Rc-1', 'Rc-2', 'Rc2-0', 'Rc2-1', 'Rc2-2', 'Rc2-3', 'Pot-0', 'Pot-1', 'Pot-2', 'Virtual-1', 'Virtual-2', 'Virtual-3', 'Virtual-4', 'Virtual-5', 'Virtual-6', 'Virtual-7', 'Virtual-8', 'Virtual-9', 'Virtual-10', 'Virtual-11', 'Virtual-12', 'Virtual-13', 'Virtual-14', 'Virtual-15', 'Virtual-16', 'But switch', 'But latch', 'But step', 'Aux-0 switch', 'Aux-1 switch', 'Aux-2 switch', 'Aux-01 switch', 'Aux-012 switch', 'Aux-0 latch', 'Aux-1 latch', 'Aux-2 latch', 'Aux-01 latch', 'Aux-012 latch', 'Aux-0 step', 'Aux-1 step', 'Aux-2 step'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'name' : 'Standby', 'ppos' : 0},
  'RecenterCamera' : {'steps' : 1, 'default' : 0, 'adr' : 124, 'max' : 42, 'len' : 0, 'page' : 'functions', 'min' : 0, 'choices' : ['off', 'Rc-0', 'Rc-1', 'Rc-2', 'Rc2-0', 'Rc2-1', 'Rc2-2', 'Rc2-3', 'Pot-0', 'Pot-1', 'Pot-2', 'Virtual-1', 'Virtual-2', 'Virtual-3', 'Virtual-4', 'Virtual-5', 'Virtual-6', 'Virtual-7', 'Virtual-8', 'Virtual-9', 'Virtual-10', 'Virtual-11', 'Virtual-12', 'Virtual-13', 'Virtual-14', 'Virtual-15', 'Virtual-16', 'But switch', 'But latch', 'But step', 'Aux-0 switch', 'Aux-1 switch', 'Aux-2 switch', 'Aux-01 switch', 'Aux-012 switch', 'Aux-0 latch', 'Aux-1 latch', 'Aux-2 latch', 'Aux-01 latch', 'Aux-012 latch', 'Aux-0 step', 'Aux-1 step', 'Aux-2 step'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'pos' : [1, 3], 'name' : 'Re-center Camera', 'ppos' : 0},
  'IRCameraControl' : {'steps' : 1, 'default' : 0, 'column' : 2, 'adr' : 125, 'max' : 42, 'len' : 0, 'page' : 'functions', 'min' : 0, 'choices' : ['off', 'Rc-0', 'Rc-1', 'Rc-2', 'Rc2-0', 'Rc2-1', 'Rc2-2', 'Rc2-3', 'Pot-0', 'Pot-1', 'Pot-2', 'Virtual-1', 'Virtual-2', 'Virtual-3', 'Virtual-4', 'Virtual-5', 'Virtual-6', 'Virtual-7', 'Virtual-8', 'Virtual-9', 'Virtual-10', 'Virtual-11', 'Virtual-12', 'Virtual-13', 'Virtual-14', 'Virtual-15', 'Virtual-16', 'But switch', 'But latch', 'But step', 'Aux-0 switch', 'Aux-1 switch', 'Aux-2 switch', 'Aux-01 switch', 'Aux-012 switch', 'Aux-0 latch', 'Aux-1 latch', 'Aux-2 latch', 'Aux-01 latch', 'Aux-012 latch', 'Aux-0 step', 'Aux-1 step', 'Aux-2 step'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'name' : 'IR Camera Control', 'ppos' : 0},
  'CameraModel' : {'steps' : 1, 'default' : 0, 'adr' : 126, 'max' : 5, 'len' : 0, 'page' : 'functions', 'min' : 0, 'choices' : ['Sony Nex', 'Canon', 'Panasonic', 'Nikon', 'Git2 Rc', 'CAMremote'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'name' : 'Camera Model', 'ppos' : 0},
  'IRCameraSetting1' : {'steps' : 1, 'default' : 0, 'adr' : 127, 'max' : 2, 'len' : 0, 'page' : 'functions', 'min' : 0, 'choices' : ['shutter', 'shutter delay', 'video on/off'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'name' : 'IR Camera Setting #1', 'ppos' : 0},
  'IRCameraSetting2' : {'steps' : 1, 'default' : 2, 'adr' : 128, 'max' : 3, 'len' : 0, 'page' : 'functions', 'min' : 0, 'choices' : ['shutter', 'shutter delay', 'video on/off', 'off'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'name' : 'IR Camera Setting #2', 'ppos' : 0},
  'TimeInterval' : {'steps' : 1, 'default' : 0, 'adr' : 129, 'max' : 150, 'page' : 'functions', 'min' : 0, 'len' : 0, 'size' : 2, 'ppos' : 1, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Time Interval', 'unit' : 's'},
  'PwmOutControl' : {'steps' : 1, 'default' : 0, 'column' : 3, 'adr' : 130, 'max' : 42, 'len' : 0, 'page' : 'functions', 'min' : 0, 'choices' : ['off', 'Rc-0', 'Rc-1', 'Rc-2', 'Rc2-0', 'Rc2-1', 'Rc2-2', 'Rc2-3', 'Pot-0', 'Pot-1', 'Pot-2', 'Virtual-1', 'Virtual-2', 'Virtual-3', 'Virtual-4', 'Virtual-5', 'Virtual-6', 'Virtual-7', 'Virtual-8', 'Virtual-9', 'Virtual-10', 'Virtual-11', 'Virtual-12', 'Virtual-13', 'Virtual-14', 'Virtual-15', 'Virtual-16', 'But switch', 'But latch', 'But step', 'Aux-0 switch', 'Aux-1 switch', 'Aux-2 switch', 'Aux-01 switch', 'Aux-012 switch', 'Aux-0 latch', 'Aux-1 latch', 'Aux-2 latch', 'Aux-01 latch', 'Aux-012 latch', 'Aux-0 step', 'Aux-1 step', 'Aux-2 step'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'name' : 'Pwm Out Control', 'ppos' : 0},
  'PwmOutMid' : {'steps' : 1, 'default' : 1500, 'adr' : 131, 'max' : 2100, 'page' : 'functions', 'min' : 900, 'len' : 0, 'size' : 2, 'ppos' : 0, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Pwm Out Mid', 'unit' : 'us'},
  'PwmOutMin' : {'steps' : 10, 'default' : 1100, 'adr' : 132, 'max' : 2100, 'page' : 'functions', 'min' : 900, 'len' : 0, 'size' : 2, 'ppos' : 0, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Pwm Out Min', 'unit' : 'us'},
  'PwmOutMax' : {'steps' : 10, 'default' : 1900, 'adr' : 133, 'max' : 2100, 'page' : 'functions', 'min' : 900, 'len' : 0, 'size' : 2, 'ppos' : 0, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Pwm Out Max', 'unit' : 'us'},
  'PwmOutSpeedLimit' : {'steps' : 5, 'default' : 0, 'adr' : 134, 'max' : 1000, 'page' : 'functions', 'min' : 0, 'len' : 0, 'size' : 2, 'ppos' : 0, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Pwm Out Speed Limit', 'unit' : 'us/s'},
  'Script1Control' : {'steps' : 1, 'default' : 0, 'column' : 1, 'adr' : 147, 'max' : 42, 'len' : 0, 'page' : 'scripts', 'min' : 0, 'choices' : ['off', 'Rc-0', 'Rc-1', 'Rc-2', 'Rc2-0', 'Rc2-1', 'Rc2-2', 'Rc2-3', 'Pot-0', 'Pot-1', 'Pot-2', 'Virtual-1', 'Virtual-2', 'Virtual-3', 'Virtual-4', 'Virtual-5', 'Virtual-6', 'Virtual-7', 'Virtual-8', 'Virtual-9', 'Virtual-10', 'Virtual-11', 'Virtual-12', 'Virtual-13', 'Virtual-14', 'Virtual-15', 'Virtual-16', 'But switch', 'But latch', 'But step', 'Aux-0 switch', 'Aux-1 switch', 'Aux-2 switch', 'Aux-01 switch', 'Aux-012 switch', 'Aux-0 latch', 'Aux-1 latch', 'Aux-2 latch', 'Aux-01 latch', 'Aux-012 latch', 'Aux-0 step', 'Aux-1 step', 'Aux-2 step'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'name' : 'Script1 Control', 'ppos' : 0},
  'Script2Control' : {'steps' : 1, 'default' : 0, 'column' : 2, 'adr' : 148, 'max' : 42, 'len' : 0, 'page' : 'scripts', 'min' : 0, 'choices' : ['off', 'Rc-0', 'Rc-1', 'Rc-2', 'Rc2-0', 'Rc2-1', 'Rc2-2', 'Rc2-3', 'Pot-0', 'Pot-1', 'Pot-2', 'Virtual-1', 'Virtual-2', 'Virtual-3', 'Virtual-4', 'Virtual-5', 'Virtual-6', 'Virtual-7', 'Virtual-8', 'Virtual-9', 'Virtual-10', 'Virtual-11', 'Virtual-12', 'Virtual-13', 'Virtual-14', 'Virtual-15', 'Virtual-16', 'But switch', 'But latch', 'But step', 'Aux-0 switch', 'Aux-1 switch', 'Aux-2 switch', 'Aux-01 switch', 'Aux-012 switch', 'Aux-0 latch', 'Aux-1 latch', 'Aux-2 latch', 'Aux-01 latch', 'Aux-012 latch', 'Aux-0 step', 'Aux-1 step', 'Aux-2 step'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'name' : 'Script2 Control', 'ppos' : 0},
  'Script3Control' : {'steps' : 1, 'default' : 0, 'column' : 3, 'adr' : 149, 'max' : 42, 'len' : 0, 'page' : 'scripts', 'min' : 0, 'choices' : ['off', 'Rc-0', 'Rc-1', 'Rc-2', 'Rc2-0', 'Rc2-1', 'Rc2-2', 'Rc2-3', 'Pot-0', 'Pot-1', 'Pot-2', 'Virtual-1', 'Virtual-2', 'Virtual-3', 'Virtual-4', 'Virtual-5', 'Virtual-6', 'Virtual-7', 'Virtual-8', 'Virtual-9', 'Virtual-10', 'Virtual-11', 'Virtual-12', 'Virtual-13', 'Virtual-14', 'Virtual-15', 'Virtual-16', 'But switch', 'But latch', 'But step', 'Aux-0 switch', 'Aux-1 switch', 'Aux-2 switch', 'Aux-01 switch', 'Aux-012 switch', 'Aux-0 latch', 'Aux-1 latch', 'Aux-2 latch', 'Aux-01 latch', 'Aux-012 latch', 'Aux-0 step', 'Aux-1 step', 'Aux-2 step'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'name' : 'Script3 Control', 'ppos' : 0},
  'Script4Control' : {'steps' : 1, 'default' : 0, 'column' : 4, 'adr' : 150, 'max' : 42, 'len' : 0, 'page' : 'scripts', 'min' : 0, 'choices' : ['off', 'Rc-0', 'Rc-1', 'Rc-2', 'Rc2-0', 'Rc2-1', 'Rc2-2', 'Rc2-3', 'Pot-0', 'Pot-1', 'Pot-2', 'Virtual-1', 'Virtual-2', 'Virtual-3', 'Virtual-4', 'Virtual-5', 'Virtual-6', 'Virtual-7', 'Virtual-8', 'Virtual-9', 'Virtual-10', 'Virtual-11', 'Virtual-12', 'Virtual-13', 'Virtual-14', 'Virtual-15', 'Virtual-16', 'But switch', 'But latch', 'But step', 'Aux-0 switch', 'Aux-1 switch', 'Aux-2 switch', 'Aux-01 switch', 'Aux-012 switch', 'Aux-0 latch', 'Aux-1 latch', 'Aux-2 latch', 'Aux-01 latch', 'Aux-012 latch', 'Aux-0 step', 'Aux-1 step', 'Aux-2 step'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'name' : 'Script4 Control', 'ppos' : 0},
  'Scripts' : {'steps' : 0, 'default' : '', 'adr' : 151, 'max' : 0, 'page' : 'scripts', 'min' : 0, 'len' : 0, 'size' : 128, 'ppos' : 0, 'type' : 'OPTTYPE_SCRIPT', 'hidden' : 1, 'name' : 'Scripts', 'unit' : ''},
  'Imu2Configuration' : {'steps' : 1, 'default' : 0, 'adr' : 53, 'max' : 2, 'len' : 0, 'page' : 'setup', 'min' : 0, 'choices' : ['off', 'full', 'full xy'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'name' : 'Imu2 Configuration', 'ppos' : 0},
  'StartupMode' : {'steps' : 1, 'default' : 0, 'adr' : 140, 'max' : 1, 'len' : 0, 'page' : 'setup', 'min' : 0, 'choices' : ['normal', 'fast'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'pos' : [1, 4], 'name' : 'Startup Mode', 'ppos' : 0},
  'StartupDelay' : {'steps' : 5, 'default' : 0, 'adr' : 141, 'max' : 250, 'page' : 'setup', 'min' : 0, 'len' : 0, 'size' : 2, 'ppos' : 1, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Startup Delay', 'unit' : 's'},
  'ImuAHRS' : {'steps' : 100, 'default' : 1000, 'adr' : 61, 'max' : 2500, 'page' : 'setup', 'min' : 0, 'len' : 5, 'size' : 2, 'ppos' : 2, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Imu AHRS', 'unit' : 's'},
  'VirtualChannelConfiguration' : {'steps' : 1, 'default' : 0, 'column' : 2, 'adr' : 77, 'max' : 11, 'len' : 0, 'page' : 'setup', 'min' : 0, 'choices' : ['off', 'sum ppm 6', 'sum ppm 7', 'sum ppm 8', 'sum ppm 10', 'sum ppm 12', 'spektrum 10 bit', 'spektrum 11 bit', 'sbus', 'hott sumd', 'srxl', 'serial'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'name' : 'Virtual Channel Configuration', 'ppos' : 0},
  'PwmOutConfiguration' : {'steps' : 1, 'default' : 0, 'adr' : 78, 'max' : 2, 'len' : 0, 'page' : 'setup', 'min' : 0, 'choices' : ['off', '1520 us 55 Hz', '1520 us 250 Hz'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'name' : 'Pwm Out Configuration', 'ppos' : 0},
  'RcPitchOffset' : {'steps' : 5, 'default' : 0, 'adr' : 99, 'max' : 1200, 'page' : 'setup', 'min' : -1200, 'len' : 0, 'size' : 2, 'ppos' : 1, 'type' : 'OPTTYPE_SI', 'hidden' : 0, 'pos' : [2, 4], 'name' : 'Rc Pitch Offset', 'unit' : '\u00b0'},
  'RcRollOffset' : {'steps' : 5, 'default' : 0, 'adr' : 100, 'max' : 1200, 'page' : 'setup', 'min' : -1200, 'len' : 0, 'size' : 2, 'ppos' : 1, 'type' : 'OPTTYPE_SI', 'hidden' : 0, 'name' : 'Rc Roll Offset', 'unit' : '\u00b0'},
  'RcYawOffset' : {'steps' : 5, 'default' : 0, 'adr' : 101, 'max' : 1200, 'page' : 'setup', 'min' : -1200, 'len' : 0, 'size' : 2, 'ppos' : 1, 'type' : 'OPTTYPE_SI', 'hidden' : 0, 'name' : 'Rc Yaw Offset', 'unit' : '\u00b0'},
  'LowVoltageLimit' : {'steps' : 1, 'default' : 1, 'adr' : 74, 'max' : 7, 'len' : 0, 'page' : 'setup', 'min' : 0, 'choices' : ['off', '2.9 V/cell', '3.0 V/cell', '3.1 V/cell', '3.2 V/cell', '3.3 V/cell', '3.4 V/cell', '3.5 V/cell'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'pos' : [3, 4], 'name' : 'Low Voltage Limit', 'ppos' : 0},
  'BeepwithMotors' : {'steps' : 1, 'default' : 0, 'adr' : 143, 'max' : 2, 'len' : 0, 'page' : 'setup', 'min' : 0, 'choices' : ['off', 'basic', 'all'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'name' : 'Beep with Motors', 'ppos' : 0},
  'NTLogging' : {'steps' : 1, 'default' : 0, 'adr' : 142, 'max' : 7, 'len' : 0, 'page' : 'setup', 'min' : 0, 'choices' : ['off', 'basic', 'basic + pid', 'basic + accgyro', 'basic + accgyro_raw', 'basic + pid + accgyro', 'basic + pid + ag_raw', 'full'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'name' : 'NT Logging', 'ppos' : 0},
  'PitchMotorUsage' : {'steps' : 1, 'default' : 3, 'column' : 4, 'adr' : 55, 'max' : 3, 'len' : 0, 'page' : 'setup', 'min' : 0, 'choices' : ['normal', 'level', 'startup pos', 'disabled'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'name' : 'Pitch Motor Usage', 'ppos' : 0},
  'RollMotorUsage' : {'steps' : 1, 'default' : 3, 'adr' : 56, 'max' : 3, 'len' : 0, 'page' : 'setup', 'min' : 0, 'choices' : ['normal', 'level', 'startup pos', 'disabled'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'name' : 'Roll Motor Usage', 'ppos' : 0},
  'YawMotorUsage' : {'steps' : 1, 'default' : 3, 'adr' : 57, 'max' : 3, 'len' : 0, 'page' : 'setup', 'min' : 0, 'choices' : ['normal', 'level', 'startup pos', 'disabled'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'name' : 'Yaw Motor Usage', 'ppos' : 0},
  'ImuOrientation' : {'steps' : 1, 'default' : 0, 'adr' : 51, 'max' : 23, 'len' : 0, 'page' : 'gimbalconfig', 'min' : 0, 'choices' : ['no.0 :  z0\u00b0   x  y  z', 'no.1 :  z90\u00b0  -y  x  z', 'no.2 :  z180\u00b0  -x -y  z', 'no.3 :  z270\u00b0   y -x  z', 'no.4 :  x0\u00b0   y  z  x', 'no.5 :  x90\u00b0  -z  y  x', 'no.6 :  x180\u00b0  -y -z  x', 'no.7 :  x270\u00b0   z -y  x', 'no.8 :  y0\u00b0   z  x  y', 'no.9 :  y90\u00b0  -x  z  y', 'no.10 :  y180\u00b0  -z -x  y', 'no.11 :  y270\u00b0   x -z  y', 'no.12 :  -z0\u00b0   y  x -z', 'no.13 :  -z90\u00b0  -x  y -z', 'no.14 :  -z180\u00b0  -y -x -z', 'no.15 :  -z270\u00b0   x -y -z', 'no.16 :  -x0\u00b0   z  y -x', 'no.17 :  -x90\u00b0  -y  z -x', 'no.18 :  -x180\u00b0  -z -y -x', 'no.19 :  -x270\u00b0   y -z -x', 'no.20 :  -y0\u00b0   x  z -y', 'no.21 :  -y90\u00b0  -z  x -y', 'no.22 :  -y180\u00b0  -x -z -y', 'no.23 :  -y270\u00b0   z -x -y'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'pos' : [1, 1], 'name' : 'Imu Orientation', 'ppos' : 0},
  'Imu2Orientation' : {'steps' : 1, 'default' : 0, 'adr' : 54, 'max' : 23, 'len' : 0, 'page' : 'gimbalconfig', 'min' : 0, 'choices' : ['no.0 :  z0\u00b0   x  y  z', 'no.1 :  z90\u00b0  -y  x  z', 'no.2 :  z180\u00b0  -x -y  z', 'no.3 :  z270\u00b0   y -x  z', 'no.4 :  x0\u00b0   y  z  x', 'no.5 :  x90\u00b0  -z  y  x', 'no.6 :  x180\u00b0  -y -z  x', 'no.7 :  x270\u00b0   z -y  x', 'no.8 :  y0\u00b0   z  x  y', 'no.9 :  y90\u00b0  -x  z  y', 'no.10 :  y180\u00b0  -z -x  y', 'no.11 :  y270\u00b0   x -z  y', 'no.12 :  -z0\u00b0   y  x -z', 'no.13 :  -z90\u00b0  -x  y -z', 'no.14 :  -z180\u00b0  -y -x -z', 'no.15 :  -z270\u00b0   x -y -z', 'no.16 :  -x0\u00b0   z  y -x', 'no.17 :  -x90\u00b0  -y  z -x', 'no.18 :  -x180\u00b0  -z -y -x', 'no.19 :  -x270\u00b0   y -z -x', 'no.20 :  -y0\u00b0   x  z -y', 'no.21 :  -y90\u00b0  -z  x -y', 'no.22 :  -y180\u00b0  -x -z -y', 'no.23 :  -y270\u00b0   z -x -y'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'name' : 'Imu2 Orientation', 'ppos' : 0},
  'PitchMotorPoles' : {'steps' : 2, 'default' : 14, 'adr' : 13, 'max' : 28, 'page' : 'gimbalconfig', 'min' : 12, 'len' : 0, 'size' : 2, 'ppos' : 0, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'pos' : [2, 1], 'name' : 'Pitch Motor Poles', 'unit' : ''},
  'PitchMotorDirection' : {'steps' : 1, 'default' : 2, 'adr' : 14, 'max' : 2, 'len' : 0, 'page' : 'gimbalconfig', 'min' : 0, 'choices' : ['normal', 'reversed', 'auto'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'name' : 'Pitch Motor Direction', 'ppos' : 0},
  'PitchStartupMotorPos' : {'steps' : 1, 'default' : 504, 'adr' : 15, 'max' : 1008, 'page' : 'gimbalconfig', 'min' : 0, 'len' : 5, 'size' : 2, 'ppos' : 0, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Pitch Startup Motor Pos', 'unit' : ''},
  'FocPitchMotorDirection' : {'steps' : 1, 'default' : 0, 'adr' : 42, 'max' : 1, 'len' : 0, 'page' : 'gimbalconfig', 'min' : 0, 'choices' : ['normal', 'reversed', 'auto'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'pos' : [2, 1], 'name' : 'Foc Pitch Motor Direction', 'ppos' : 0},
  'FocPitchZeroPos' : {'steps' : 8, 'default' : 0, 'adr' : 43, 'max' : 16383, 'page' : 'gimbalconfig', 'min' : -16384, 'len' : 5, 'size' : 2, 'ppos' : 0, 'type' : 'OPTTYPE_SI', 'hidden' : 0, 'name' : 'Foc Pitch Zero Pos', 'unit' : ''},
  'PitchOffset' : {'steps' : 5, 'default' : 0, 'adr' : 58, 'max' : 300, 'page' : 'gimbalconfig', 'min' : -300, 'len' : 5, 'size' : 2, 'ppos' : 2, 'type' : 'OPTTYPE_SI', 'hidden' : 0, 'pos' : [2, 4], 'name' : 'Pitch Offset', 'unit' : '\u00b0'},
  'RollMotorPoles' : {'steps' : 2, 'default' : 14, 'adr' : 16, 'max' : 28, 'page' : 'gimbalconfig', 'min' : 12, 'len' : 0, 'size' : 2, 'ppos' : 0, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'pos' : [3, 1], 'name' : 'Roll Motor Poles', 'unit' : ''},
  'RollMotorDirection' : {'steps' : 1, 'default' : 2, 'adr' : 17, 'max' : 2, 'len' : 0, 'page' : 'gimbalconfig', 'min' : 0, 'choices' : ['normal', 'reversed', 'auto'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'name' : 'Roll Motor Direction', 'ppos' : 0},
  'RollStartupMotorPos' : {'steps' : 1, 'default' : 504, 'adr' : 18, 'max' : 1008, 'page' : 'gimbalconfig', 'min' : 0, 'len' : 5, 'size' : 2, 'ppos' : 0, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Roll Startup Motor Pos', 'unit' : ''},
  'FocRollMotorDirection' : {'steps' : 1, 'default' : 0, 'adr' : 44, 'max' : 1, 'len' : 0, 'page' : 'gimbalconfig', 'min' : 0, 'choices' : ['normal', 'reversed', 'auto'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'pos' : [3, 1], 'name' : 'Foc Roll Motor Direction', 'ppos' : 0},
  'FocRollZeroPos' : {'steps' : 8, 'default' : 0, 'adr' : 45, 'max' : 16383, 'page' : 'gimbalconfig', 'min' : -16384, 'len' : 5, 'size' : 2, 'ppos' : 0, 'type' : 'OPTTYPE_SI', 'hidden' : 0, 'name' : 'Foc Roll Zero Pos', 'unit' : ''},
  'RollOffset' : {'steps' : 5, 'default' : 0, 'adr' : 59, 'max' : 300, 'page' : 'gimbalconfig', 'min' : -300, 'len' : 5, 'size' : 2, 'ppos' : 2, 'type' : 'OPTTYPE_SI', 'hidden' : 0, 'pos' : [3, 4], 'name' : 'Roll Offset', 'unit' : '\u00b0'},
  'YawMotorPoles' : {'steps' : 2, 'default' : 14, 'adr' : 19, 'max' : 28, 'page' : 'gimbalconfig', 'min' : 12, 'len' : 0, 'size' : 2, 'ppos' : 0, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'pos' : [4, 1], 'name' : 'Yaw Motor Poles', 'unit' : ''},
  'YawMotorDirection' : {'steps' : 1, 'default' : 2, 'adr' : 20, 'max' : 2, 'len' : 0, 'page' : 'gimbalconfig', 'min' : 0, 'choices' : ['normal', 'reversed', 'auto'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'name' : 'Yaw Motor Direction', 'ppos' : 0},
  'YawStartupMotorPos' : {'steps' : 1, 'default' : 504, 'adr' : 21, 'max' : 1008, 'page' : 'gimbalconfig', 'min' : 0, 'len' : 5, 'size' : 2, 'ppos' : 0, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Yaw Startup Motor Pos', 'unit' : ''},
  'FocYawMotorDirection' : {'steps' : 1, 'default' : 0, 'adr' : 46, 'max' : 1, 'len' : 0, 'page' : 'gimbalconfig', 'min' : 0, 'choices' : ['normal', 'reversed', 'auto'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'pos' : [4, 1], 'name' : 'Foc Yaw Motor Direction', 'ppos' : 0},
  'FocYawZeroPos' : {'steps' : 8, 'default' : 0, 'adr' : 47, 'max' : 16383, 'page' : 'gimbalconfig', 'min' : -16384, 'len' : 5, 'size' : 2, 'ppos' : 0, 'type' : 'OPTTYPE_SI', 'hidden' : 0, 'name' : 'Foc Yaw Zero Pos', 'unit' : ''},
  'YawOffset' : {'steps' : 5, 'default' : 0, 'adr' : 60, 'max' : 300, 'page' : 'gimbalconfig', 'min' : -300, 'len' : 5, 'size' : 2, 'ppos' : 2, 'type' : 'OPTTYPE_SI', 'hidden' : 0, 'pos' : [4, 4], 'name' : 'Yaw Offset', 'unit' : '\u00b0'},
  'AccLPF' : {'steps' : 1, 'default' : 2, 'adr' : 71, 'max' : 6, 'len' : 0, 'page' : 'expert', 'min' : 0, 'choices' : ['off', '1.5 ms', '4.5 ms', '12 ms', '25 ms', '50 ms', '100 ms'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'name' : 'Acc LPF', 'ppos' : 0},
  'RcAdcLPF' : {'steps' : 1, 'default' : 0, 'adr' : 98, 'max' : 6, 'len' : 0, 'page' : 'expert', 'min' : 0, 'choices' : ['off', '1.5 ms', '4.5 ms', '12 ms', '25 ms', '50 ms', '100 ms'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'name' : 'Rc Adc LPF', 'ppos' : 0},
  'HoldToPanTransitionTime' : {'steps' : 25, 'default' : 250, 'adr' : 95, 'max' : 1000, 'page' : 'expert', 'min' : 0, 'len' : 5, 'size' : 2, 'ppos' : 0, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Hold To Pan Transition Time', 'unit' : 'ms'},
  'AccCompensationMethod' : {'steps' : 1, 'default' : 1, 'adr' : 65, 'max' : 1, 'len' : 0, 'page' : 'expert', 'min' : 0, 'choices' : ['standard', 'advanced'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'pos' : [1, 6], 'name' : 'Acc Compensation Method', 'ppos' : 0},
  'ImuAccThreshold' : {'steps' : 1, 'default' : 25, 'column' : 2, 'adr' : 64, 'max' : 100, 'page' : 'expert', 'min' : 0, 'len' : 5, 'size' : 2, 'ppos' : 2, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Imu Acc Threshold', 'unit' : 'g'},
  'AccNoiseLevel' : {'steps' : 1, 'default' : 40, 'adr' : 66, 'max' : 150, 'page' : 'expert', 'min' : 0, 'len' : 0, 'size' : 2, 'ppos' : 3, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Acc Noise Level', 'unit' : 'g'},
  'AccThreshold' : {'steps' : 1, 'default' : 50, 'adr' : 67, 'max' : 100, 'page' : 'expert', 'min' : 0, 'len' : 0, 'size' : 2, 'ppos' : 2, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Acc Threshold', 'unit' : 'g'},
  'AccVerticalWeight' : {'steps' : 5, 'default' : 25, 'adr' : 68, 'max' : 100, 'page' : 'expert', 'min' : 0, 'len' : 0, 'size' : 2, 'ppos' : 0, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Acc Vertical Weight', 'unit' : '%'},
  'AccZentrifugalCorrection' : {'steps' : 5, 'default' : 30, 'adr' : 69, 'max' : 100, 'page' : 'expert', 'min' : 0, 'len' : 0, 'size' : 2, 'ppos' : 0, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Acc Zentrifugal Correction', 'unit' : '%'},
  'AccRecoverTime' : {'steps' : 5, 'default' : 250, 'adr' : 70, 'max' : 1000, 'page' : 'expert', 'min' : 0, 'len' : 0, 'size' : 2, 'ppos' : 0, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Acc Recover Time', 'unit' : ' ms'},
  'MotorMapping' : {'steps' : 1, 'default' : 0, 'column' : 3, 'adr' : 22, 'max' : 5, 'len' : 0, 'page' : 'expert', 'min' : 0, 'choices' : ['M0=pitch , M1=roll', 'M0=roll , M1=pitch', 'roll yaw pitch', 'yaw roll pitch', 'pitch yaw roll', 'yaw pitch roll'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'name' : 'Motor Mapping', 'ppos' : 0},
  'ImuMapping' : {'steps' : 1, 'default' : 0, 'adr' : 52, 'max' : 1, 'len' : 0, 'page' : 'expert', 'min' : 0, 'choices' : ['1 = id1 , 2 = id2', '1 = id2 , 2 = id1'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'name' : 'Imu Mapping', 'ppos' : 0},
  'ADCCalibration' : {'steps' : 10, 'default' : 1550, 'adr' : 76, 'max' : 2000, 'page' : 'expert', 'min' : 1000, 'len' : 0, 'size' : 2, 'ppos' : 0, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'ADC Calibration', 'unit' : ''},
  'Imu3Configuration' : {'steps' : 1, 'default' : 0, 'column' : 4, 'adr' : 135, 'max' : 5, 'len' : 0, 'page' : 'expert', 'min' : 0, 'choices' : ['off', 'default', '2 = id2, 3 = onboard', '2 = onboard, 3 = id2', '2 = onboard, 3 = id3', '2 = onboard, 3 = off'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'name' : 'Imu3 Configuration', 'ppos' : 0},
  'Imu3Orientation' : {'steps' : 1, 'default' : 0, 'adr' : 136, 'max' : 23, 'len' : 0, 'page' : 'expert', 'min' : 0, 'choices' : ['no.0 :  z0\u00b0   x  y  z', 'no.1 :  z90\u00b0  -y  x  z', 'no.2 :  z180\u00b0  -x -y  z', 'no.3 :  z270\u00b0   y -x  z', 'no.4 :  x0\u00b0   y  z  x', 'no.5 :  x90\u00b0  -z  y  x', 'no.6 :  x180\u00b0  -y -z  x', 'no.7 :  x270\u00b0   z -y  x', 'no.8 :  y0\u00b0   z  x  y', 'no.9 :  y90\u00b0  -x  z  y', 'no.10 :  y180\u00b0  -z -x  y', 'no.11 :  y270\u00b0   x -z  y', 'no.12 :  -z0\u00b0   y  x -z', 'no.13 :  -z90\u00b0  -x  y -z', 'no.14 :  -z180\u00b0  -y -x -z', 'no.15 :  -z270\u00b0   x -y -z', 'no.16 :  -x0\u00b0   z  y -x', 'no.17 :  -x90\u00b0  -y  z -x', 'no.18 :  -x180\u00b0  -z -y -x', 'no.19 :  -x270\u00b0   y -z -x', 'no.20 :  -y0\u00b0   x  z -y', 'no.21 :  -y90\u00b0  -z  x -y', 'no.22 :  -y180\u00b0  -x -z -y', 'no.23 :  -y270\u00b0   z -x -y'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'name' : 'Imu3 Orientation', 'ppos' : 0},
  'Uart1Configuration' : {'steps' : 1, 'default' : 0, 'adr' : 139, 'max' : 1, 'len' : 0, 'page' : 'expert', 'min' : 0, 'choices' : ['off', 'gps target'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'pos' : [4, 4], 'name' : 'Uart1 Configuration', 'ppos' : 0},
  'MavlinkConfiguration' : {'steps' : 1, 'default' : 0, 'adr' : 144, 'max' : 3, 'len' : 0, 'page' : 'betacopter', 'min' : 0, 'choices' : ['no heartbeat', 'emit heartbeat', 'heartbeat + attitude', 'h.b. + mountstatus'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'name' : 'Mavlink Configuration', 'ppos' : 0},
  'MavlinkSystemID' : {'steps' : 1, 'default' : 71, 'adr' : 145, 'max' : 255, 'page' : 'betacopter', 'min' : 0, 'len' : 0, 'size' : 2, 'ppos' : 0, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Mavlink System ID', 'unit' : ''},
  'MavlinkComponentID' : {'steps' : 1, 'default' : 67, 'adr' : 146, 'max' : 255, 'page' : 'betacopter', 'min' : 0, 'len' : 0, 'size' : 2, 'ppos' : 0, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'Mavlink Component ID', 'unit' : ''},
  'STorM32LinkConfiguration' : {'steps' : 1, 'default' : 0, 'adr' : 137, 'max' : 1, 'len' : 0, 'page' : 'betacopter', 'min' : 0, 'choices' : ['off', 'normal'], 'type' : 'OPTTYPE_LISTA', 'unit' : '', 'size' : 1, 'hidden' : 0, 'pos' : [3, 1], 'name' : 'STorM32Link Configuration', 'ppos' : 0},
  'STorM32LinkWaitTime' : {'steps' : 5, 'default' : 50, 'adr' : 138, 'max' : 250, 'page' : 'betacopter', 'min' : 0, 'len' : 0, 'size' : 2, 'ppos' : 1, 'type' : 'OPTTYPE_UI', 'hidden' : 0, 'name' : 'STorM32Link Wait Time', 'unit' : 's'},
}

var M =
{
  "Dashboard" :             { 'name' : 'Dashboard', 'page' : 'dashboard' },
  "PID" :                   { 'name' : 'PID', 'page' : 'pid' },
  "Pan" :                   { 'name' : 'Pan', 'page' : 'pan' },
  "RcInputs" :              { 'name' : 'Rc Inputs', 'page' : 'rcinputs' },
  "Functions" :             { 'name' : 'Functions', 'page' : 'functions' },
  "Scripts" :               { 'name' : 'Scripts', 'page' : 'scripts' },
  "Setup" :                 { 'name' : 'Setup', 'page' : 'gimbalsetup' },
  "GimbalConfig" :          { 'name' : 'Gimbal Configuration', 'page' : 'gimbalconfig' },
  "Expert" :                { 'name' : 'Expert', 'page' : 'expert' },
  "Betacopter" :            { 'name' : 'Betacopter', 'page' : 'betacopter' },
  "About" :                 { 'name' : 'About', 'page' : 'about' }
}


function getPstrScale(pstr) {
    var scale = 1.0;  
    var ppos = P[pstr].ppos;
    if( ppos==1 ){ scale *= 0.1; }
    if( ppos==2 ){ scale *= 0.01; }
    if( ppos==3 ){ scale *= 0.001; }
    if( ppos==4 ){ scale *= 0.0001; }
    if( ppos==5 ){ scale *= 0.00001; }
    if( ppos==6 ){ scale *= 0.000001; }
    return scale;
}


function do_crc(buf,len) {
    var buffer = new ArrayBuffer(1024);
    var u8View = new Uint8Array(buffer);
    
    for(var i=0;i<len;i++)
        u8View[i] = parseInt(buf.substr(2*i, 2), 16); //fill typed array buffer from the hex stream
    
    var crc = 0xFFFF;
    for(var i=0;i<len;i++){
        var tmp = u8View[i] ^ (crc & 0xFF );
        tmp = (tmp ^ (tmp<<4)) & 0xFF;
        crc = (crc>>8) ^ (tmp<<8) ^ (tmp<<3) ^ (tmp>>4);
        crc = crc & 0xFFFF;
    }
    
    return crc;
}


//-----------------------------------------------------
// onload initialization
//-----------------------------------------------------

window.onload = function ()
{
    PValues = '';
    PStatus = INVALID;  
    XhttpTransferInProgress = false;
    ConnectionIsValid = false;

    initMenuHtml();
    initAPageHtml();
    initPPageHtml();

    document.getElementById('PDebug').style.display = 'none';
    //document.getElementById('xhttp_responseText').style.display = 'none';
    //document.getElementById('xhttp_allResponseHeaders').style.display = 'none';

    
    var url = document.URL;
    var lastSegment = url.split('/').pop(); //gives the last segment of the url
    updateMenu(null,lastSegment);
    initPBody();
    adaptToFocEnabled();
//    updateRead();

//    document.getElementById('comment').innerText =  "!"+document.body.innerHTML.replace(/</g,'!').replace(/>/g,'!');  
//    document.body.innerHTML =  "<div id='MenuTop' style='display: block; color: #000;  padding: 8px 16px; text-decoration: none;'>!</div>\n"+document.body.innerHTML;  
//    document.body.innerHTML = "<div id='MenuTop'>STorM32 Web App</div>\n" + document.body.innerHTML;  
}


//this are the pages as they also appear in the SETUP_PARAMETERLIST P
// these mirror the first navigation bar (= menu) entries
// it start with the first menu entry, and all menu entries must follow, so that a page also indexes the menu
// the format MUST be as such:
//   "<li><a href='js.html?dashboard' id='MDashboard' onclick='updateMenu(this,\"dashboard\");return false;'>Dashboard</a></li>\n",
// the ?page is used to have a nicier display, but also importantly to figure out the class='active' in the js script
// the last entry is that is also used in SETUP_PARAMTERLIST !!
// js.html is a dummy webpage, for the menu navigation only the ? parameter is used
// this allows to provide a page to cover for the case of an invalid entry
function initMenuHtml() {
    
    var m = "";
    for (var mstr in M) {
       m += "<li><a href='js.html?"+M[mstr].page+"' "+
            "id='M"+mstr+"' onclick='updateMenu(this,\""+M[mstr].page+"\");return false;'>"+M[mstr].name+"</a></li>\n";
    }
    document.getElementById('NavigationBar').innerHTML = m;
    
//    document.getElementById('comment').innerText = m;
}

function initAPageHtml() {
    
    var c = "";
    
    c += "<input id='FileLoadList' type='button' value='Load File List' onclick='fileLoadList()'/>\n";
//    c += "<input id='FileUpLoadDummy' type='button' value='UpLoad File' onclick='fileUpLoadDummy()'/><input id='FileUpLoad' type='file' onchange='fileUpLoad(event)' style='display:none'/>\n"; //it is crucial to do onchange() and not onclick() here!!
//    c += "<input id='FileDownLoad' type='button' value='DownLoad File' onclick='fileDownLoad()'/>\n";
//    c += "<input id='FileDelete' type='button' value='Delete File' onclick='fileDelete()'/>\n";
    c += "<p></p>\n";
    c += "<div class='FileList'><table id='FileList'>\n<tr><th>file</th><th>size</lt></tr>\n</table></div>\n";  
    c += "<div class='FileInfo'>\n";  
    c += "<div class='FileLabel'><label for='FileFreeValue'>free:</label><span id='FileFreeValue'></span></div>";
    c += "<div class='FileLabel'><label for='FileTotalValue'>max:</label><span id='FileTotalValue'></span></div>\n";
    c += "</div>\n";  
    
    document.getElementById('APage').innerHTML += '<p></p>\n\n'+c+'\n';
    
//    document.getElementById('comment').innerText = c;
}




/* the formats must be such:
OPTTYPE_STR+OPTTYPE_READONLY:
<p id='FirmwareVersionField' class='PField' style='display:none'><label for='FirmwareVersion' class='PLabel'>Firmware Version</label>
<input id='FirmwareVersion' class='PInput' type='text' value='' readonly/>
</p>\n

OPTTYPE_LISTA:
<p id='GyroLPFField' class='PField' style='display:none'><label for='GyroLPF' class='PLabel'>Gyro LPF</label>
<select id='GyroLPF' class='PSelect' value='0' onchange='updateListA(\"GyroLPF\")'></select>
</p>\n

OPTTYPE_UI, OPTTYPE_SI:
<p id='PitchPField' class='PField' style='display:none'><label for='PitchP' class='PLabel'>Pitch P</label>
<input id='PitchP' class='PInput' type='number' value='0' onchange='updateUI(\"PitchP\")'/>
<input id='PitchPSlider' class='PSlider' type='range' value='0' onchange='updateUISlider(\"PitchP\")' oninput='updateUISlider(\"PitchP\")'/>
</p>\n
*/
function initPPageHtml() {
    
    var c = "";
    c += "<input id='read' class='read' type='button' value='Read' onclick='updateRead()'/>\n";
    c += "<input id='write' class='write' type='button' value='Write' onclick='updateWrite()'/>\n";
    c += "<input id='storecheck' type='checkbox' name='storecheck' value='dostore' onclick='updateStoreCheck()'/>";
    c += "<p></p>\n";
    document.getElementById('PCmdLine').innerHTML = c;
    
    var p = "";
    for (var pstr in P) {
        switch(P[pstr].type){
        case 'OPTTYPE_STR+OPTTYPE_READONLY':
            p += "<p id='"+pstr+"Field' class='PField' style='display:none'>"+
                 "<label for='"+pstr+"' class='PLabel'>"+P[pstr].name+"</label>"+
                 "<input id='"+pstr+"' class='PInput' type='text' value='' readonly/></p>\n";
            break;
        case 'OPTTYPE_LISTA':    
            p += "<p id='"+pstr+"Field' class='PField' style='display:none'>"+
                 "<label for='"+pstr+"' class='PLabel'>"+P[pstr].name+"</label>"+
                 "<select id='"+pstr+"' class='PSelect' value='0' onchange='updateListA(\""+pstr+"\")'></select></p>\n";
            break;
        case 'OPTTYPE_UI': case 'OPTTYPE_SI':    
            p += "<p id='"+pstr+"Field' class='PField' style='display:none'>"+
                 "<label for='"+pstr+"' class='PLabel'>"+P[pstr].name+"</label>"+
                 "<input id='"+pstr+"' class='PInput' type='number' value='0' onchange='updateUI(\""+pstr+"\")'/>"+
                 "<input id='"+pstr+"Slider' class='PSlider' type='range' value='0' "+
                    "onchange='updateUISlider(\""+pstr+"P\")' oninput='updateUISlider(\""+pstr+"\")'/></p>\n";
            break;
        }
    }
    
    p += "<div id='PDashboardFooter' class='PDashboardFooter'></div>\n";
    
    document.getElementById('PBody').innerHTML = p;    
    
//    document.getElementById('comment').innerText = p;
}

 
function initPBodyListA(pstr) {
    var Elem = document.getElementById(pstr);    

    var html = "";
    for(var i=0; i<P[pstr].choices.length; i++){
        if( i == parseInt(Elem.value) ) {
            html += "<option value='"+i+"' selected>"+P[pstr].choices[i]+"</option>\n";        
        }else{
            html += "<option value='"+i+"'>"+P[pstr].choices[i]+"</option>\n";
        }
    }

    Elem.innerHTML =  html;

    Elem.min = 0;
    Elem.max = parseInt(P[pstr].max); //for a ListA it's an integer
    Elem.value = parseInt(P[pstr].default);
    
//    document.getElementById('comment').innerText = 'initPBodyListA ' + html;
}


function initPBodyUI(pstr) {
    var Elem = document.getElementById(pstr);    

    var scale = getPstrScale(pstr);
  
    var Xmin = parseFloat(P[pstr].min) * scale;
    var Xmax = parseFloat(P[pstr].max) * scale;
    var Xdefault = parseFloat(P[pstr].default) * scale;
    var Xstep = parseFloat(P[pstr].steps) * scale;
  
    Elem.min = Xmin;
    Elem.max = Xmax;
    Elem.step = Xstep;
    Elem.value = Xdefault;
  
    var ElemSlider = document.getElementById(pstr+'Slider');
  
    ElemSlider.min = Xmin; //the order is important, do default last
    ElemSlider.max = Xmax;
    ElemSlider.step = Xstep;
    ElemSlider.value = Xdefault;
  
//    document.getElementById('comment').innerText = 'initPBodyUI ' + Xmin + ',' + Xmax + ',' + Xstep + ',' + scale;
}


function initPDashboardFooter() {
    var c = ''; //'<p></p>\n';
    c += "<div class='DInfo'><span class='DInfoTitle'>Info Center:</span>";
    c += "<div class='DInfoTable'><table>\n";
    c += "<tr><td><label>Imu1</label><span id='DInfoImu1'> -<\span></td><td><label>State</label><span id='DInfoState'> -<\span></td></tr>\n";    
    c += "<tr><td><label>Imu2</label><span id='DInfoImu2'> -<\span></td><td><label>Voltage</label><span id='DInfoVoltage'> -<\span></td></tr>\n";    
    c += "<tr><td><label>Encoders</label><span id='DInfoEncoders'> -<\span></td><td><label>Imu1:</label><span id='DInfoImu1State'> -<\span></td></tr>\n";    
    c += "<tr><td><label>Bat</label><span id='DInfoBat'> -<\span></td><td><label>Imu2:</label><span id='DInfoImu2State'> -<\span></td></tr>\n";    
    c += "<tr><td><label>Motors</label><span id='DInfoMotors'> -<\span></td><td><label>Encoders:</label><span id='DInfoEncodersState'> - - -<\span></td></tr>\n";    
    c += "<tr><td></td><td><label>Bus Errors:</label><span id='DInfoBusErrors'> -<\span></td></tr>\n";    
    c += "</div></table></div>\n";
    
//    document.getElementById('comment').innerText = '\n'+c;
    
    document.getElementById('PDashboardFooter').innerHTML = c;
}


function initPBody() {
    for (var pstr in P) {
        if( !document.getElementById(pstr) ) continue;
        if( P[pstr].type == 'OPTTYPE_LISTA' ) initPBodyListA(pstr);
        if( P[pstr].type == 'OPTTYPE_UI' ) initPBodyUI(pstr);
        if( P[pstr].type == 'OPTTYPE_SI' ) initPBodyUI(pstr);
        if( P[pstr].type == 'OPTTYPE_STR+OPTTYPE_READONLY' ) document.getElementById(pstr).value = '';
    }
    setPAllToInvalid();
    
    initPDashboardFooter();
    
//    document.getElementById('comment').innerText = 'initPBody';
}


//-----------------------------------------------------
// PBody adaption handling
//-----------------------------------------------------

var BoardConfiguration_FOC_DisabledParameters = [
  'Imu2 FeedForward LPF', 'Voltage Correction',
  'Imu2 Configuration', 'Startup Mode',
  'Motor Mapping'
];
var BoardConfiguration_FOC_HidedParameters = [
  'Gyro LPF',
  'Pitch P', 'Pitch I', 'Pitch D', 'Pitch Motor Vmax',
  'Roll P', 'Roll I', 'Roll D', 'Roll Motor Vmax',
  'Yaw P', 'Yaw I', 'Yaw D', 'Yaw Motor Vmax',
  'Pitch Motor Poles', 'Pitch Motor Direction', 'Pitch Startup Motor Pos',
  'Roll Motor Poles', 'Roll Motor Direction', 'Roll Startup Motor Pos',
  'Yaw Motor Poles', 'Yaw Motor Direction', 'Yaw Startup Motor Pos',
];
var BoardConfiguration_FOC_ShownParameters = [
  'Foc Gyro LPF',
  'Foc Pitch P', 'Foc Pitch I', 'Foc Pitch D', 'Foc Pitch K',
  'Foc Roll P', 'Foc Roll I', 'Foc Roll D', 'Foc Roll K',
  'Foc Yaw P', 'Foc Yaw I', 'Foc Yaw D', 'Foc Yaw K',
  'Foc Pitch Motor Direction', 'Foc Pitch Zero Pos',
  'Foc Roll Motor Direction', 'Foc Roll Zero Pos',
  'Foc Yaw Motor Direction', 'Foc Yaw Zero Pos',
];

function arrayContains(array,element)
{
    for(var i=0; i<array.length; i++){ if( array[i] == element ) return true; } //=== type correct comparison
    return false;
}


function i_updateAPage() {
    
}

        
// mstr must be lower case
function i_updatePPage(mstr) {
    if( mstr === 'gimbalsetup' ) mstr = 'setup'; //this is needed since the page name for Setup is different in P and in M
    for (var pstr in P) {
        if( !document.getElementById(pstr) ) continue;
        var disp = 'none';
      
        if( P[pstr].page == mstr ){
            var isFocParam = false;
            if( pstr.match(/Foc/) ) isFocParam = true;
            if( FocIsEnabled ){
                if( arrayContains(BoardConfiguration_FOC_DisabledParameters,P[pstr].name) ){
                     //show disabled //doesn't make sense here since we do not have a grid format of the param fields
                    //disp = 'block'; enable = false;
                }else
                if( arrayContains(BoardConfiguration_FOC_HidedParameters,P[pstr].name) ){
                    //hide
                }else
                if( arrayContains(BoardConfiguration_FOC_ShownParameters,P[pstr].name) ){
                    disp = 'block';
                }else{
                    disp = 'block';
                }
            }else{
                if( !isFocParam ) disp = 'block';
            }
               
        }
          
        document.getElementById(pstr+'Field').style.display = disp;
    }
}


//-----------------------------------------------------
// menu handling
//-----------------------------------------------------

function updateMenu(caller,mstr) {
    mstr = mstr.toLowerCase();
//    document.getElementById('comment').innerText = 'updateMenu '+mstr;  
    document.getElementById('IsLoading').style.display = 'none';
    if( mstr == '' ) mstr = 'dashboard';

    // do the navigation bar
    var lis = document.getElementById('NavigationBar').querySelectorAll('a');
    for(var i=0; i<lis.length; i++){
        var m = lis[i].href.split('?').pop(); 
        if( mstr == m ){ lis[i].classList.add('active'); }else{ lis[i].classList.remove('active'); }
        
//        document.getElementById('comment').innerText += '\n'+i+','+mstr+','+m;
    }  
    
    if( mstr == 'about' ){ //APage
        document.getElementById('APage').style.display = 'block';
        document.getElementById('PPage').style.display = 'none';
        i_updateAPage();
    }else{ //Parameter page  
        document.getElementById('APage').style.display = 'none';
        document.getElementById('PPage').style.display = 'block';
        i_updatePPage(mstr);

        if( mstr == 'dashboard' )
            document.getElementById('PDashboardFooter').style.display = 'block';
        else
            document.getElementById('PDashboardFooter').style.display = 'none';            
    }        
  
    window.scrollTo(0, 0);
    
    return false;
}


//-----------------------------------------------------
// store checkbox handling
//-----------------------------------------------------

function updateStoreCheck() {
    
    if( document.getElementById('storecheck').checked ){
        document.getElementById('write').value = 'Write+Store';
    }else{
        document.getElementById('write').value = 'Write';
    }
}


function setStoreUnchecked() {
    document.getElementById('storecheck').checked = false;
    document.getElementById('write').value = 'Write';
}


function isStoreChecked() {
    return document.getElementById('storecheck').checked;
}


//-----------------------------------------------------
// color handling
//-----------------------------------------------------

function setPColor(pstr,color) {
    var Elem = document.getElementById(pstr);
    if( !Elem ) return;
    Elem.style.backgroundColor = color;
}

function setPToInvalid(pstr){
    setPColor(pstr, '#FFbbbb'); //'red');
    PStatus = INVALID;
}

function setPToValid(pstr) {
    setPColor(pstr, '#bbFFbb'); //'lightgreen');
    PStatus = VALID;
}

function setPToModified(pstr) {
    setPColor(pstr, '#bbbbFF'); //'lightblue');
    PStatus = MODIFIED;
}

function setPAllToInvalid() {
    PValues = '';
    for (var pstr in P) { setPToInvalid(pstr);  }
}

function setPAllToValid() {
    for (var pstr in P) { setPToValid(pstr); }
}


//-----------------------------------------------------
// element update handling
//-----------------------------------------------------

function updateListA(pstr) {
    document.getElementById('comment').innerHTML = 'update'+pstr;
    
    setPToModified(pstr);
}


function parsePFloat(pstr,ppos) {
    var Elem = document.getElementById(pstr);
    var val = parseFloat(Elem.value);
    var min = parseFloat(Elem.min); //can't use P[pstr]. since pstr may have a 'Slider'
    var max = parseFloat(Elem.max); 
    var step = parseFloat(Elem.step); 
    if( val < min ){ val = min; }
    if( val > max ){ val = max; }
    //TODO we here also need to respect the step!!!!

//    document.getElementById('comment').innerHTML='parsePFloat '+pstr+','+ppos+','+min+','+max+','+step+','+val;

    return (val).toFixed(ppos);
}


function updateUI(pstr) {
    document.getElementById('comment').innerHTML = 'update'+pstr;
    var val = parsePFloat(pstr, P[pstr].ppos);
    document.getElementById(pstr).value = val;
    document.getElementById(pstr+'Slider').value = val;
    
    setPToModified(pstr);
}


function updateUISlider(pstr) {
    document.getElementById('comment').innerHTML = 'update'+pstr+'Slider';
    var val = parsePFloat(pstr+'Slider', P[pstr].ppos);
    document.getElementById(pstr).value = val;
    document.getElementById(pstr+'Slider').value = val;
    
    setPToModified(pstr);
}
 

//-----------------------------------------------------
// AJAX
//-----------------------------------------------------

//https://stackoverflow.com/questions/13697829/hexadecimal-to-string-in-javascript
function hex2a(hex) {
    var str = '';
    for (var i = 0; i < hex.length; i += 2) {
        var v = parseInt(hex.substr(i, 2), 16);
        if (v) str += String.fromCharCode(v); //this skips any '\0'
    }
    return str;
} 

//converts a hex XXXX to a u16, taking into account having to swap
function hex2u16(hex) {
    return  parseInt( hex.substr(2,2)+hex.substr(0,2), 16);
} 

//swaps AABB to BBAA
function hexswap(hex) {
    return  hex.substr(2,2)+hex.substr(0,2);
} 

//converts a value into hex XXXX
function a2hex(a) {
    var hex = a.toString(16).toUpperCase();
    while( hex.length < 4 ) hex = '0'+hex;
    return hex;
}  


//converts a u16 into a hex XXXX, taking into account having to swap
function u162hex(a) {
    var hex = a2hex(a);
    return hex.substr(2,2)+hex.substr(0,2);
}    


function setPValueLISTA(pstr,hex) {
    var value = parseInt(hex,16);
    document.getElementById(pstr).value = value;
    setPToValid(pstr);
}    

function setPValueUI(pstr,hex) {
    var scale = getPstrScale(pstr);
    var value = ( parseFloat(parseInt(hex,16)) * scale ).toFixed(P[pstr].ppos);
    document.getElementById(pstr).value = value;
    document.getElementById(pstr+'Slider').value = value;
    setPToValid(pstr);
}    

function setPValueSI(pstr,hex) {
    var scale = getPstrScale(pstr);
    var i = parseInt(hex,16);
    if( i > 32767 ) i -= 65536;
    var value = ( parseFloat(i) * scale ).toFixed(P[pstr].ppos);
    document.getElementById(pstr).value = value;
    document.getElementById(pstr+'Slider').value = value;
    setPToValid(pstr);
}



function adaptToFocEnabled()
{
    //adapt title
    if( FocIsEnabled ){
        document.getElementById('AppConfiguration').innerHTML = " -  for T-STorM32";
    }else{
        document.getElementById('AppConfiguration').innerHTML = " -  for STorM32-NT";
    }
    
    //find active menu
    var mstr = '?';
    var lis = document.getElementById('NavigationBar').querySelectorAll('a');
    for(var i=0; i<lis.length; i++){
        if( lis[i].classList.contains('active') ){ mstr = lis[i].href.split('?').pop(); }
    }  

    //update PBody
    i_updatePPage(mstr);
}


function updateFocEnabled(capabilities)
{
    //check if capability has changed
    var hasFocCapability = false;
    if( capabilities & BOARD_CAPABILITY_FOC ) hasFocCapability = true;
    if( hasFocCapability == FocIsEnabled ) return;
    FocIsEnabled = hasFocCapability;
    
    adaptToFocEnabled();
}


function updateRead()
{
    document.getElementById('comment').innerHTML = 'Read clicked... ';
    document.getElementById('xhttp_responseText').innerHTML = '';
    document.getElementById('xhttp_allResponseHeaders').innerHTML = '';
    ajaxPost('read?p=all', '', function(xhttp){ // ?p=all is ignored currently
        var com = '';
        var args = xhttp.responseText.split(','); //the reponse comes formatted as "v=XX...XX,p=XX...XX,"
        if( (xhttp.responseText.substr(0,1) != 'v')  || (args.length < 2) ){
            ConnectionIsValid = false;
            setPAllToInvalid();
            com = 'failed';
        }else{
            var v = args[0].substr(2);
            var firmware = hex2a(v.substr(0,16*2));
            var board = hex2a(v.substr(16*2,16*2));
            var name = hex2a(v.substr(32*2,16*2));
            var version = hex2u16(v.substr(48*2,2*2));
            var layout = hex2u16(v.substr(50*2,2*2));
            var capabilities = hex2u16(v.substr(52*2,2*2));
        
            updateFocEnabled(capabilities);

            document.getElementById('FirmwareVersion').value = firmware;
            document.getElementById('Board').value = board;
            document.getElementById('Name').value = name;
        
            var g = args[1].substr(2);
            for (var pstr in P) {
                if( !document.getElementById(pstr) ) continue;
                switch( P[pstr].type ){
                    case 'OPTTYPE_LISTA':
                        var adr = P[pstr].adr;
                        var hex = g.substr(4*adr+2,2)+g.substr(4*adr,2);
                        setPValueLISTA(pstr,hex);
                        break;
                    case 'OPTTYPE_UI':
                        var adr = P[pstr].adr;
                        var hex = g.substr(4*adr+2,2)+g.substr(4*adr,2);
                        setPValueUI(pstr,hex);
                        break;
                    case 'OPTTYPE_SI':
                        var adr = P[pstr].adr;
                        var hex = g.substr(4*adr+2,2)+g.substr(4*adr,2);
                        setPValueSI(pstr,hex);
                        break;
                    case 'OPTTYPE_STR+OPTTYPE_READONLY':
                        setPToValid(pstr);
                        break;                
                    default:
                        setPToInvalid(pstr);
                }
            }
            PValues = g;
            PStatus = VALID; //this overrides it
            
            //the connection is valid, so we can trigger updating the status
            updateStatus(); 
        
            com = 'ok' + ','+version+','+layout+','+capabilities+'(x'+a2hex(capabilities)+')'+','+FocIsEnabled;
        }        

        document.getElementById('comment').innerHTML += com;
        document.getElementById('xhttp_responseText').innerHTML = xhttp.responseText;
        document.getElementById('xhttp_allResponseHeaders').innerHTML = xhttp.getAllResponseHeaders();
    });
}



function getPValueLISTA(pstr) {
    var value = parseInt(document.getElementById(pstr).value);
    
    setPToValid(pstr);
    return a2hex(value);
}    

function getPValueUI(pstr) {
    var scale = getPstrScale(pstr);
    var value = parseFloat(document.getElementById(pstr).value);
    value = parseInt(Math.round(value / scale));
    if( value < 0 ) value += 65536;
    
    setPToValid(pstr);
    return a2hex(value);
}    

function getPValueSI(pstr) {
    var scale = getPstrScale(pstr);
    var value = parseFloat(document.getElementById(pstr).value);
    value = parseInt(Math.round(value / scale));
    if( value < 0 ) value += 65536;
    
    setPToValid(pstr);
    return a2hex(value);
}    


function setPArray(pa,adr,hex) {
    pa[4*adr] = hex.substr(2,1);
    pa[4*adr+1] = hex.substr(3,1);
    pa[4*adr+2] = hex.substr(0,1);
    pa[4*adr+3] = hex.substr(1,1);
}


function updateWrite()
{
    document.getElementById('comment').innerHTML = 'Write clicked... ';
    document.getElementById('xhttp_responseText').innerHTML = '';
    document.getElementById('xhttp_allResponseHeaders').innerHTML = '';
    
    if( !ConnectionIsValid || (PStatus == INVALID) ){
        document.getElementById('comment').innerHTML += ', no read was done before, hence aborted';
        return;
    }
   
    //take PValues without last 'o' as template, overwrite with those in the Inputs
    var p = PValues.slice(0,-2-4); //remove the last 'o' = '6F' (i.e. two chars) //also remove the crc
    var pa = p.split(''); // array of characters, better to work with than a string
    
    var pp = ''; // this is just for a pretty debug output
    var pa_pretty = pa.slice(); // this is just for a pretty debug output //don't do pa_pretty = p, as this just copies the reference
        
    for (var pstr in P) {
        if( !document.getElementById(pstr) ) continue;
        switch( P[pstr].type ){
            case 'OPTTYPE_LISTA':
                var adr = P[pstr].adr;
                var hex = getPValueLISTA(pstr);
                setPArray(pa, adr, hex);
                
                pp += hex + '('+ parseInt(adr) + '=' + parseInt(hex,16) +'),';
                setPArray(pa_pretty, adr, hex);
                pa_pretty[4*adr] = '<span style="color:red">'+pa_pretty[4*adr]; pa_pretty[4*adr+3] += '</span>';
                break;
            case 'OPTTYPE_UI':
                var adr = P[pstr].adr;
                var hex = getPValueUI(pstr);
                setPArray(pa, adr, hex);

                pp += hex + '('+ parseInt(adr) + '=' + parseInt(hex,16) +'),';
                setPArray(pa_pretty, adr, hex);
                pa_pretty[4*adr] = '<span style="color:red">'+pa_pretty[4*adr]; pa_pretty[4*adr+3] += '</span>';
                break;
            case 'OPTTYPE_SI':
                var adr = P[pstr].adr;
                var hex = getPValueSI(pstr);
                setPArray(pa, adr, hex);

                pp += hex + '('+ parseInt(adr) + '=' + parseInt(hex,16) +'),';
                setPArray(pa_pretty, adr, hex);
                pa_pretty[4*adr] = '<span style="color:red">'+pa_pretty[4*adr]; pa_pretty[4*adr+3] += '</span>';
                break;
            case 'OPTTYPE_STR+OPTTYPE_READONLY': //skip
                break;                
            default: //skip
        }
    }

    p = pa.join(''); //combine it back to a string
    
    var hexcrc = u162hex( do_crc(p, p.length/2) );
    p += hexcrc;
    
    document.getElementById('comment').innerHTML += 'ok' + ',' + hexcrc;//'ok\n' + PValues + '\n' + pa_pretty.join('') + ',' + hexcrc;
    
    var cmd = 'write?p=all';
    if( isStoreChecked() ) cmd = 'write?s=y&p=all';
    
    ConnectionIsValid = true; //set it here, so it can be reset by the xhhtp request
    
    ajaxPost(cmd, p, function(xhttp){ // ?p=all is ignored currently
        document.getElementById('xhttp_responseText').innerHTML = xhttp.responseText;
        document.getElementById('xhttp_allResponseHeaders').innerHTML = xhttp.getAllResponseHeaders();
    });
    
    //TODO: we need here to check if the write was successfull!!!
    // both ConnectionIsValid and 'o' must be checked
    
    setPAllToValid();  
    setStoreUnchecked();
}


//-----------------------------------------------------
// status and Info Pane handling
//-----------------------------------------------------

function getStorm32State(state) {
    switch( state ){
        case 0: return 'STARTUP_MOTORS';
        case 1: return 'SETTLE';
        case 2: return 'CALIBRATE';
        case 3: return 'LEVEL';
        case 4: return 'MOTORDIRDETECT';
        case 5: return 'RELEVEL';
        case 6: return 'NORMAL';
        case 7: return 'FASTLEVEL';
        case 32: return 'WAITFORSTORM32LINK';
        case 99: return 'STANDBY';
        case 100: return 'QMODE';
    }
    return 'unknown';
}    

//status flags
var STATUS_IMU_PRESENT =              0x8000; //is checked at start
var STATUS_IMU2_PRESENT =             0x1000; //is checked at start
var STATUS_IMU2_HIGHADR =             0x0800; //is set at start
var STATUS_IMU2_NTBUS =               0x0400; //is set at start

var STATUS_BAT_VOLTAGEISLOW =         0x0010;
var STATUS_BAT_ISCONNECTED =          0x0008; //is set as soon as V>5.5V is detected first time after start
var STATUS_LEVEL_FAILED =             0x0004;

var STATUS_IMU_OK =                   0x0020;
var STATUS_IMU2_OK =                  0x0040;

//status2 flags
var STATUS2_ENCODERS_PRESENT =        0x8000;
var STATUS2_ENCODERYAW_OK =           0x4000;
var STATUS2_ENCODERROLL_OK =          0x2000;
var STATUS2_ENCODERPITCH_OK =         0x1000;

var STATUS2_MOTORYAW_ACTIVE =         0x0020; //sequence is important, must mirror MOTORPITCHENABLED etc., is used by GUI
var STATUS2_MOTORROLL_ACTIVE =        0x0010;
var STATUS2_MOTORPITCH_ACTIVE =       0x0008;


function updateStatus()
{
    if( !ConnectionIsValid ) return;
    
    //document.getElementById('comment').innerHTML = 'Status clicked... ';
    //document.getElementById('xhttp_responseText').innerHTML = '';
    //document.getElementById('xhttp_allResponseHeaders').innerHTML = '';
    ajaxPost('exec?cmd=s', '', function(xhttp){
        var com = '';
        var args = xhttp.responseText; //the reponse comes formatted as "s=XX...XX,"
        if( xhttp.responseText.substr(0,1) != 's' ){
            ConnectionIsValid = false;
            setPAllToInvalid();
            com = 'failed';
        }else{
            var v = args.substr(2); //strip of the 's='
            var state = hex2u16(v.substr(0,2*2));
            var status = hex2u16(v.substr(2*2,2*2));
            var status2 = hex2u16(v.substr(4*2,2*2));
            var status3 = hex2u16(v.substr(6*2,2*2));
            var performance = hex2u16(v.substr(8*2,2*2));
            var errors = hex2u16(v.substr(10*2,2*2));
            var voltage = hex2u16(v.substr(12*2,2*2));
                        
            var c = ''; var c2 = '';

            if( status & STATUS_IMU_PRESENT ){
                c = ' is PRESENT'; c += ' @ NtBus';
                if( status & STATUS_IMU_OK ) c2 = ' OK'; else c2 = ' ERR';
            }else{ 
                c = ' is not available'; c2 = ' -';
            }
            document.getElementById('DInfoImu1').innerHTML = c;
            document.getElementById('DInfoImu1State').innerHTML = c2;
            
            if( status & STATUS_IMU2_PRESENT ){
                c = ' is PRESENT'; 
                if( status & STATUS_IMU2_NTBUS ){ 
                    c += ' @ NtBus';
                }else{
                    if( status & STATUS_IMU2_HIGHADR ){ c+= ' @ high adr = on-board Imu'; }else{ c += ' @ low adr = external Imu'; }
                }
                if( status & STATUS_IMU2_OK ) c2 = ' OK'; else c2 = ' ERR';
            }else{ 
                c = ' is not available'; c2 = ' -';
            }
            document.getElementById('DInfoImu2').innerHTML = c;
            document.getElementById('DInfoImu2State').innerHTML = c2;

            if( status2 & STATUS2_ENCODERS_PRESENT ) c = ' are PRESENT'; else c = ' are not available';
            document.getElementById('DInfoEncoders').innerHTML = c;
            c = '';
            if( status2 & STATUS2_ENCODERS_PRESENT ){
                if( status2 & STATUS2_ENCODERPITCH_OK ) c += ' OK'; else c += ' ERR';
                if( status2 & STATUS2_ENCODERROLL_OK ) c += ' OK'; else c += ' ERR';
                if( status2 & STATUS2_ENCODERYAW_OK ) c += ' OK'; else c += ' ERR';
            }else c += ' - - -'; 
            document.getElementById('DInfoEncodersState').innerHTML = c;
 
            c = ' are';
            if( status2 & STATUS2_MOTORPITCH_ACTIVE ) c += ' ACTIVE'; else c += ' OFF';
            if( status2 & STATUS2_MOTORROLL_ACTIVE ) c += ' ACTIVE'; else c += ' OFF';
            if( status2 & STATUS2_MOTORYAW_ACTIVE ) c += ' ACTIVE'; else c += ' OFF'; 
            document.getElementById('DInfoMotors').innerHTML = c;
                        
            document.getElementById('DInfoState').innerHTML = ' is ' + getStorm32State(state);
            
            if( status & STATUS_BAT_ISCONNECTED ) c = ' is CONNECTED'; else c = ' is not connected';
            document.getElementById('DInfoBat').innerText = c;
            if( status & STATUS_BAT_VOLTAGEISLOW ) c = ' is LOW: '; else c = ' is OK: ';
            document.getElementById('DInfoVoltage').innerText = c + parseFloat(voltage*0.001).toFixed(2)+' V';
           
            document.getElementById('DInfoBusErrors').innerText = parseInt(errors);
       
            com = 'ok';
            
            //connection is valid, so trigger a next time
            setTimeout(updateStatus, 1000);
        }

        //document.getElementById('comment').innerHTML += com;
        //document.getElementById('xhttp_responseText').innerHTML = xhttp.responseText;
        //document.getElementById('xhttp_allResponseHeaders').innerHTML = xhttp.getAllResponseHeaders();
    });
}



//-----------------------------------------------------
// file handling
//-----------------------------------------------------

function fileLoadList() {
    document.getElementById('comment').innerHTML = 'Load File List clicked... ';
    document.getElementById('xhttp_responseText').innerHTML = '';
    document.getElementById('xhttp_allResponseHeaders').innerHTML = '';

    ajaxPost('fslist?dir=/', 'TEST', function(xhttp){
        //json format { "files" : [ { "name" : "xxxxxx.xxx", "size" : "xxx" } , {} .... ], "total" : "bytes", "free" : "bytes" }
        var c = 'Error in json parse';
        {try{ 
            var Fjson = JSON.parse(xhttp.responseText); 
            c = "<tr><th>file</th><th>size</th></tr>\n";
            for(var i=0; i<Fjson.files.length;i++) {
                c += "<tr><td>"+Fjson.files[i].name+"</td><td>"+Fjson.files[i].size+"</td></tr>\n";
            }
            document.getElementById('FileList').innerHTML = c;
            document.getElementById('FileTotalValue').innerHTML = Fjson.total;
            document.getElementById('FileFreeValue').innerHTML = Fjson.free;
        }catch(e){}}
        
//        document.getElementById('comment').innerText += '\n' + c;
        document.getElementById('xhttp_responseText').innerHTML = xhttp.responseText;
        document.getElementById('xhttp_allResponseHeaders').innerHTML = xhttp.getAllResponseHeaders();
    });
}


function fileUpLoadDummy() {
    document.getElementById('FileUpLoad').click();
}

// https://wiki.selfhtml.org/wiki/JavaScript/File_Upload
function fileUpLoad(evt) {
    document.getElementById('comment').innerHTML = 'UpLoad File clicked... ';
    document.getElementById('xhttp_responseText').innerHTML = '';
    document.getElementById('xhttp_allResponseHeaders').innerHTML = '';

    var files = evt.target.files; // FileList object
//    document.getElementById('comment').innerText += '\n' + files + '!' + files.length;
//	for (var i=0; i<files.length; i++) {
//        document.getElementById('comment').innerText += '\n' + files[i].name + '!';
// 	}
    if( !files.length ) return;
    
    var filename = files[0].name;
    document.getElementById('comment').innerText += '\n selected file is ' + filename;
  
    
    
/*
    ajaxPost('fslist?dir=/', 'TEST', function(xhttp){ // ?dir=/ is ignored currently
        //json format [ { "type" : "file" ,"name" : "xxxxxx.xxx", "size" : "xx" } , {} .... ]
        var Fjson = JSON.parse(xhttp.responseText); 
        
        var c = "<tr><th>file</th><th>size</th></tr>\n";
        for(var i=0; i<Fjson.length;i++) {
            c += "<tr><td>"+Fjson[i].name+"</td><td>"+Fjson[i].size+"</td></tr>\n";
        }
        document.getElementById('FileList').innerHTML = c;
        
        document.getElementById('comment').innerText += '\n' + c;
        document.getElementById('xhttp_responseText').innerHTML = xhttp.responseText;
        document.getElementById('xhttp_allResponseHeaders').innerHTML = xhttp.getAllResponseHeaders();
    });
*/    
}


function fileDownLoad(evt) {
    document.getElementById('comment').innerHTML = 'DownLoad File clicked... ';
    document.getElementById('xhttp_responseText').innerHTML = '';
    document.getElementById('xhttp_allResponseHeaders').innerHTML = '';
}


function fileDelete() {
    document.getElementById('comment').innerHTML = 'Delete File clicked... ';
    document.getElementById('xhttp_responseText').innerHTML = '';
    document.getElementById('xhttp_allResponseHeaders').innerHTML = '';
}