import QtQuick 2.9
import QtQuick.Controls 1.5 as Cntrl1
import QtQuick.Controls 2.2 as Cntrl2


//basic class for the top line

Rectangle{     
//------------------------
// Interface        

    height: s.winScale(40)
    color: 'gray'
    
    property string appName: 'STorM32 App'
    property string appVersion: ''
    
    function populateList(portList) { 
        // model = ['COMx','COMy']
        var initialize = (cbPort.model.length == 0) ? true : false
        
        if( initialize ) {
            cbPort.model = portList
        } else {
            var curText = cbPort.displayText
            cbPort.model = portList
            var i = cbPort.find( curText, Qt.MatchStartsWith )
            cbPort.currentIndex = (i >= 0) ? i : 0
        }
    }
    
    function selectPort(port) { 
        for(var i=0; i<cbPort.model.length; i++) {
            if( cbPort.model[i].toUpperCase().indexOf(port.toUpperCase() ) >= 0 ) { cbPort.currentIndex = i; return; }
        }
        cbPort.currentIndex = 0
    }
//------------------------

    anchors.left: parent.left
    anchors.right: parent.right
    anchors.top: parent.top
   
    Column {
        anchors.left: parent.left
        anchors.leftMargin: s.winScale(10)
        anchors.verticalCenter: parent.verticalCenter
        MyText {
            id: _text
            text: appName 
            color: 'white'
            font.pixelSize: 1.5*s._fontSize
            Connections {
                target: wMain
                onSignalFocChanged: {
                    _text.text = ( newFoc ) ? 'T-'+appName : appName
                }
            }
        }
        MyText {
            text: appVersion
            color: 'lightgray'
            font.pixelSize: s._fontSize
        }
    }
    
    Row{
        spacing: s.winScale(20)
        anchors.horizontalCenter: parent.horizontalCenter
        anchors.horizontalCenterOffset: s.winScale(20)
        anchors.verticalCenter: parent.verticalCenter
        MyComboBox2 {
            width: s.winScale(80)
            id: cbPort
            objectName: 'cbPort'
            anchors.verticalCenter: parent.verticalCenter
            dropDownExtraWidth: s.winScale(200)
            displayText: currentText.substr(0,8) //(currentText.indexOf('COM')>=0) ? currentText.substr(0,8) : currentText
            scrollbarPolicy: Cntrl2.ScrollBar.AlwaysOff
            Connections {
                target: wMain
                onSignalConnectedChanged: {
                    cbPort.enabled = (newConnected) ? false : true
                }
            }
        }
        MyButton {
            width: s.winScale(80)
            id: btConnect
            text: qsTr('Connect','topline')
            iconSource: s.iconTopLineConnect
            onClicked: btConnectQmlClicked() //parent.btConnectQmlClicked() //both works, so chose the easier/shorter
            Connections {
                target: wMain
                onSignalConnectedChanged: {
                    btConnect.text = (newConnected) ? qsTr('Disconnect','topline') : qsTr('Connect','topline')
                }
            }
        }
        MyButton {
            width: s.winScale(80)
            id: btRead
            text: qsTr('Read','topline')
            iconSource: s.iconTopLineRead
            onClicked: btReadQmlClicked()
        }
        MyButton {
            width: s.winScale(80)
            id: btWrite
            text: qsTr('Write','topline')
            iconSource: s.iconTopLineWrite
            enabled: false
            respondToConnectedChanged: true
            onClicked: {
                btWriteQmlClicked(cbWriteStore.checked)
                text = qsTr('Write','topline')
                cbWriteStore.checked = false
            }
        }
        Cntrl1.CheckBox {
            id: cbWriteStore
            text: ''
            anchors.verticalCenter: parent.verticalCenter
            onClicked: {
                btWrite.text = (checked) ? qsTr('Write+Store','topline') : qsTr('Write','topline')
            }
        }
    }
    
    MyButton {
        anchors.rightMargin: s.winScale(70)
        width: s.winScale(25)

        anchors.right: parent.right
        anchors.verticalCenter: parent.verticalCenter
        objectName: 'btDataDisplay'
        iconSource: s.iconTopLineDataDisplay
        onClicked: btDataDisplayQmlClicked()
    }
    
    MyButton {
        anchors.rightMargin: s.winScale(20)
        width: s.winScale(25)

        anchors.right: parent.right
        anchors.verticalCenter: parent.verticalCenter
        objectName: 'btAbout'
        iconSource: s.iconTopLineAbout
        onClicked: btAboutQmlClicked()
    }
    
    
}    
