import QtQuick 2.9


QtObject {
//------------------------
// Interface        

    property int  _fontSize: 11
    property real _winScale: _fontSize/11 //23/11 //11/23

//------------------------


    function winScale(x) { return x*_winScale }
    function fontScale(x) { return parseInt(x*_winScale) }
    
    
//------------------------
// Icons
    
    readonly property string iconPath: '../icons/'

    //navbar    
    readonly property string iconNavbarDashboard: iconPath + 'ic_home_black_48dp.png'
    readonly property string iconNavbarPID: ''
    readonly property string iconNavbarPan: ''
    readonly property string iconNavbarRcInputs: ''
    readonly property string iconNavbarFunctions: ''
    readonly property string iconNavbarScripts: ''
    readonly property string iconNavbarSetup: ''
    readonly property string iconNavbarGimbalConfiguration: ''
    readonly property string iconNavbarCalibrations: ''
    readonly property string iconNavbarInterfaces: ''
    readonly property string iconNavbarExpert: ''
    readonly property string iconNavbarTools: ''
    readonly property string iconNavbarFirmwareUpdate: ''
    
    //topline
    readonly property string iconTopLineConnect: ''
    readonly property string iconTopLineRead: ''
    readonly property string iconTopLineWrite: ''
    readonly property string iconTopLineDataDisplay: iconPath + 'ic_timeline_black_48dp.png'
    readonly property string iconTopLineAbout: iconPath + 'ic_menu_black_48dp.png'    
    
    //share settings
    readonly property string iconShareSettingsScreenShot: iconPath + 'ic_camera_white_48dp.png' // 'ic_camera_alt_black_48dp.png'
    
    //basic 
    readonly property string iconComboBoxDown: iconPath + 'ic_arrow_drop_down_black_48dp.png'

    
//------------------------
// MyParamItem properties
    
    readonly property int h: s.winScale(40)
    readonly property int x1: s.winScale(210)
    readonly property int width1: s.winScale(140)
    readonly property int x2: s.winScale(375)
    readonly property int width2: width1
    
    readonly property color cINVALID:  '#FFc0c0' //'#80FF0000'
    readonly property color cMODIFIED: '#c0c0FF' //'lightblue'
    readonly property color cVALID:    '#c0FFc0' //'lightgreen'
    
}