import QtQuick 2.9
import QtQuick.Controls 1.5
import QtQuick.Controls.Styles 1.4


//basic class for the bottom status line

//responds to signals
// signalStatusChanged(string status)
// signalBlinkerChanged(int blinker)


Rectangle{
    height: s.winScale(25)
    color: 'gray'
    
    anchors.left: parent.left
    anchors.right: parent.right
    anchors.bottom: parent.bottom

    // status blink indicator
    Rectangle {
        x: s.winScale(10)
        width: s.winScale(10)
        
        readonly property color cNOTCONNECTED: 'red'
        readonly property color cCONNECTED_BLINK: '#3dca3d' //'green'
        readonly property color cCONNECTED_PAUSE: '#008d00' //'#00c000' //'lightgreen'
        
        id: btStatusBlink
        
        height: width
        radius: width*0.5
        anchors.verticalCenter: parent.verticalCenter
        
        color: cNOTCONNECTED

        Connections {
            target: wMain
            onSignalBlinkerChanged: {
                if( newBlinker < 0 ) {
                    // blinker off
                    btStatusBlink.color = btStatusBlink.cNOTCONNECTED
                } else
                if( newBlinker > 0 ) {
                    // blinker bright
                    btStatusBlink.color = btStatusBlink.cCONNECTED_BLINK
                } else {
                    // blinker light
                    btStatusBlink.color = btStatusBlink.cCONNECTED_PAUSE
                }
            }
        }
        Connections {
            target: wMain
            onSignalConnectedChanged: {
                btStatusBlink.color = (newConnected) ? btStatusBlink.cCONNECTED_BLINK : btStatusBlink.cNOTCONNECTED
            }
        }
    }
        
    // status text    
    MyText {
        x: s.winScale(40)
        color: 'white'

        id: lbStatusText
        
        text: 'no connection'
        anchors.verticalCenter: parent.verticalCenter
        
        Connections {
            target: wMain
            onSignalStatusChanged: {
                lbStatusText.text = newStatus
            }
        }    
        Connections {
            target: wMain
            onSignalConnectedChanged: {
                lbStatusText.text = (newConnected) ? 'connected' : 'no connection'
            }
        }
    }
}
