import QtQuick 2.9
import QtQuick.Controls 1.5
import QtQuick.Controls 2.2 as Cntrl2
import QtQuick.Controls.Styles 1.4
import QtQuick.Dialogs 1.2



Dialog {
//------------------------
// Interface        

    property string appName: ''
    property string appVersion: ''

//------------------------

    id: _dialog

    title: 'Share Settings'
    
    contentItem: Rectangle {
    
        id: _rect
        objectName: 'shareSettingsDialog'
        
        color: 'white' //"lightskyblue"
        //implicitWidth: 800
        //implicitHeight: 800
        
        implicitWidth: _ok.width + s.winScale(20) + 3*(_rect._w1 + _rect._w2 + _rect._w3 + 3*s.winScale(10) ) + s.winScale(20)
        
        MyFileDialog { 
            id: _fd 
            title: qsTr('Save Share Setting Screen Shot to File','sharesettingsdialog')
            selectExisting: false
            nameFilters: [ "*.jpg" ]
            //selectedNameFilter = "STorM32 script files (*.scr)" 
            onAccepted: {
                btShareSettingsScreenShotQmlClicked(_rect.objectName, fileUrls)
            }
        }            
        
        MyButton {
            x: 0 //s.winScale(10)
            y: (implicitHeight + 2)*0
            width: height*1.2 //s.winScale(40)
            iconSource: s.iconShareSettingsScreenShot
            iconHeight: height*0.8
            onClicked: {
                _fd.visible = true //btShareSettingsScreenShotQmlClicked(_rect.objectName)
            }
        }

        MyButton {
            id: _ok
            x: 0 //s.winScale(10)
            y: (implicitHeight + 2)*1
            width: height*1.2 //s.winScale(40)
            text: qsTr('OK','sharesettingsdialog')
            onClicked: {
                _dialog.visible = false
            }
        }

        MyText { 
            width: _rect._w1
            anchors.top: parent.top
            anchors.horizontalCenter: parent.horizontalCenter
            text: "OlliW's "+ appName + '\n' + appVersion
            
        }    
        
        readonly property int _w1: s.winScale(150)
        readonly property int _w2: s.winScale(50)
        readonly property int _w3: s.winScale(100)
        
        Row{        
            id: _header
            anchors.left: _ok.right
            anchors.leftMargin: s.winScale(20)
            anchors.right: parent.right
            anchors.top: parent.top
            spacing: s.winScale(10)
            MyText { 
                id: header1
                width: _rect._w1
            }    
            MyText { 
                id: header2
            }    
        }

        Row{        
            id: _row
            anchors.left: _ok.right
            anchors.leftMargin: s.winScale(20)
            anchors.right: parent.right
            anchors.top: _header.bottom
            anchors.bottom: parent.bottom
            spacing: s.winScale(10)
            MyText { id: name1; width: _rect._w1; font.pixelSize: s._fontSize
            }    
            MyText { id: valueRaw1; width: _rect._w2; font.pixelSize: s._fontSize
            }    
            MyText { id: value1; width: _rect._w3; font.pixelSize: s._fontSize
            }    
            MyText { id: name2; width: _rect._w1; font.pixelSize: s._fontSize
            }    
            MyText { id: valueRaw2; width: _rect._w2; font.pixelSize: s._fontSize
            }    
            MyText { id: value2; width: _rect._w3; font.pixelSize: s._fontSize
            }    
            MyText { id: name3; width: _rect._w1; font.pixelSize: s._fontSize
            }    
            MyText { id: valueRaw3; width: _rect._w2; font.pixelSize: s._fontSize
            }    
            MyText { id: value3; width: _rect._w3; font.pixelSize: s._fontSize
            }    
        }    
    
    }
    
    
    function prepareAfterShow() {
//    onVisibleChanged: {
//        if( !visible ) return
//        //hm, this is called twice!
        
        var count = 0
        for(var i=0; i<navBar.paramItems.length; i++){
            if( (navBar.paramItems[i].adr < 0 ) || (navBar.paramItems[i].hidden > 0)  ) continue
            count++
        }
        
        var countThird =  parseInt( count/3 + 0.5 )
        count = 0
        var sname = ['','','']
        var svalueRaw = ['','','']
        var svalue = ['','','']
        for(var i=0; i<navBar.paramItems.length; i++){
        
            if( (navBar.paramItems[i].adr < 0) || (navBar.paramItems[i].hidden > 0)  ) continue
            
            var adr = navBar.paramItems[i].adr
            var n = parseInt(count / countThird)
            count++
            
            sname[n] += navBar.paramItems[i].name.replace(/\(.*$/, '' )  + '\n'
            svalueRaw[n] += ': ' + navBar.paramValues[adr].toString() + '\n'
            svalue[n] += ': ' + getParamValueFormatted(navBar.paramValues[adr],navBar.paramItems[i]) + '\n'
        }
        
        header1.text = 'Firmware Version\nBoard\nName'
        header2.text = ': ' + '?' + '\n' + ': ' + '?' + '\n' + ': ' + '?' + '\n'
        
        name1.text = sname[0]; valueRaw1.text = svalueRaw[0]; value1.text = svalue[0]
        name2.text = sname[1]; valueRaw2.text = svalueRaw[1]; value2.text = svalue[1]
        name3.text = sname[2]; valueRaw3.text = svalueRaw[2]; value3.text = svalue[2]
        
        _dialog.height = header1.height + name1.height + s.winScale(20)
        
        var screen = pyQml.getPrimaryScreenWidthHeight()
        var x = (screen.width - _dialog.width)/2
        if( x < 10 ) x = 10
        var y = (screen.height - _dialog.height)/2 - 10
        if( y < 10 ) y = 10
        _dialog.x = x
        _dialog.y = y
    }
    
    
    // we do not get the values from the MyParamItem objects (since we can't easily)
    // but get them from paramValues
    // this isn't bad, since paramValues is what would be actually written by a Write
    
    // the only bad thing is, we have this function essentially twice, here, and in the MyParamItem qml's !!
    // TODO: would be better to have them in one place
    
    function getParamValueFormatted(value,paramItem) {
        switch( paramItem.type ) {
            case 'INT':
                if( value > 32566 ) value -= 65536
            case 'UINT':
                var fvalue = value
                var svalue = value.toString()
                if( paramItem.ppos != 0 ) {
                    for(var p=0; p<paramItem.ppos; p++) fvalue *= 0.1
                    svalue = fvalue.toFixed(paramItem.ppos);
                }
                if( paramItem.unit != '' ){ svalue += ' ' + paramItem.unit }
                return svalue
            case 'LIST':
                return (value < paramItem.choices.length) ? paramItem.choices[value] : '?'
            default:
                return '?'
        }
    }
    
    
}    
