import QtQuick 2.9
import QtQuick.Controls 1.5
import QtQuick.Controls 2.2 as Cntrl2
import QtQuick.Controls.Styles 1.4
import QtQuick.Dialogs 1.2



Dialog {
//------------------------
// Interface        

    property int scriptNr: -1

    property alias text:  _textarea.text

//------------------------

    id: _dialog

    modality: Qt.ApplicationModal
    //modality: Qt.WindowModal
    
    function openFile() {
        var obj = Qt.createComponent("resources/controls/MyFileDialog.qml").createObject(wMain,{
            "visible": true,
        })
    }
    
    contentItem: Rectangle {
    
        id: _rect
        color: 'white' //"lightskyblue"
        implicitWidth: 400
        implicitHeight: 300
        
        MyFileDialog { 
            property string whatToDo: ''
            id: _fd 
            onAccepted: {
                if( whatToDo == 'load' ) {
                    //LOL
                    // the asnwer to how to read a file
                    // "Just create a QObject derived class, add a read and write slot and implement using QFile, register the class to QML, instantiate it in QML and connect it to the signals of your buttons."
                    var res = pyQml.loadFile(fileUrls)
                    _textarea.text = res.content
                    _error.text = ''
                }
                if( whatToDo == 'save' ) {
                    var res = pyQml.saveFile(fileUrls, _textarea.text)
                    _error.text = ''
                }
            }
        }            
        
        MyButton {
            id: _load
            x: 0
            y: 0
            width: s.winScale(100)
            text: qsTr('Load from File','scripteditdialog')
            onClicked: { //_dialog.openFile() 
                _fd.title = qsTr('Load Script from File','scripteditdialog')
                _fd.selectExisting = true
                _fd.nameFilters = [ "STorM32 script files (*.scr)", "All files (*)" ]
                _fd.selectedNameFilter = "STorM32 script files (*.scr)" 
                _fd.whatToDo = 'load'
                _fd.visible = true //must come last
            }
        }
        MyButton {
            x: 0 //s.winScale(10)
            y: implicitHeight + 2
            width: s.winScale(100)
            text: qsTr('Save to File','scripteditdialog')
            onClicked: { //_dialog.openFile() 
                _fd.title = qsTr('Save Script to File','scripteditdialog')
                _fd.selectExisting = false
                _fd.nameFilters = [ "STorM32 script files (*.scr)", "All files (*)" ]
                _fd.selectedNameFilter = "STorM32 script files (*.scr)" 
                _fd.whatToDo = 'save'
                _fd.visible = true //must come last
            }
        }
        MyButton {
            x: 0 //s.winScale(10)
            y: (implicitHeight + 2)*2
            width: s.winScale(100)
            text: 'Compile'
            onClicked: { 
                var res = scriptJs.compileScriptText(_textarea.text)
                if( res.ok ) {
                    _error.text =  qsTr('Script is OK','scripteditdialog')
                    _error.textColor = 'green'
                } else {
                    _error.text =  res.errorMsg
                    _error.textColor = 'red'
                }
            }
        }
        MyButton {
            x: 0 //s.winScale(10)
            y: (implicitHeight + 2)*4  //have it a bit separate
            width: s.winScale(100)
            text: 'Accept'
            
            onClicked: { 
                var compileRes = scriptJs.compileScriptText(_textarea.text)
                if( compileRes.ok ) {
                    _error.text =  qsTr('Script is OK','scripteditdialog')
                    _error.textColor = 'green'
                    
                    var newScripts = scriptJs.mergeSingleScriptIntoScript(scriptNr,compileRes.script)
                    
                    signalLogText( "\n\n" + qsTr('Compiling... DONE!','scripteditdialog') )
                    var s = ''
                    signalLogText( "\n" + scriptJs.uint8ListToHexstr(newScripts.scripts.slice(0,4)) )
                    s = (newScripts.script1.length > 0) ? scriptJs.uint8ListToHexstr(newScripts.script1) : '-'
                    signalLogText( "\n" + s )
                    s = (newScripts.script2.length > 0) ? scriptJs.uint8ListToHexstr(newScripts.script2) : '-'
                    signalLogText( "\n" + s )
                    s = (newScripts.script3.length > 0) ? scriptJs.uint8ListToHexstr(newScripts.script3) : '-'
                    signalLogText( "\n" + s )
                    s = (newScripts.script4.length > 0) ? scriptJs.uint8ListToHexstr(newScripts.script4) : '-'
                    signalLogText( "\n" + s )
                    signalLogText( "\n" + newScripts.scripts.length.toString() 
                                        + ' '+qsTr('of','scripteditdialog')+' ' 
                                        + navBar.cSCRIPTSIZE.toString() 
                                        + ' ' + qsTr('bytes used','scripteditdialog') )
                    
                    while( newScripts.scripts.length < navBar.cSCRIPTSIZE ) newScripts.scripts.push(0xFF)
                    for(var i=0; i<navBar.cSCRIPTSIZE; i++) {
                        var cp = navBar.cCMD_g_PARAMETER_ZAHL + i
                        navBar.paramValues[cp] = newScripts.scripts[i]
                    }    
                    signalScriptChanged(scriptNr)
                    
                    _dialog.close()
                } else {
                    _error.text =  compileRes.errorMsg
                    _error.textColor = 'red'
                }
            }
        }

        TextArea {
            id: _textarea
            anchors.right: parent.right
            anchors.left: _load.right
            anchors.top: parent.top
            anchors.bottom: _error.top //parent.bottom
            //renderType: Text.NativeRendering
    
            font.family: "Consolas" //"Monaco" //"Lucida Console" //"Lucida Sans"
            font.weight: Font.Medium //Normal //Medium
            font.pixelSize: s._fontSize * 1.2
    
            style: TextAreaStyle {
                incrementControl: null
                decrementControl: null
                handle: Rectangle {
                    implicitWidth: s.winScale(2)
                    implicitHeight: s.winScale(10)
                    radius: implicitWidth/2
                    color: styleData.pressed ? '#505050' : '#C0C0C0'
                }
                scrollBarBackground: Rectangle {
                    implicitWidth: s.winScale(7)
                    implicitHeight: s.winScale(10)
                    color: 'white'
                }        
            }
        }    
        
        TextArea {
            id: _error
            anchors.right: parent.right
            anchors.left: parent.left
            //anchors.top: _textarea.top
            anchors.bottom: parent.bottom
            //renderType: Text.NativeRendering
            
            readOnly: true
            
            implicitHeight: 2*11

            style: TextAreaStyle {
                incrementControl: null
                decrementControl: null
                handle: null
                scrollBarBackground: null
            }    
        }    
        
    }
    
}    

