import QtQuick 2.9
import QtQuick.Controls 1.5
import QtQuick.Controls.Styles 1.4


MyParamItem {
    
    height: s.h
    
    MyTextField {
        id: _textfield
        readOnly: true
        
        x: s.x1
        width: s.width1

        rectangleColor: cModifiedState
    }    

    onStrValueChanged: { _textfield.text = strValue }
        
    Connections {
        target: wMain
        onSignalVersionChanged: {
            if( paramItem['name'] in newVersion ) {
                strValue = newVersion[paramItem['name']] //store info also in strValue, for easier access
                //_textfield.text = strValue //this is captured by signal onStrValueChanged
                setValid()
            }
        }
    }
    Connections {
        target: wMain
        onSignalParamStrByNameChanged: {
            if( paramItem.name.toUpperCase().indexOf(paramName.toUpperCase()) >= 0 ) {
                strValue = newParamStr
            }
        }
    }
    
    Component.onCompleted: {
        strValue = paramItem.default
        setInvalid() //needs to be called again since setValue() may have changed it
    }
}