import QtQuick 2.9
import QtQuick.Controls 1.5
import QtQuick.Controls.Styles 1.4


//this item helps handling the scripts
// it is invisible, but is in the ListView
// it is called and set like all the other parameters (since adr>=0)
// when it is called it
// - does set the script values in paramValues
// - converts the script byte stream to readable text
// - sets the script textareas 
//
// we also could introduce more signals and defere some of the work to the individual MyScriptTextAreas,
// but not all of the work, so let's keep it here and keep MyScriptTextAreas clean
// the disadvantage is that we need to explicitely link to scriptTextArea1, etc.


MyParamItem {
//------------------------
// Interface        

//------------------------
    
    Connections {
        target: wMain
        onSignalParametersChanged: {
            for(var i=0; i<navBar.cSCRIPTSIZE; i++) {
                var cp = navBar.cCMD_g_PARAMETER_ZAHL + i
                navBar.paramValues[cp] = newParameters[cp]
            }    
            updateAllScriptTextAreas(s.cVALID)
        }
    }
    Connections {
        target: wMain
        onSignalConnectedChanged: {
            if( !newConnected ) clearAllScripts()
        }
    }
/*    Connections {
        target: wMain
        onSignalParamScriptChanged: {
            // ???
        }
    }*/
    Connections {
        target: wMain
        onSignalScriptChanged: {
            if( scriptNr == 1 ) {
                scriptTextArea1.text = scriptJs.convertScriptToTextForSingleScript(1,true)
                scriptTextArea1.setModified(s.cMODIFIED) 
            }                
            if( scriptNr == 2 ) {
                scriptTextArea2.text = scriptJs.convertScriptToTextForSingleScript(2,true)
                scriptTextArea2.setModified(s.cMODIFIED) 
            }                
            if( scriptNr == 3 ) {
                scriptTextArea3.text = scriptJs.convertScriptToTextForSingleScript(3,true)
                scriptTextArea3.setModified(s.cMODIFIED) 
            }                
            if( scriptNr == 4 ) {
                scriptTextArea4.text = scriptJs.convertScriptToTextForSingleScript(4,true)
                scriptTextArea4.setModified(s.cMODIFIED) 
            }                
        }
    }
    
    Component.onCompleted: {
        clearAllScripts()
    }
    

    // functions
    
    function clearAllScripts() {
        for(var i=0; i<navBar.cSCRIPTSIZE; i++)
            navBar.paramValues[navBar.cCMD_g_PARAMETER_ZAHL + i] = 255
        updateAllScriptTextAreas(s.cINVALID)
    }

    function updateAllScriptTextAreas(modifiedState) {
        //this converts and sets the script text areas
        scriptTextArea1.text = scriptJs.convertScriptToTextForSingleScript(1,true)
        scriptTextArea2.text = scriptJs.convertScriptToTextForSingleScript(2,true)
        scriptTextArea3.text = scriptJs.convertScriptToTextForSingleScript(3,true)
        scriptTextArea4.text = scriptJs.convertScriptToTextForSingleScript(4,true)
        scriptTextArea1.cModifiedState = modifiedState
        scriptTextArea2.cModifiedState = modifiedState
        scriptTextArea3.cModifiedState = modifiedState
        scriptTextArea4.cModifiedState = modifiedState
    }
}    
