import QtQuick 2.9
import QtQuick.Controls 1.5
import QtQuick.Controls.Styles 1.4


/*
states are
    pressed 
    hovered 
    checked
    enabled
    parent.down
    isDefault
*/

// there is something strange with pressed when used with touch, can be hovered or null afterwards
// if button is pressed, such that it emits a clicked, ensure that all other buttons are 
//   hovered = false
// problem: hovered is readonly

// the touch is used, the mouse "disappears" but seems to stay where it was

// a mouse click leads to a click, a double click to two clicks
// a touch click leads to a click, but does change hover
// a 2nd touch click leads to a click, plus does change hover, but the old button stays in hover though

//parent must have the properties
//  int currentNavIndexStr

Button {
//------------------------
// Interface        

    property int iconHeight: _button.height*0.6

//------------------------

    id: _button

    property string navIndexStr: ''

    property bool _isActive: navIndexStr === parent.currentNavIndexStr

    width: parent.width

    //hoverEnabled: true
    
    //??activeFocusOnPress: true
    
    onClicked: {
        //??forceActiveFocus()
        parent.currentNavIndexStr = navIndexStr
        //TODO inform all other NavButtons, so that they can erase hover
        // isn't there a signal related to the change of currentNavIndexStr?
        // yes: http://doc.qt.io/qt-5/qtqml-syntax-signals.html
    }
/*    
    Connections {
        target: parent
        onCurrentNavIndexStrChanged: {
            if( navIndexStr != parent.currentNavIndexStr ) hovered = false
        }
    }
*/    
    function determineBColor() {
        if( !enabled ) return 'lightgray'
        else if( pressed ) return '#3dca9b' //'red'
        else if( _isActive && hovered ) return '#008d5e' //'yellow' 
        else if( _isActive ) return '#00C080' //'lightgreen'
        else if( hovered ) return '#008d5e' //'green'
        else return 'lightgray'
    }
    
    function determineTColor() {
        if( !enabled ) return 'gray'
        else if( pressed || hovered || _isActive ) return 'white'
        else return 'black'
    }
    
 
    style: ButtonStyle {
        padding{
            left: s.winScale(10)
            right: s.winScale(10)
            top: s.winScale(10)
            bottom: s.winScale(10)
        }
        background: Rectangle {
            color: determineBColor()
        }
        //see  http://master.qt.io/ministro/android/qt5/objects/5.32-armeabi/qml/QtQuick/Controls/Styles/Base/ButtonStyle.qml
        label: Item {
            implicitWidth: _row.implicitWidth
            implicitHeight: _text.implicitHeight
            Row {
                id: _row
                //anchors.centerIn: parent
                anchors.verticalCenter: parent.verticalCenter
                spacing: s.winScale(5)
                Image {
                    source: _button.iconSource
                    anchors.verticalCenter: parent.verticalCenter
                    opacity: enabled ? 1.0 : 0.25
                    fillMode: Image.PreserveAspectFit
                    height: iconHeight
                }
                MyText{
                    id: _text
                    text: _button.text
                    anchors.verticalCenter: parent.verticalCenter
                    
                    color: determineTColor()
                }
            }    
        }
         
        
    }

}