import QtQuick 2.9
import QtQuick.Controls 1.5
import QtQuick.Controls 2.2 as Cntrl2
import QtQuick.Controls.Styles 1.4
import QtQuick.Dialogs 1.2



Dialog {
//------------------------
// Interface        

    property alias text: _text.text
    property alias iText: _text2.text

    signal accepted()
    
//------------------------

    id: _dialog
    
    title: 'Warning'
    
    contentItem: Rectangle {
    
        id: _rect
        color: 'white'

        implicitWidth: s.winScale(400)
        implicitHeight: (_text.height > _icon.height) ? 
                            _text.height + _text2.height + _ok.height + 4*s.winScale(20)
                            : 
                            _icon.height + _text2.height + _ok.height + 4*s.winScale(20)
        
        Image {
            id: _icon
            x: s.winScale(20)
            y: s.winScale(20)
            height: s.winScale(48/2)
            fillMode: Image.PreserveAspectFit
            source: '../icons/warning.png'
        }

        MyText {
            id: _text
            anchors.left: _icon.right
            anchors.leftMargin: s.winScale(20)
            anchors.right: parent.right
            y: s.winScale(20)
            font.bold: true
            wrapMode: Text.WordWrap
        }
        
        MyText {
            id: _text2
            anchors.top: (_text.height > _icon.height) ? _text.bottom : _icon.bottom
            anchors.topMargin: s.winScale(20)
            x: s.winScale(20)
            width: _rect.implicitWidth - 2*s.winScale(20)
            wrapMode: Text.WordWrap
        }
        
        Row{        
            anchors.top: _text2.bottom
            anchors.topMargin: s.winScale(20)
            anchors.bottom: parent.bottom
            anchors.bottomMargin: s.winScale(20)
            anchors.horizontalCenter: parent.horizontalCenter
            spacing: 20
            
            MyButton {
                id: _ok
                width: s.winScale(100)
                text: qsTr('OK','messagedialog')
                onClicked: {
                    _dialog.visible = false
                    accepted()
                }
            }
            MyButton {
                width: s.winScale(100)
                text: qsTr('Cancel','messagedialog')
                onClicked: {
                    _dialog.visible = false
                }
            }
        }        
    }
    
    function prepareBeforeShow() {
    }
    
    Component.onCompleted: {
        _dialog.height = _rect.implicitHeight
        if( _text.contentWidth + _icon.width + 3*s.winScale(20) < _rect.implicitWidth )
            _dialog.width = _text.contentWidth + _icon.width + 3*s.winScale(20)
        else    
            _dialog.width = _rect.implicitWidth
    }
}    














/*
MessageDialog {
//------------------------
// Interface        

    property string iText: ''

//------------------------

    id: _messageDialog
    title: 'Warning'
    icon: StandardIcon.Warning
    text: ''
    informativeText: iText
    standardButtons: StandardButton.Abort | StandardButton.Yes
    
    modality: Qt.ApplicationModal
    //modality: Qt.WindowModal
}    
*/
