import QtQuick 2.9
import QtQuick.Controls 1.5
import QtQuick.Controls.Styles 1.4



TextArea {
//------------------------
// Interface        

//------------------------

    anchors.left: parent.left
    anchors.right: parent.right
        
    readOnly: true
    
    textFormat: TextEdit.RichText
        
    style: TextAreaStyle {
        incrementControl: null
        decrementControl: null
        handle: Rectangle {
            implicitWidth: s.winScale(2)
            implicitHeight: s.winScale(10)
            radius: implicitWidth/2
            color: styleData.pressed ? '#505050' : '#C0C0C0'
        }
        scrollBarBackground: Rectangle {
            implicitWidth: s.winScale(7)
            implicitHeight: s.winScale(10)
            color: 'white'
        }        
    }
    
    function appendText(txt) {
        //either of this works for plaintext,but not richtext:
        //  logArea.text += txt
        //  logArea.flickableItem.contentY = logArea.flickableItem.contentHeight - logArea.height
        //or
        //  logArea.append(txt)
        txt = txt.replace( /\n/g, '<br>', txt)
        insert(logArea.length,txt) //see the docs http://doc.qt.io/qt-5/qml-qtquick-textedit.html#append-method
        flickableItem.contentY = logArea.flickableItem.contentHeight - logArea.height
    }
    
}
