import QtQuick 2.9
import QtQuick.Controls 1.5
import QtQuick.Controls.Styles 1.4


/*
states are
    pressed 
    hovered 
    checked
    enabled
    parent.down
*/

Button {
//------------------------
// Interface        

    property int iconHeight: _button.height
    property bool respondToConnectedChanged: false

//------------------------

    id: _button
    
    property int yPos: 0
    //property int iconSize: 0
    
    x: s.winScale(600-30)
    y: yPos*s.winScale(40)
    width: s.winScale(140)
    
    Connections { 
        target: wMain
        onSignalConnectedChanged: { 
            if( respondToConnectedChanged ) { _button.enabled = newConnected }
        } 
    }            
    
    
    function determineBColor() {
        if( !enabled ) return 'lightgray'
        else if( pressed ) return '#3b9dca'
        else if( hovered ) return '#005e8d'
        else return '#0080c0'
    }
    
    function determineTColor() {
        if( !enabled ) return 'gray' 
        else if( pressed )  return 'white' 
        else if( hovered )  return 'white'
        else return 'white'
    }
 
    style: ButtonStyle {
        padding{
            left: 0
            right: 0
            top: s.winScale(5)
            bottom: s.winScale(5)
        }
        background: Rectangle {
            color: determineBColor()
        }
        label: Item {
            implicitWidth: _row.implicitWidth
            implicitHeight: _text.implicitHeight
            Row {
                id: _row
                anchors.centerIn: parent
                anchors.verticalCenter: parent.verticalCenter
                spacing: s.winScale(5)
                Image {
                    source: _button.iconSource
                    anchors.verticalCenter: parent.verticalCenter
                    opacity: enabled ? 1.0 : 0.25
                    fillMode: Image.PreserveAspectFit
                    height: iconHeight //_button.height
                }
                MyText{
                    id: _text
                    text: _button.text
                    anchors.verticalCenter: parent.verticalCenter
                    color: determineTColor()
                }
            }    
        }
    }
    
}