/* potentially useful tricks:
- inject Object in reusable: https://stackoverflow.com/questions/39612847/how-to-make-some-reusable-qml-object-which-can-inject-another-qml-object
*/
/*
- Button: hover becomes true only after 2nd press/click
- ComboBox: extremly difficult to unfold => use control2 combobox
- occasionally a window close error occurs ???
  External WM_DESTROY received for QQuickView ...
*/

import QtQuick 2.9
import QtQuick.Controls 1.5
import QtQuick.Controls.Styles 1.4
import QtQml.Models 2.2
//all controls are kept in custom files
import "resources/controls"


Rectangle {

    id: wMain
    
    width: s.winScale(900)
    height: s.winScale(590)

//    implicitWidth: s.winScale(900)
//    implicitHeight: s.winScale(590)

    color: 'white'

//------------------------------------  
// global stuff
//------------------------------------  
    
    MyStyle{ id: s }
    MyScriptStuff { id: scriptJs }
        
    
//------------------------------------  
// interface to PyQT code
//------------------------------------  

    //function in Py called from Qml
    // they are available via the id pyQml
    // e.g. pyQml.loadFile()

    // signals internal to Qml
    
    signal signalScriptChanged(int scriptNr)
    signal signalLogText(string txt)   //this would be better placed in MyLogArea, but how to make it available to other objects?

    // signals send from Py to Qml

    signal signalFocChanged(bool newFoc)
    signal signalInfoChanged(var newInfo)
    signal signalStatusChanged(string newStatus)
    signal signalBlinkerChanged(int newBlinker)
    signal signalConnectedChanged(bool newConnected)
    signal signalVersionChanged(var newVersion)
    signal signalParametersChanged(var newParameters)
    signal signalParamValueByNameChanged(string paramName, int newParamValue)
    signal signalParamStrByNameChanged(string paramName, string newParamStr)
    
    // signals send from Qml to Py 
    
    signal btConnectQmlClicked
    signal btReadQmlClicked
    signal btWriteQmlClicked(bool withStore)
    signal btDataDisplayQmlClicked
    signal btAboutQmlClicked
    
    signal btShareSettingsScreenShotQmlClicked(string objectName, string fileUrl)
    signal btChangeBoardNameToolQmlClicked(string boardName)
    signal btAutoTrimQmlClicked
    signal btEnableAllMotorsQmlClicked
    signal btDisableAllMotorsQmlClicked
    signal btGimbalConfigureToolQmlClicked

    signal btLevelGimbalQmlClicked
    signal btRestartControllerQmlClicked
    signal btGetCurrentEncoderPositionQmlClicked
    signal btEraseEepromQmlClicked
    signal btEsp8266ConfigureToolQmlClicked
    signal btChangeUartBaudrateToolQmlClicked(int baudrate)
    signal btChangeEncoderSupportToolQmlClicked
    
    // functions called from Py
    
    function logText(txt) {
        logArea.appendText(txt)        
    }
    
    function setAppNameVersion(appName,appVersion) {
        topLine.appName = appName
        topLine.appVersion = appVersion
        shareSettings.appName = appName
        shareSettings.appVersion = appVersion
    }

    //signal aboutToShow of cbPortPopup
    
    function cbPortPopulateListWith(portList) {
        //console.log(portList)
        topLine.populateList(portList)
    }
    
    function cbPortSetPort(port) {
        //console.log(port)
        topLine.selectPort(port)
    }

    //we store the read/write array in qml
    // this is not really needed, as it is a duplicate of all data in the paramItems
    // but it makes our life easier to get teh data from the paramItems
    // 
    // it would be better if we would do all in qml, and keep info solely in qml, so as to not infect the py code with such info    
    // but it's probably difficult to uphold to that for all functions we want
    // py knows about which fields have adr>=0 or not anyhow, so we let py do the job of setting
    //
    // each MyParamItem object MUST ensure to keep it's entry in paramValues up to date
    // also on signals
    //    signalParametersChanged(var newParameters) 
    //    signalConnectedChanged(bool newConnected)

    // each Write always does first a 'g' before 'p'
    // this is important to get the latest values of those paramters which are not in the GUI (= not in paramItems)
    // at each write we do
    // i) do the 'g' command
    // ii) get the paramValues by calling getParamValues()
    // iii) copy those enries in paramValues with adr>=0 to the param values obtained with 'g'
    // iv) do the 'p' command
    // v) inform qml by emitting the signal signalParametersChanged()

    function setParamValues(newParamValues) {}
    // use  signalParametersChanged(var newParameters) to set paramValues

    function getParamValues() {
        return navBar.paramValues //paramValues was initialized with correct size, it hopefully still has it
    } 
    

//------------------------------------  
// user interface
//------------------------------------  

    MyTopLine {
        id: topLine
    }
    
    // navigation pane and parameter objects 
    // the navBar also holds the lists of parameters and parameter objects
    MyNavBar {
        id: navBar
    
        y: s.winScale(50)
        spacing: 2 //s.winScale(2)
        width: s.winScale(150)
    }
    
    // this holds the nav pages
    // the parameters are injected as ListViews, where relevant
    // they have to be added manually for as many navBar buttons there are
    Item{
        id: navPages
        x: navBar.width + s.winScale(10)
        y: navBar.y
        width: parent.width - s.winScale(150 + 14)
        height: navBar.height

        MyNavPage{
            navIndexStr: 'Dashboard'
            MyParamListView { navIndex: navBar.iDashboard; interactive: false }
            MyButton {
                yPos: 0
                id: btShareParameters
                text: qsTr("Share Parameters")
                //iconSource: 'resources/icons/ic_menu_black_48dp.png'
                onClicked: doShareSettings()
            }
            MyButton {
                yPos: 1
                id: btChangeBoardName
                text: qsTr('Change Board Name')
                respondToConnectedChanged: true
                //iconSource: 'resources/icons/ic_menu_black_48dp.png'
                onClicked: wMain.doChangeBoardNameTool()
            }
            MyInfoCenter {
                y: s.winScale(150)
            }
        }
        MyNavPage {
            navIndexStr: 'PID' 
        
            MyParamListView { id: idPID; navIndex: navBar.iPID }     
        }
        MyNavPage {
            navIndexStr: 'Pan'
        
            MyParamListView { navIndex: navBar.iPan }
        }
        MyNavPage{
            navIndexStr: 'Rc Inputs'
            MyParamListView { navIndex: navBar.iRcInputs }
            
            MyButton {
                yPos: 0
                id: btAutoTrim
                text: qsTr('Auto Trim')
                //iconSource: 'resources/icons/ic_menu_black_48dp.png'
                respondToConnectedChanged: true
                onClicked: btAutoTrimQmlClicked()
            }
        }
        MyNavPage{
            navIndexStr: 'Functions'
            MyParamListView { navIndex: navBar.iFunctions }
        }
        MyNavPage{
            navIndexStr: 'Scripts'
            MyParamListView { navIndex: navBar.iScripts }
            MyButton {
                yPos: 0
                id: btEditScript1
                text: qsTr('Edit Script1')
                //iconSource: 'resources/icons/ic_menu_black_48dp.png'
                onClicked: doScriptEdit(1)
            }
            MyButton {
                yPos: 1
                id: btEditScript2
                text: qsTr('Edit Script2')
                //iconSource: 'resources/icons/ic_menu_black_48dp.png'
                onClicked: doScriptEdit(2)
            }
            MyButton {
                yPos: 2
                id: btEditScript3
                text: qsTr('Edit Script3')
                //iconSource: 'resources/icons/ic_menu_black_48dp.png'
                onClicked: doScriptEdit(3)
            }
            MyButton {
                yPos: 3
                id: btEditScript4
                text: qsTr('Edit Script4')
                //iconSource: 'resources/icons/ic_menu_black_48dp.png'
                onClicked: doScriptEdit(4)
            }
        }
        MyNavPage{
            navIndexStr: 'Setup'
            MyParamListView { navIndex: navBar.iSetup }
            MyButton {
                yPos: 0
                id: btEnableAllMotors
                text: qsTr('Enable All Motors')
                //iconSource: 'resources/icons/ic_menu_black_48dp.png'
                respondToConnectedChanged: true
                onClicked: btEnableAllMotorsQmlClicked()
            }
            MyButton {
                yPos: 1
                id: btDisableAllMotors
                text: qsTr('Disable All Motors')
                //iconSource: 'resources/icons/ic_menu_black_48dp.png'
                respondToConnectedChanged: true
                onClicked: btDisableAllMotorsQmlClicked()
            }
        }
        MyNavPage{
            navIndexStr: 'Gimbal Configuration'
            MyParamListView { navIndex: navBar.iGimbalConfiguration }
            MyButton {
                yPos: 0
                id: btGetCurrentEncoderPosition
                text: qsTr('Get Encoder Positions')
                respondToConnectedChanged: true
                onClicked: btGetCurrentEncoderPositionQmlClicked()
            }
            MyButton {
                yPos: 2
                height: 2*implicitHeight
                id: btGimbalConfigureTool
                text: qsTr('Gimbal Configure Tool')
                //iconSource: 'resources/icons/ic_menu_black_48dp.png'
                onClicked: btGimbalConfigureToolQmlClicked()
            }
        }
        MyNavPage{
            navIndexStr: 'Interfaces'
            MyParamListView { navIndex: navBar.iInterfaces }
        }
        MyNavPage{
            navIndexStr: 'Expert'
            MyParamListView { navIndex: navBar.iExpert }
        }
        
        MyNavPage{
            navIndexStr: 'Calibrations'
            //MyParamListView { navIndex: navBar.iCalibrations }
        }
        MyNavPage{
            navIndexStr: 'Firmware Update'
            //MyParamListView { navIndex: navBar.iFirmwareUpdate }
        }
        MyNavPage{
            navIndexStr: 'Tools'
            //MyParamListView { navIndex: navBar.iTools }
            MyButton {
                x: s.winScale(10); width: s.winScale(200); yPos: 0
                id: btLevelGimbal
                text: qsTr('Level Gimbal')
                respondToConnectedChanged: true
                onClicked: btLevelGimbalQmlClicked()
            }
            MyButton {
                x: s.winScale(10); width: s.winScale(200); yPos: 1
                id: btRestartController
                text: qsTr('Restart Controller')
                respondToConnectedChanged: true
                onClicked: btRestartControllerQmlClicked()
            }
            MyButton {
                x: s.winScale(10); width: s.winScale(200); yPos: 2
                id: btGetCurrentEncoderPosition2
                text: qsTr('Get Current Encoder Position')
                respondToConnectedChanged: true
                onClicked: btGetCurrentEncoderPositionQmlClicked()
            }
            MyButton {
                x: s.winScale(10); width: s.winScale(200); yPos: 4
                id: btChangeBoardName2
                text: qsTr('Change Board Name')
                respondToConnectedChanged: true
                onClicked: doChangeBoardNameTool()
            }
            MyButton {
                x: s.winScale(10); width: s.winScale(200); yPos: 5
                id: btChangeUartBaudrateTool
                text: qsTr('Change Uart Baudrate')
                respondToConnectedChanged: true
                onClicked: doChangeUartBaudRateTool()
            }
            MyButton {
                x: s.winScale(10); width: s.winScale(200); yPos: 6
                id: btChangeEncoderSupportTool
                text: qsTr('Enable Encoder Support')
                respondToConnectedChanged: true
                onClicked: doChangeEncoderSupportTool()
                Connections {
                    target: wMain
                    onSignalFocChanged: {
                        btChangeEncoderSupportTool.text = (newFoc) ? qsTr('Disable Encoder Support') : qsTr('Enable Encoder Support')
                    }
                }
            }
            MyButton {
                x: s.winScale(10); width: s.winScale(200); yPos: 8
                id: btEraseEeprom
                text: qsTr('Erase Eeprom to 0xFF')
                respondToConnectedChanged: true
                onClicked: doEraseEprom()
            }
            MyButton {
                x: s.winScale(300); width: s.winScale(200); yPos: 0
                height: 2*implicitHeight
                id: btGimbalConfigureTool2
                text: qsTr('Gimbal Configure Tool')
                onClicked: btGimbalConfigureToolQmlClicked()
            }
            MyButton {
                x: s.winScale(300); width: s.winScale(200); yPos: 2
                height: 2*implicitHeight
                id: btEsp8266ConfigureTool
                text: qsTr('Esp8266 Configure Tool')
                onClicked: btEsp8266ConfigureToolQmlClicked()
            }
        }
    }
     
    MyLogArea {
        id: logArea
        
        anchors.top: navPages.bottom
        anchors.bottom: statusLine.top
        anchors.topMargin: s.winScale(10)
        Connections {
            target: wMain
            onSignalLogText: { logArea.appendText(txt) }
        }
    }
     
    MyStatusLine {
        id: statusLine
    }
    


    MyShareSettingsDialog{ id: shareSettings }

    function doShareSettings() {
/*        
        var obj = Qt.createComponent("resources/controls/MyScriptEditDialog.qml").createObject(wMain,{
            "visible": true,
            "title": title,
            "scriptNr": scriptNr
        })
        if( obj != null ) obj.text = scriptJs.convertScriptToTextForSingleScript(scriptNr,false)
*/
        shareSettings.visible = true
        shareSettings.prepareAfterShow()
    }

    
    MyScriptEditDialog{ id: scriptEditor }
    
    function doScriptEdit(scriptNr) {
        var title = qsTr('Script Editor: Script %1').arg(scriptNr)
/*        
        var obj = Qt.createComponent("resources/controls/MyScriptEditDialog.qml").createObject(wMain,{
            "visible": true,
            "title": title,
            "scriptNr": scriptNr
        })
        if( obj != null ) obj.text = scriptJs.convertScriptToTextForSingleScript(scriptNr,false)
*/
        scriptEditor.scriptNr = scriptNr
        scriptEditor.title = title
        scriptEditor.text = scriptJs.convertScriptToTextForSingleScript(scriptNr,false)
        scriptEditor.visible = true
    }

    
    function doEraseEprom() {
        //this is very strange: we must not define visible: true in the .qml file, but give it here as parameter
        // otherwise the dialog would not be modal and would not close when the main window is closed !!!
        var obj = Qt.createComponent("resources/controls/MyMessageDialog.qml").createObject(wMain,{
            "parent": wMain,
            "visible": true,
            "text": qsTr('Do you really want to erase the EEPROM?'),
            "iText": qsTr('NOTE: This will reset all your settings to default values.')
        })
        if( obj == null ) return
        obj.onAccepted.connect(function(){ btEraseEepromQmlClicked() })
    }
    
    
    MyBoardNameEditDialog{ id: boardNameEditor }
    
    function doChangeBoardNameTool() {
        boardNameEditor.prepareBeforeShow()
        boardNameEditor.visible = true
        boardNameEditor.prepareAfterShow()
    }

    
    MyUartBaudrateEditDialog{ id: uartBaudrateEditor  }
    
    function doChangeUartBaudRateTool() {
        //BUG?!?!? doesn't seem to work on the py side
        return
        uartBaudrateEditor.prepareBeforeShow()
        uartBaudrateEditor.visible = true
        uartBaudrateEditor.prepareAfterShow()
    }
    
    
    function doChangeEncoderSupportTool() {
        var t = (btChangeEncoderSupportTool.text.indexOf('Disable') >= 0) ? 
                    qsTr('Do you really want to disable the encoder support?') 
                    : 
                    qsTr('Do you really want to enable the encoder support?')
        var obj = Qt.createComponent("resources/controls/MyMessageDialog.qml").createObject(wMain,{
            "parent": wMain,
            "text": t,
            "iText": qsTr('NOTE: On >OK< the new setting will be stored immediately to the EEPROM. The change becomes effective with the next power up, the controller is thus restarted.'),
            "visible": true,
        })
        if( obj == null ) return
        obj.onAccepted.connect(function(){ btChangeEncoderSupportToolQmlClicked() })
    }
    

    Component.onCompleted: {
    }
}
