#!/usr/bin/env python
#STorM32 parameters list, generated by PySTorM32_createParamJsons.py

paramLayoutVersion = 236

#this is the JSON of parameters
# it is different from paramItems, in that 'page' needs to be translated to 'nav'
paramJson = [
    {
        "steps" : 1,
        "page" : "dashboard",
        "name" : "Firmware Version",
        "default" : "",
        "size" : 16,
        "foc" : 0,
        "unit" : "",
        "hidden" : 0,
        "type" : "STR+READONLY",
        "column" : 1
    },
    {
        "steps" : 1,
        "page" : "dashboard",
        "name" : "Board",
        "default" : "",
        "size" : 16,
        "foc" : 0,
        "unit" : "",
        "hidden" : 0,
        "type" : "STR+READONLY"
    },
    {
        "steps" : 1,
        "page" : "dashboard",
        "name" : "Name",
        "default" : "",
        "size" : 16,
        "foc" : 0,
        "unit" : "",
        "hidden" : 0,
        "type" : "STR+READONLY"
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "pid",
        "max" : 6,
        "choices" : [
            "off",
            "1.5 ms",
            "3.0 ms",
            "4.5 ms",
            "6.0 ms",
            "7.5 ms",
            "9 ms"
        ],
        "size" : 1,
        "adr" : 12,
        "pos" : [
            1,
            1
        ],
        "min" : 0,
        "name" : "Gyro LPF",
        "default" : 1,
        "foc" : 1,
        "unit" : "",
        "type" : "LIST",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "pid",
        "max" : 6,
        "choices" : [
            "off",
            "1.5 ms",
            "3.0 ms",
            "4.5 ms",
            "6.0 ms",
            "7.5 ms",
            "9 ms"
        ],
        "size" : 1,
        "adr" : 41,
        "pos" : [
            1,
            1
        ],
        "min" : 0,
        "name" : "Foc Gyro LPF",
        "default" : 1,
        "foc" : 2,
        "unit" : "",
        "hidden" : 0,
        "type" : "LIST"
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "pid",
        "max" : 6,
        "choices" : [
            "off",
            "1.5 ms",
            "4 ms",
            "10 ms",
            "22 ms",
            "46 ms",
            "94 ms"
        ],
        "size" : 1,
        "adr" : 72,
        "min" : 0,
        "name" : "Imu2 FeedForward LPF",
        "default" : 1,
        "foc" : 3,
        "unit" : "",
        "type" : "LIST",
        "hidden" : 0
    },
    {
        "len" : 7,
        "steps" : 1,
        "ppos" : 0,
        "page" : "pid",
        "max" : 200,
        "size" : 2,
        "adr" : 75,
        "pos" : [
            1,
            4
        ],
        "min" : 0,
        "name" : "Voltage Correction",
        "default" : 0,
        "foc" : 3,
        "unit" : "%",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 5,
        "steps" : 1,
        "ppos" : 0,
        "page" : "pid",
        "max" : 100,
        "size" : 2,
        "adr" : 73,
        "min" : 0,
        "name" : "Roll Yaw PD Mixing",
        "default" : 0,
        "foc" : 0,
        "unit" : "%",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 5,
        "steps" : 10,
        "ppos" : 2,
        "page" : "pid",
        "max" : 3000,
        "size" : 2,
        "adr" : 0,
        "pos" : [
            2,
            1
        ],
        "min" : 0,
        "name" : "Pitch P",
        "default" : 400,
        "foc" : 1,
        "unit" : "",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 7,
        "steps" : 50,
        "ppos" : 1,
        "page" : "pid",
        "max" : 32000,
        "size" : 2,
        "adr" : 1,
        "min" : 0,
        "name" : "Pitch I",
        "default" : 1000,
        "foc" : 1,
        "unit" : "",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 3,
        "steps" : 50,
        "ppos" : 4,
        "page" : "pid",
        "max" : 8000,
        "size" : 2,
        "adr" : 2,
        "min" : 0,
        "name" : "Pitch D",
        "default" : 500,
        "foc" : 1,
        "unit" : "",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 5,
        "steps" : 1,
        "ppos" : 0,
        "page" : "pid",
        "max" : 255,
        "size" : 2,
        "adr" : 3,
        "min" : 0,
        "name" : "Pitch Motor Vmax",
        "default" : 150,
        "foc" : 1,
        "unit" : "",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 5,
        "steps" : 10,
        "ppos" : 2,
        "page" : "pid",
        "max" : 3000,
        "size" : 2,
        "adr" : 4,
        "pos" : [
            3,
            1
        ],
        "min" : 0,
        "name" : "Roll P",
        "default" : 400,
        "foc" : 1,
        "unit" : "",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 7,
        "steps" : 50,
        "ppos" : 1,
        "page" : "pid",
        "max" : 32000,
        "size" : 2,
        "adr" : 5,
        "min" : 0,
        "name" : "Roll I",
        "default" : 1000,
        "foc" : 1,
        "unit" : "",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 3,
        "steps" : 50,
        "ppos" : 4,
        "page" : "pid",
        "max" : 8000,
        "size" : 2,
        "adr" : 6,
        "min" : 0,
        "name" : "Roll D",
        "default" : 500,
        "foc" : 1,
        "unit" : "",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 5,
        "steps" : 1,
        "ppos" : 0,
        "page" : "pid",
        "max" : 255,
        "size" : 2,
        "adr" : 7,
        "min" : 0,
        "name" : "Roll Motor Vmax",
        "default" : 150,
        "foc" : 1,
        "unit" : "",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 5,
        "steps" : 10,
        "ppos" : 2,
        "page" : "pid",
        "max" : 3000,
        "size" : 2,
        "adr" : 8,
        "pos" : [
            4,
            1
        ],
        "min" : 0,
        "name" : "Yaw P",
        "default" : 400,
        "foc" : 1,
        "unit" : "",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 7,
        "steps" : 50,
        "ppos" : 1,
        "page" : "pid",
        "max" : 32000,
        "size" : 2,
        "adr" : 9,
        "min" : 0,
        "name" : "Yaw I",
        "default" : 1000,
        "foc" : 1,
        "unit" : "",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 3,
        "steps" : 50,
        "ppos" : 4,
        "page" : "pid",
        "max" : 8000,
        "size" : 2,
        "adr" : 10,
        "min" : 0,
        "name" : "Yaw D",
        "default" : 500,
        "foc" : 1,
        "unit" : "",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 5,
        "steps" : 1,
        "ppos" : 0,
        "page" : "pid",
        "max" : 255,
        "size" : 2,
        "adr" : 11,
        "min" : 0,
        "name" : "Yaw Motor Vmax",
        "default" : 150,
        "foc" : 1,
        "unit" : "",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 5,
        "steps" : 10,
        "ppos" : 2,
        "page" : "pid",
        "max" : 3000,
        "size" : 2,
        "adr" : 23,
        "pos" : [
            2,
            1
        ],
        "min" : 0,
        "name" : "Foc Pitch P",
        "default" : 400,
        "foc" : 2,
        "unit" : "",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 7,
        "steps" : 50,
        "ppos" : 1,
        "page" : "pid",
        "max" : 32000,
        "size" : 2,
        "adr" : 24,
        "min" : 0,
        "name" : "Foc Pitch I",
        "default" : 100,
        "foc" : 2,
        "unit" : "",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 3,
        "steps" : 50,
        "ppos" : 4,
        "page" : "pid",
        "max" : 8000,
        "size" : 2,
        "adr" : 25,
        "min" : 0,
        "name" : "Foc Pitch D",
        "default" : 2000,
        "foc" : 2,
        "unit" : "",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 5,
        "steps" : 1,
        "ppos" : 1,
        "page" : "pid",
        "max" : 100,
        "size" : 2,
        "adr" : 26,
        "min" : 1,
        "name" : "Foc Pitch K",
        "default" : 10,
        "foc" : 2,
        "unit" : "",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 5,
        "steps" : 10,
        "ppos" : 2,
        "page" : "pid",
        "max" : 3000,
        "size" : 2,
        "adr" : 29,
        "pos" : [
            3,
            1
        ],
        "min" : 0,
        "name" : "Foc Roll P",
        "default" : 400,
        "foc" : 2,
        "unit" : "",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 7,
        "steps" : 50,
        "ppos" : 1,
        "page" : "pid",
        "max" : 32000,
        "size" : 2,
        "adr" : 30,
        "min" : 0,
        "name" : "Foc Roll I",
        "default" : 100,
        "foc" : 2,
        "unit" : "",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 3,
        "steps" : 50,
        "ppos" : 4,
        "page" : "pid",
        "max" : 8000,
        "size" : 2,
        "adr" : 31,
        "min" : 0,
        "name" : "Foc Roll D",
        "default" : 2000,
        "foc" : 2,
        "unit" : "",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 5,
        "steps" : 1,
        "ppos" : 1,
        "page" : "pid",
        "max" : 100,
        "size" : 2,
        "adr" : 32,
        "min" : 1,
        "name" : "Foc Roll K",
        "default" : 10,
        "foc" : 2,
        "unit" : "",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 5,
        "steps" : 10,
        "ppos" : 2,
        "page" : "pid",
        "max" : 3000,
        "size" : 2,
        "adr" : 35,
        "pos" : [
            4,
            1
        ],
        "min" : 0,
        "name" : "Foc Yaw P",
        "default" : 400,
        "foc" : 2,
        "unit" : "",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 7,
        "steps" : 50,
        "ppos" : 1,
        "page" : "pid",
        "max" : 32000,
        "size" : 2,
        "adr" : 36,
        "min" : 0,
        "name" : "Foc Yaw I",
        "default" : 100,
        "foc" : 2,
        "unit" : "",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 3,
        "steps" : 50,
        "ppos" : 4,
        "page" : "pid",
        "max" : 8000,
        "size" : 2,
        "adr" : 37,
        "min" : 0,
        "name" : "Foc Yaw D",
        "default" : 2000,
        "foc" : 2,
        "unit" : "",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 5,
        "steps" : 1,
        "ppos" : 1,
        "page" : "pid",
        "max" : 100,
        "size" : 2,
        "adr" : 38,
        "min" : 1,
        "name" : "Foc Yaw K",
        "default" : 10,
        "foc" : 2,
        "unit" : "",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "pan",
        "max" : 42,
        "choices" : [
            "off",
            "Rc-0",
            "Rc-1",
            "Rc-2",
            "Rc2-0",
            "Rc2-1",
            "Rc2-2",
            "Rc2-3",
            "Pot-0",
            "Pot-1",
            "Pot-2",
            "Virtual-1",
            "Virtual-2",
            "Virtual-3",
            "Virtual-4",
            "Virtual-5",
            "Virtual-6",
            "Virtual-7",
            "Virtual-8",
            "Virtual-9",
            "Virtual-10",
            "Virtual-11",
            "Virtual-12",
            "Virtual-13",
            "Virtual-14",
            "Virtual-15",
            "Virtual-16",
            "But switch",
            "But latch",
            "But step",
            "Aux-0 switch",
            "Aux-1 switch",
            "Aux-2 switch",
            "Aux-01 switch",
            "Aux-012 switch",
            "Aux-0 latch",
            "Aux-1 latch",
            "Aux-2 latch",
            "Aux-01 latch",
            "Aux-012 latch",
            "Aux-0 step",
            "Aux-1 step",
            "Aux-2 step"
        ],
        "size" : 1,
        "adr" : 79,
        "column" : 1,
        "min" : 0,
        "name" : "Pan Mode Control",
        "default" : 0,
        "foc" : 0,
        "unit" : "",
        "hidden" : 0,
        "type" : "LIST"
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "pan",
        "max" : 5,
        "choices" : [
            "hold hold pan",
            "hold hold hold",
            "pan pan pan",
            "pan hold hold",
            "pan hold pan",
            "hold pan pan",
            "off"
        ],
        "size" : 1,
        "adr" : 80,
        "min" : 0,
        "name" : "Pan Mode Default Setting",
        "default" : 0,
        "foc" : 0,
        "unit" : "",
        "type" : "LIST",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "pan",
        "max" : 6,
        "choices" : [
            "hold hold pan",
            "hold hold hold",
            "pan pan pan",
            "pan hold hold",
            "pan hold pan",
            "hold pan pan",
            "off"
        ],
        "size" : 1,
        "adr" : 81,
        "min" : 0,
        "name" : "Pan Mode Setting #1",
        "default" : 1,
        "foc" : 0,
        "unit" : "",
        "type" : "LIST",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "pan",
        "max" : 6,
        "choices" : [
            "hold hold pan",
            "hold hold hold",
            "pan pan pan",
            "pan hold hold",
            "pan hold pan",
            "hold pan pan",
            "off"
        ],
        "size" : 1,
        "adr" : 82,
        "min" : 0,
        "name" : "Pan Mode Setting #2",
        "default" : 4,
        "foc" : 0,
        "unit" : "",
        "type" : "LIST",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "pan",
        "max" : 6,
        "choices" : [
            "hold hold pan",
            "hold hold hold",
            "pan pan pan",
            "pan hold hold",
            "pan hold pan",
            "hold pan pan",
            "off"
        ],
        "size" : 1,
        "adr" : 83,
        "min" : 0,
        "name" : "Pan Mode Setting #3",
        "default" : 2,
        "foc" : 0,
        "unit" : "",
        "type" : "LIST",
        "hidden" : 0
    },
    {
        "len" : 5,
        "steps" : 1,
        "ppos" : 1,
        "page" : "pan",
        "max" : 50,
        "size" : 2,
        "adr" : 84,
        "column" : 2,
        "min" : 0,
        "name" : "Pitch Pan (0 = hold)",
        "default" : 20,
        "foc" : 0,
        "unit" : "",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 5,
        "steps" : 10,
        "ppos" : 1,
        "page" : "pan",
        "max" : 600,
        "size" : 2,
        "adr" : 85,
        "pos" : [
            2,
            3
        ],
        "min" : 0,
        "name" : "Pitch Pan Deadband",
        "default" : 0,
        "foc" : 0,
        "unit" : "°",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 5,
        "steps" : 1,
        "ppos" : 0,
        "page" : "pan",
        "max" : 100,
        "size" : 2,
        "adr" : 86,
        "min" : 0,
        "name" : "Pitch Pan Expo",
        "default" : 0,
        "foc" : 0,
        "unit" : "%",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 5,
        "steps" : 1,
        "ppos" : 1,
        "page" : "pan",
        "max" : 50,
        "size" : 2,
        "adr" : 87,
        "column" : 3,
        "min" : 0,
        "name" : "Roll Pan (0 = hold)",
        "default" : 20,
        "foc" : 0,
        "unit" : "",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 5,
        "steps" : 10,
        "ppos" : 1,
        "page" : "pan",
        "max" : 600,
        "size" : 2,
        "adr" : 88,
        "pos" : [
            3,
            3
        ],
        "min" : 0,
        "name" : "Roll Pan Deadband",
        "default" : 0,
        "foc" : 0,
        "unit" : "°",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 5,
        "steps" : 1,
        "ppos" : 0,
        "page" : "pan",
        "max" : 100,
        "size" : 2,
        "adr" : 89,
        "min" : 0,
        "name" : "Roll Pan Expo",
        "default" : 0,
        "foc" : 0,
        "unit" : "%",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 5,
        "steps" : 1,
        "ppos" : 1,
        "page" : "pan",
        "max" : 50,
        "size" : 2,
        "adr" : 90,
        "column" : 4,
        "min" : 0,
        "name" : "Yaw Pan (0 = hold)",
        "default" : 20,
        "foc" : 0,
        "unit" : "",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 5,
        "steps" : 5,
        "ppos" : 1,
        "page" : "pan",
        "max" : 100,
        "size" : 2,
        "adr" : 91,
        "pos" : [
            4,
            3
        ],
        "min" : 0,
        "name" : "Yaw Pan Deadband",
        "default" : 50,
        "foc" : 0,
        "unit" : "°",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 5,
        "steps" : 1,
        "ppos" : 0,
        "page" : "pan",
        "max" : 100,
        "size" : 2,
        "adr" : 92,
        "min" : 0,
        "name" : "Yaw Pan Expo",
        "default" : 0,
        "foc" : 0,
        "unit" : "%",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 5,
        "steps" : 5,
        "ppos" : 2,
        "page" : "pan",
        "max" : 400,
        "size" : 2,
        "adr" : 93,
        "min" : 0,
        "name" : "Yaw Pan Deadband LPF",
        "default" : 150,
        "foc" : 0,
        "unit" : "s",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "rcinputs",
        "max" : 50,
        "size" : 2,
        "adr" : 96,
        "min" : 0,
        "name" : "Rc Dead Band",
        "default" : 10,
        "foc" : 0,
        "unit" : "us",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "rcinputs",
        "max" : 50,
        "size" : 2,
        "adr" : 97,
        "min" : 0,
        "name" : "Rc Hysteresis",
        "default" : 5,
        "foc" : 0,
        "unit" : "us",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "rcinputs",
        "max" : 100,
        "size" : 2,
        "adr" : 104,
        "pos" : [
            1,
            4
        ],
        "min" : -100,
        "name" : "Rc Pitch Trim",
        "default" : 0,
        "foc" : 0,
        "unit" : "us",
        "type" : "INT",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "rcinputs",
        "max" : 100,
        "size" : 2,
        "adr" : 111,
        "min" : -100,
        "name" : "Rc Roll Trim",
        "default" : 0,
        "foc" : 0,
        "unit" : "us",
        "type" : "INT",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "rcinputs",
        "max" : 100,
        "size" : 2,
        "adr" : 118,
        "min" : -100,
        "name" : "Rc Yaw Trim",
        "default" : 0,
        "foc" : 0,
        "unit" : "us",
        "type" : "INT",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "rcinputs",
        "max" : 42,
        "choices" : [
            "off",
            "Rc-0",
            "Rc-1",
            "Rc-2",
            "Rc2-0",
            "Rc2-1",
            "Rc2-2",
            "Rc2-3",
            "Pot-0",
            "Pot-1",
            "Pot-2",
            "Virtual-1",
            "Virtual-2",
            "Virtual-3",
            "Virtual-4",
            "Virtual-5",
            "Virtual-6",
            "Virtual-7",
            "Virtual-8",
            "Virtual-9",
            "Virtual-10",
            "Virtual-11",
            "Virtual-12",
            "Virtual-13",
            "Virtual-14",
            "Virtual-15",
            "Virtual-16",
            "But switch",
            "But latch",
            "But step",
            "Aux-0 switch",
            "Aux-1 switch",
            "Aux-2 switch",
            "Aux-01 switch",
            "Aux-012 switch",
            "Aux-0 latch",
            "Aux-1 latch",
            "Aux-2 latch",
            "Aux-01 latch",
            "Aux-012 latch",
            "Aux-0 step",
            "Aux-1 step",
            "Aux-2 step"
        ],
        "size" : 1,
        "adr" : 102,
        "column" : 2,
        "min" : 0,
        "name" : "Rc Pitch",
        "default" : 0,
        "foc" : 0,
        "unit" : "",
        "hidden" : 0,
        "type" : "LIST"
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "rcinputs",
        "max" : 2,
        "choices" : [
            "absolute",
            "relative",
            "absolute centered"
        ],
        "size" : 1,
        "adr" : 103,
        "min" : 0,
        "name" : "Rc Pitch Mode",
        "default" : 0,
        "foc" : 0,
        "unit" : "",
        "type" : "LIST",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 5,
        "ppos" : 1,
        "page" : "rcinputs",
        "max" : 1200,
        "size" : 2,
        "adr" : 105,
        "min" : -1200,
        "name" : "Rc Pitch Min",
        "default" : -250,
        "foc" : 0,
        "unit" : "°",
        "type" : "INT",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 5,
        "ppos" : 1,
        "page" : "rcinputs",
        "max" : 1200,
        "size" : 2,
        "adr" : 106,
        "min" : -1200,
        "name" : "Rc Pitch Max",
        "default" : 250,
        "foc" : 0,
        "unit" : "°",
        "type" : "INT",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 5,
        "ppos" : 1,
        "page" : "rcinputs",
        "max" : 1000,
        "size" : 2,
        "adr" : 107,
        "min" : 0,
        "name" : "Rc Pitch Speed Limit (0 = off)",
        "default" : 400,
        "foc" : 0,
        "unit" : "°/s",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 10,
        "ppos" : 3,
        "page" : "rcinputs",
        "max" : 1000,
        "size" : 2,
        "adr" : 108,
        "min" : 0,
        "name" : "Rc Pitch Accel Limit (0 = off)",
        "default" : 300,
        "foc" : 0,
        "unit" : "",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "rcinputs",
        "max" : 42,
        "choices" : [
            "off",
            "Rc-0",
            "Rc-1",
            "Rc-2",
            "Rc2-0",
            "Rc2-1",
            "Rc2-2",
            "Rc2-3",
            "Pot-0",
            "Pot-1",
            "Pot-2",
            "Virtual-1",
            "Virtual-2",
            "Virtual-3",
            "Virtual-4",
            "Virtual-5",
            "Virtual-6",
            "Virtual-7",
            "Virtual-8",
            "Virtual-9",
            "Virtual-10",
            "Virtual-11",
            "Virtual-12",
            "Virtual-13",
            "Virtual-14",
            "Virtual-15",
            "Virtual-16",
            "But switch",
            "But latch",
            "But step",
            "Aux-0 switch",
            "Aux-1 switch",
            "Aux-2 switch",
            "Aux-01 switch",
            "Aux-012 switch",
            "Aux-0 latch",
            "Aux-1 latch",
            "Aux-2 latch",
            "Aux-01 latch",
            "Aux-012 latch",
            "Aux-0 step",
            "Aux-1 step",
            "Aux-2 step"
        ],
        "size" : 1,
        "adr" : 109,
        "column" : 3,
        "min" : 0,
        "name" : "Rc Roll",
        "default" : 0,
        "foc" : 0,
        "unit" : "",
        "hidden" : 0,
        "type" : "LIST"
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "rcinputs",
        "max" : 2,
        "choices" : [
            "absolute",
            "relative",
            "absolute centered"
        ],
        "size" : 1,
        "adr" : 110,
        "min" : 0,
        "name" : "Rc Roll Mode",
        "default" : 0,
        "foc" : 0,
        "unit" : "",
        "type" : "LIST",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 5,
        "ppos" : 1,
        "page" : "rcinputs",
        "max" : 450,
        "size" : 2,
        "adr" : 112,
        "min" : -450,
        "name" : "Rc Roll Min",
        "default" : -250,
        "foc" : 0,
        "unit" : "°",
        "type" : "INT",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 5,
        "ppos" : 1,
        "page" : "rcinputs",
        "max" : 450,
        "size" : 2,
        "adr" : 113,
        "min" : -450,
        "name" : "Rc Roll Max",
        "default" : 250,
        "foc" : 0,
        "unit" : "°",
        "type" : "INT",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 5,
        "ppos" : 1,
        "page" : "rcinputs",
        "max" : 1000,
        "size" : 2,
        "adr" : 114,
        "min" : 0,
        "name" : "Rc Roll Speed Limit (0 = off)",
        "default" : 400,
        "foc" : 0,
        "unit" : "°/s",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 10,
        "ppos" : 3,
        "page" : "rcinputs",
        "max" : 1000,
        "size" : 2,
        "adr" : 115,
        "min" : 0,
        "name" : "Rc Roll Accel Limit (0 = off)",
        "default" : 300,
        "foc" : 0,
        "unit" : "",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "rcinputs",
        "max" : 42,
        "choices" : [
            "off",
            "Rc-0",
            "Rc-1",
            "Rc-2",
            "Rc2-0",
            "Rc2-1",
            "Rc2-2",
            "Rc2-3",
            "Pot-0",
            "Pot-1",
            "Pot-2",
            "Virtual-1",
            "Virtual-2",
            "Virtual-3",
            "Virtual-4",
            "Virtual-5",
            "Virtual-6",
            "Virtual-7",
            "Virtual-8",
            "Virtual-9",
            "Virtual-10",
            "Virtual-11",
            "Virtual-12",
            "Virtual-13",
            "Virtual-14",
            "Virtual-15",
            "Virtual-16",
            "But switch",
            "But latch",
            "But step",
            "Aux-0 switch",
            "Aux-1 switch",
            "Aux-2 switch",
            "Aux-01 switch",
            "Aux-012 switch",
            "Aux-0 latch",
            "Aux-1 latch",
            "Aux-2 latch",
            "Aux-01 latch",
            "Aux-012 latch",
            "Aux-0 step",
            "Aux-1 step",
            "Aux-2 step"
        ],
        "size" : 1,
        "adr" : 116,
        "column" : 4,
        "min" : 0,
        "name" : "Rc Yaw",
        "default" : 0,
        "foc" : 0,
        "unit" : "",
        "hidden" : 0,
        "type" : "LIST"
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "rcinputs",
        "max" : 3,
        "choices" : [
            "absolute",
            "relative",
            "absolute centered",
            "relative turn around"
        ],
        "size" : 1,
        "adr" : 117,
        "min" : 0,
        "name" : "Rc Yaw Mode",
        "default" : 0,
        "foc" : 0,
        "unit" : "",
        "type" : "LIST",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 10,
        "ppos" : 1,
        "page" : "rcinputs",
        "max" : 2700,
        "size" : 2,
        "adr" : 119,
        "min" : -2700,
        "name" : "Rc Yaw Min",
        "default" : -250,
        "foc" : 0,
        "unit" : "°",
        "type" : "INT",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 10,
        "ppos" : 1,
        "page" : "rcinputs",
        "max" : 2700,
        "size" : 2,
        "adr" : 120,
        "min" : -2700,
        "name" : "Rc Yaw Max",
        "default" : 250,
        "foc" : 0,
        "unit" : "°",
        "type" : "INT",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 5,
        "ppos" : 1,
        "page" : "rcinputs",
        "max" : 1000,
        "size" : 2,
        "adr" : 121,
        "min" : 0,
        "name" : "Rc Yaw Speed Limit (0 = off)",
        "default" : 400,
        "foc" : 0,
        "unit" : "°/s",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 10,
        "ppos" : 3,
        "page" : "rcinputs",
        "max" : 1000,
        "size" : 2,
        "adr" : 122,
        "min" : 0,
        "name" : "Rc Yaw Accel Limit (0 = off)",
        "default" : 300,
        "foc" : 0,
        "unit" : "",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "functions",
        "max" : 42,
        "choices" : [
            "off",
            "Rc-0",
            "Rc-1",
            "Rc-2",
            "Rc2-0",
            "Rc2-1",
            "Rc2-2",
            "Rc2-3",
            "Pot-0",
            "Pot-1",
            "Pot-2",
            "Virtual-1",
            "Virtual-2",
            "Virtual-3",
            "Virtual-4",
            "Virtual-5",
            "Virtual-6",
            "Virtual-7",
            "Virtual-8",
            "Virtual-9",
            "Virtual-10",
            "Virtual-11",
            "Virtual-12",
            "Virtual-13",
            "Virtual-14",
            "Virtual-15",
            "Virtual-16",
            "But switch",
            "But latch",
            "But step",
            "Aux-0 switch",
            "Aux-1 switch",
            "Aux-2 switch",
            "Aux-01 switch",
            "Aux-012 switch",
            "Aux-0 latch",
            "Aux-1 latch",
            "Aux-2 latch",
            "Aux-01 latch",
            "Aux-012 latch",
            "Aux-0 step",
            "Aux-1 step",
            "Aux-2 step"
        ],
        "size" : 1,
        "adr" : 123,
        "column" : 1,
        "min" : 0,
        "name" : "Standby",
        "default" : 0,
        "foc" : 0,
        "unit" : "",
        "hidden" : 0,
        "type" : "LIST"
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "functions",
        "max" : 42,
        "choices" : [
            "off",
            "Rc-0",
            "Rc-1",
            "Rc-2",
            "Rc2-0",
            "Rc2-1",
            "Rc2-2",
            "Rc2-3",
            "Pot-0",
            "Pot-1",
            "Pot-2",
            "Virtual-1",
            "Virtual-2",
            "Virtual-3",
            "Virtual-4",
            "Virtual-5",
            "Virtual-6",
            "Virtual-7",
            "Virtual-8",
            "Virtual-9",
            "Virtual-10",
            "Virtual-11",
            "Virtual-12",
            "Virtual-13",
            "Virtual-14",
            "Virtual-15",
            "Virtual-16",
            "But switch",
            "But latch",
            "But step",
            "Aux-0 switch",
            "Aux-1 switch",
            "Aux-2 switch",
            "Aux-01 switch",
            "Aux-012 switch",
            "Aux-0 latch",
            "Aux-1 latch",
            "Aux-2 latch",
            "Aux-01 latch",
            "Aux-012 latch",
            "Aux-0 step",
            "Aux-1 step",
            "Aux-2 step"
        ],
        "size" : 1,
        "adr" : 124,
        "pos" : [
            1,
            3
        ],
        "min" : 0,
        "name" : "Re-center Camera",
        "default" : 0,
        "foc" : 0,
        "unit" : "",
        "hidden" : 0,
        "type" : "LIST"
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "functions",
        "max" : 42,
        "choices" : [
            "off",
            "Rc-0",
            "Rc-1",
            "Rc-2",
            "Rc2-0",
            "Rc2-1",
            "Rc2-2",
            "Rc2-3",
            "Pot-0",
            "Pot-1",
            "Pot-2",
            "Virtual-1",
            "Virtual-2",
            "Virtual-3",
            "Virtual-4",
            "Virtual-5",
            "Virtual-6",
            "Virtual-7",
            "Virtual-8",
            "Virtual-9",
            "Virtual-10",
            "Virtual-11",
            "Virtual-12",
            "Virtual-13",
            "Virtual-14",
            "Virtual-15",
            "Virtual-16",
            "But switch",
            "But latch",
            "But step",
            "Aux-0 switch",
            "Aux-1 switch",
            "Aux-2 switch",
            "Aux-01 switch",
            "Aux-012 switch",
            "Aux-0 latch",
            "Aux-1 latch",
            "Aux-2 latch",
            "Aux-01 latch",
            "Aux-012 latch",
            "Aux-0 step",
            "Aux-1 step",
            "Aux-2 step"
        ],
        "size" : 1,
        "adr" : 125,
        "column" : 2,
        "min" : 0,
        "name" : "IR Camera Control",
        "default" : 0,
        "foc" : 0,
        "unit" : "",
        "hidden" : 0,
        "type" : "LIST"
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "functions",
        "max" : 5,
        "choices" : [
            "Sony Nex",
            "Canon",
            "Panasonic",
            "Nikon",
            "Git2 Rc",
            "CAMremote"
        ],
        "size" : 1,
        "adr" : 126,
        "min" : 0,
        "name" : "Camera Model",
        "default" : 0,
        "foc" : 0,
        "unit" : "",
        "type" : "LIST",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "functions",
        "max" : 2,
        "choices" : [
            "shutter",
            "shutter delay",
            "video on/off"
        ],
        "size" : 1,
        "adr" : 127,
        "min" : 0,
        "name" : "IR Camera Setting #1",
        "default" : 0,
        "foc" : 0,
        "unit" : "",
        "type" : "LIST",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "functions",
        "max" : 3,
        "choices" : [
            "shutter",
            "shutter delay",
            "video on/off",
            "off"
        ],
        "size" : 1,
        "adr" : 128,
        "min" : 0,
        "name" : "IR Camera Setting #2",
        "default" : 2,
        "foc" : 0,
        "unit" : "",
        "type" : "LIST",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 1,
        "page" : "functions",
        "max" : 150,
        "size" : 2,
        "adr" : 129,
        "min" : 0,
        "name" : "Time Interval (0 = off)",
        "default" : 0,
        "foc" : 0,
        "unit" : "s",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "functions",
        "max" : 42,
        "choices" : [
            "off",
            "Rc-0",
            "Rc-1",
            "Rc-2",
            "Rc2-0",
            "Rc2-1",
            "Rc2-2",
            "Rc2-3",
            "Pot-0",
            "Pot-1",
            "Pot-2",
            "Virtual-1",
            "Virtual-2",
            "Virtual-3",
            "Virtual-4",
            "Virtual-5",
            "Virtual-6",
            "Virtual-7",
            "Virtual-8",
            "Virtual-9",
            "Virtual-10",
            "Virtual-11",
            "Virtual-12",
            "Virtual-13",
            "Virtual-14",
            "Virtual-15",
            "Virtual-16",
            "But switch",
            "But latch",
            "But step",
            "Aux-0 switch",
            "Aux-1 switch",
            "Aux-2 switch",
            "Aux-01 switch",
            "Aux-012 switch",
            "Aux-0 latch",
            "Aux-1 latch",
            "Aux-2 latch",
            "Aux-01 latch",
            "Aux-012 latch",
            "Aux-0 step",
            "Aux-1 step",
            "Aux-2 step"
        ],
        "size" : 1,
        "adr" : 130,
        "column" : 3,
        "min" : 0,
        "name" : "Pwm Out Control",
        "default" : 0,
        "foc" : 0,
        "unit" : "",
        "hidden" : 0,
        "type" : "LIST"
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "functions",
        "max" : 2100,
        "size" : 2,
        "adr" : 131,
        "min" : 900,
        "name" : "Pwm Out Mid",
        "default" : 1500,
        "foc" : 0,
        "unit" : "us",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 10,
        "ppos" : 0,
        "page" : "functions",
        "max" : 2100,
        "size" : 2,
        "adr" : 132,
        "min" : 900,
        "name" : "Pwm Out Min",
        "default" : 1100,
        "foc" : 0,
        "unit" : "us",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 10,
        "ppos" : 0,
        "page" : "functions",
        "max" : 2100,
        "size" : 2,
        "adr" : 133,
        "min" : 900,
        "name" : "Pwm Out Max",
        "default" : 1900,
        "foc" : 0,
        "unit" : "us",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 5,
        "ppos" : 0,
        "page" : "functions",
        "max" : 1000,
        "size" : 2,
        "adr" : 134,
        "min" : 0,
        "name" : "Pwm Out Speed Limit (0 = off)",
        "default" : 0,
        "foc" : 0,
        "unit" : "us/s",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "scripts",
        "max" : 42,
        "choices" : [
            "off",
            "Rc-0",
            "Rc-1",
            "Rc-2",
            "Rc2-0",
            "Rc2-1",
            "Rc2-2",
            "Rc2-3",
            "Pot-0",
            "Pot-1",
            "Pot-2",
            "Virtual-1",
            "Virtual-2",
            "Virtual-3",
            "Virtual-4",
            "Virtual-5",
            "Virtual-6",
            "Virtual-7",
            "Virtual-8",
            "Virtual-9",
            "Virtual-10",
            "Virtual-11",
            "Virtual-12",
            "Virtual-13",
            "Virtual-14",
            "Virtual-15",
            "Virtual-16",
            "But switch",
            "But latch",
            "But step",
            "Aux-0 switch",
            "Aux-1 switch",
            "Aux-2 switch",
            "Aux-01 switch",
            "Aux-012 switch",
            "Aux-0 latch",
            "Aux-1 latch",
            "Aux-2 latch",
            "Aux-01 latch",
            "Aux-012 latch",
            "Aux-0 step",
            "Aux-1 step",
            "Aux-2 step"
        ],
        "size" : 1,
        "adr" : 150,
        "column" : 1,
        "min" : 0,
        "name" : "Script1 Control",
        "default" : 0,
        "foc" : 0,
        "unit" : "",
        "hidden" : 0,
        "type" : "LIST"
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "scripts",
        "max" : 42,
        "choices" : [
            "off",
            "Rc-0",
            "Rc-1",
            "Rc-2",
            "Rc2-0",
            "Rc2-1",
            "Rc2-2",
            "Rc2-3",
            "Pot-0",
            "Pot-1",
            "Pot-2",
            "Virtual-1",
            "Virtual-2",
            "Virtual-3",
            "Virtual-4",
            "Virtual-5",
            "Virtual-6",
            "Virtual-7",
            "Virtual-8",
            "Virtual-9",
            "Virtual-10",
            "Virtual-11",
            "Virtual-12",
            "Virtual-13",
            "Virtual-14",
            "Virtual-15",
            "Virtual-16",
            "But switch",
            "But latch",
            "But step",
            "Aux-0 switch",
            "Aux-1 switch",
            "Aux-2 switch",
            "Aux-01 switch",
            "Aux-012 switch",
            "Aux-0 latch",
            "Aux-1 latch",
            "Aux-2 latch",
            "Aux-01 latch",
            "Aux-012 latch",
            "Aux-0 step",
            "Aux-1 step",
            "Aux-2 step"
        ],
        "size" : 1,
        "adr" : 151,
        "column" : 2,
        "min" : 0,
        "name" : "Script2 Control",
        "default" : 0,
        "foc" : 0,
        "unit" : "",
        "hidden" : 0,
        "type" : "LIST"
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "scripts",
        "max" : 42,
        "choices" : [
            "off",
            "Rc-0",
            "Rc-1",
            "Rc-2",
            "Rc2-0",
            "Rc2-1",
            "Rc2-2",
            "Rc2-3",
            "Pot-0",
            "Pot-1",
            "Pot-2",
            "Virtual-1",
            "Virtual-2",
            "Virtual-3",
            "Virtual-4",
            "Virtual-5",
            "Virtual-6",
            "Virtual-7",
            "Virtual-8",
            "Virtual-9",
            "Virtual-10",
            "Virtual-11",
            "Virtual-12",
            "Virtual-13",
            "Virtual-14",
            "Virtual-15",
            "Virtual-16",
            "But switch",
            "But latch",
            "But step",
            "Aux-0 switch",
            "Aux-1 switch",
            "Aux-2 switch",
            "Aux-01 switch",
            "Aux-012 switch",
            "Aux-0 latch",
            "Aux-1 latch",
            "Aux-2 latch",
            "Aux-01 latch",
            "Aux-012 latch",
            "Aux-0 step",
            "Aux-1 step",
            "Aux-2 step"
        ],
        "size" : 1,
        "adr" : 152,
        "column" : 3,
        "min" : 0,
        "name" : "Script3 Control",
        "default" : 0,
        "foc" : 0,
        "unit" : "",
        "hidden" : 0,
        "type" : "LIST"
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "scripts",
        "max" : 42,
        "choices" : [
            "off",
            "Rc-0",
            "Rc-1",
            "Rc-2",
            "Rc2-0",
            "Rc2-1",
            "Rc2-2",
            "Rc2-3",
            "Pot-0",
            "Pot-1",
            "Pot-2",
            "Virtual-1",
            "Virtual-2",
            "Virtual-3",
            "Virtual-4",
            "Virtual-5",
            "Virtual-6",
            "Virtual-7",
            "Virtual-8",
            "Virtual-9",
            "Virtual-10",
            "Virtual-11",
            "Virtual-12",
            "Virtual-13",
            "Virtual-14",
            "Virtual-15",
            "Virtual-16",
            "But switch",
            "But latch",
            "But step",
            "Aux-0 switch",
            "Aux-1 switch",
            "Aux-2 switch",
            "Aux-01 switch",
            "Aux-012 switch",
            "Aux-0 latch",
            "Aux-1 latch",
            "Aux-2 latch",
            "Aux-01 latch",
            "Aux-012 latch",
            "Aux-0 step",
            "Aux-1 step",
            "Aux-2 step"
        ],
        "size" : 1,
        "adr" : 153,
        "column" : 4,
        "min" : 0,
        "name" : "Script4 Control",
        "default" : 0,
        "foc" : 0,
        "unit" : "",
        "hidden" : 0,
        "type" : "LIST"
    },
    {
        "len" : 0,
        "steps" : 0,
        "ppos" : 0,
        "page" : "scripts",
        "max" : 0,
        "size" : 128,
        "adr" : 154,
        "min" : 0,
        "name" : "Scripts",
        "default" : "",
        "foc" : 0,
        "unit" : "",
        "type" : "SCRIPT",
        "hidden" : 1
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "setup",
        "max" : 2,
        "choices" : [
            "off",
            "full",
            "full xy"
        ],
        "size" : 1,
        "adr" : 53,
        "min" : 0,
        "name" : "Imu2 Configuration",
        "default" : 0,
        "foc" : 3,
        "unit" : "",
        "type" : "LIST",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "setup",
        "max" : 1,
        "choices" : [
            "normal",
            "fast"
        ],
        "size" : 1,
        "adr" : 140,
        "pos" : [
            1,
            4
        ],
        "min" : 0,
        "name" : "Startup Mode",
        "default" : 0,
        "foc" : 3,
        "unit" : "",
        "hidden" : 0,
        "type" : "LIST"
    },
    {
        "len" : 0,
        "steps" : 5,
        "ppos" : 1,
        "page" : "setup",
        "max" : 250,
        "size" : 2,
        "adr" : 141,
        "min" : 0,
        "name" : "Startup Delay",
        "default" : 0,
        "foc" : 0,
        "unit" : "s",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 5,
        "steps" : 100,
        "ppos" : 2,
        "page" : "setup",
        "max" : 2500,
        "size" : 2,
        "adr" : 61,
        "min" : 0,
        "name" : "Imu AHRS",
        "default" : 1000,
        "foc" : 0,
        "unit" : "s",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "setup",
        "max" : 11,
        "choices" : [
            "off",
            "sum ppm 6",
            "sum ppm 7",
            "sum ppm 8",
            "sum ppm 10",
            "sum ppm 12",
            "spektrum 10 bit",
            "spektrum 11 bit",
            "sbus",
            "hott sumd",
            "srxl",
            "serial"
        ],
        "size" : 1,
        "adr" : 77,
        "column" : 2,
        "min" : 0,
        "name" : "Virtual Channel Configuration",
        "default" : 0,
        "foc" : 0,
        "unit" : "",
        "hidden" : 0,
        "type" : "LIST"
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "setup",
        "max" : 2,
        "choices" : [
            "off",
            "1520 us 55 Hz",
            "1520 us 250 Hz"
        ],
        "size" : 1,
        "adr" : 78,
        "min" : 0,
        "name" : "Pwm Out Configuration",
        "default" : 0,
        "foc" : 0,
        "unit" : "",
        "type" : "LIST",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 5,
        "ppos" : 1,
        "page" : "setup",
        "max" : 1200,
        "size" : 2,
        "adr" : 99,
        "pos" : [
            2,
            4
        ],
        "min" : -1200,
        "name" : "Rc Pitch Offset",
        "default" : 0,
        "foc" : 0,
        "unit" : "°",
        "type" : "INT",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 5,
        "ppos" : 1,
        "page" : "setup",
        "max" : 1200,
        "size" : 2,
        "adr" : 100,
        "min" : -1200,
        "name" : "Rc Roll Offset",
        "default" : 0,
        "foc" : 0,
        "unit" : "°",
        "type" : "INT",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 5,
        "ppos" : 1,
        "page" : "setup",
        "max" : 1200,
        "size" : 2,
        "adr" : 101,
        "min" : -1200,
        "name" : "Rc Yaw Offset",
        "default" : 0,
        "foc" : 0,
        "unit" : "°",
        "type" : "INT",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "setup",
        "max" : 2,
        "choices" : [
            "off",
            "uart",
            "uart2"
        ],
        "size" : 1,
        "adr" : 147,
        "pos" : [
            3,
            1
        ],
        "min" : 0,
        "name" : "Esp Configuration",
        "default" : 0,
        "foc" : 0,
        "unit" : "",
        "hidden" : 0,
        "type" : "LIST"
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "setup",
        "max" : 1,
        "choices" : [
            "off",
            "oled display"
        ],
        "size" : 1,
        "adr" : 48,
        "min" : 0,
        "name" : "Uart1 Tx Configuration",
        "default" : 0,
        "foc" : 0,
        "unit" : "",
        "type" : "LIST",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "setup",
        "max" : 11,
        "choices" : [
            "off",
            "2.5 V/cell",
            "2.6 V/cell",
            "2.7 V/cell",
            "2.8 V/cell",
            "2.9 V/cell",
            "3.0 V/cell",
            "3.1 V/cell",
            "3.2 V/cell",
            "3.3 V/cell",
            "3.4 V/cell",
            "3.5 V/cell"
        ],
        "size" : 1,
        "adr" : 74,
        "pos" : [
            3,
            4
        ],
        "min" : 0,
        "name" : "Low Voltage Limit",
        "default" : 1,
        "foc" : 0,
        "unit" : "",
        "hidden" : 0,
        "type" : "LIST"
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "setup",
        "max" : 2,
        "choices" : [
            "off",
            "basic",
            "all"
        ],
        "size" : 1,
        "adr" : 143,
        "min" : 0,
        "name" : "Beep with Motors",
        "default" : 0,
        "foc" : 0,
        "unit" : "",
        "type" : "LIST",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "setup",
        "max" : 7,
        "choices" : [
            "off",
            "basic",
            "basic + pid",
            "basic + accgyro",
            "basic + accgyro_raw",
            "basic + pid + accgyro",
            "basic + pid + ag_raw",
            "full"
        ],
        "size" : 1,
        "adr" : 142,
        "min" : 0,
        "name" : "NT Logging",
        "default" : 0,
        "foc" : 0,
        "unit" : "",
        "type" : "LIST",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "setup",
        "max" : 3,
        "choices" : [
            "normal",
            "level",
            "startup pos",
            "disabled"
        ],
        "size" : 1,
        "adr" : 55,
        "column" : 4,
        "min" : 0,
        "name" : "Pitch Motor Usage",
        "default" : 3,
        "foc" : 0,
        "unit" : "",
        "hidden" : 0,
        "type" : "LIST"
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "setup",
        "max" : 3,
        "choices" : [
            "normal",
            "level",
            "startup pos",
            "disabled"
        ],
        "size" : 1,
        "adr" : 56,
        "min" : 0,
        "name" : "Roll Motor Usage",
        "default" : 3,
        "foc" : 0,
        "unit" : "",
        "type" : "LIST",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "setup",
        "max" : 3,
        "choices" : [
            "normal",
            "level",
            "startup pos",
            "disabled"
        ],
        "size" : 1,
        "adr" : 57,
        "min" : 0,
        "name" : "Yaw Motor Usage",
        "default" : 3,
        "foc" : 0,
        "unit" : "",
        "type" : "LIST",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "gimbalconfig",
        "max" : 23,
        "choices" : [
            "no.0:  z0°   x  y  z",
            "no.1:  z90°  -y  x  z",
            "no.2:  z180°  -x -y  z",
            "no.3:  z270°   y -x  z",
            "no.4:  x0°   y  z  x",
            "no.5:  x90°  -z  y  x",
            "no.6:  x180°  -y -z  x",
            "no.7:  x270°   z -y  x",
            "no.8:  y0°   z  x  y",
            "no.9:  y90°  -x  z  y",
            "no.10:  y180°  -z -x  y",
            "no.11:  y270°   x -z  y",
            "no.12:  -z0°   y  x -z",
            "no.13:  -z90°  -x  y -z",
            "no.14:  -z180°  -y -x -z",
            "no.15:  -z270°   x -y -z",
            "no.16:  -x0°   z  y -x",
            "no.17:  -x90°  -y  z -x",
            "no.18:  -x180°  -z -y -x",
            "no.19:  -x270°   y -z -x",
            "no.20:  -y0°   x  z -y",
            "no.21:  -y90°  -z  x -y",
            "no.22:  -y180°  -x -z -y",
            "no.23:  -y270°   z -x -y"
        ],
        "size" : 1,
        "adr" : 51,
        "pos" : [
            1,
            1
        ],
        "min" : 0,
        "name" : "Imu Orientation",
        "default" : 0,
        "foc" : 0,
        "unit" : "",
        "hidden" : 0,
        "type" : "LIST"
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "gimbalconfig",
        "max" : 23,
        "choices" : [
            "no.0:  z0°   x  y  z",
            "no.1:  z90°  -y  x  z",
            "no.2:  z180°  -x -y  z",
            "no.3:  z270°   y -x  z",
            "no.4:  x0°   y  z  x",
            "no.5:  x90°  -z  y  x",
            "no.6:  x180°  -y -z  x",
            "no.7:  x270°   z -y  x",
            "no.8:  y0°   z  x  y",
            "no.9:  y90°  -x  z  y",
            "no.10:  y180°  -z -x  y",
            "no.11:  y270°   x -z  y",
            "no.12:  -z0°   y  x -z",
            "no.13:  -z90°  -x  y -z",
            "no.14:  -z180°  -y -x -z",
            "no.15:  -z270°   x -y -z",
            "no.16:  -x0°   z  y -x",
            "no.17:  -x90°  -y  z -x",
            "no.18:  -x180°  -z -y -x",
            "no.19:  -x270°   y -z -x",
            "no.20:  -y0°   x  z -y",
            "no.21:  -y90°  -z  x -y",
            "no.22:  -y180°  -x -z -y",
            "no.23:  -y270°   z -x -y"
        ],
        "size" : 1,
        "adr" : 54,
        "min" : 0,
        "name" : "Imu2 Orientation",
        "default" : 0,
        "foc" : 0,
        "unit" : "",
        "type" : "LIST",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 2,
        "ppos" : 0,
        "page" : "gimbalconfig",
        "max" : 42,
        "size" : 2,
        "adr" : 13,
        "pos" : [
            2,
            1
        ],
        "min" : 8,
        "name" : "Pitch Motor Poles",
        "default" : 14,
        "foc" : 1,
        "unit" : "",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "gimbalconfig",
        "max" : 2,
        "choices" : [
            "normal",
            "reversed",
            "auto"
        ],
        "size" : 1,
        "adr" : 14,
        "min" : 0,
        "name" : "Pitch Motor Direction",
        "default" : 2,
        "foc" : 1,
        "unit" : "",
        "type" : "LIST",
        "hidden" : 0
    },
    {
        "len" : 5,
        "steps" : 1,
        "ppos" : 0,
        "page" : "gimbalconfig",
        "max" : 1008,
        "size" : 2,
        "adr" : 15,
        "min" : 0,
        "name" : "Pitch Startup Motor Pos",
        "default" : 504,
        "foc" : 1,
        "unit" : "",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "gimbalconfig",
        "max" : 1,
        "choices" : [
            "normal",
            "reversed",
            "auto"
        ],
        "size" : 1,
        "adr" : 42,
        "pos" : [
            2,
            1
        ],
        "min" : 0,
        "name" : "Foc Pitch Motor Direction",
        "default" : 0,
        "foc" : 2,
        "unit" : "",
        "hidden" : 0,
        "type" : "LIST"
    },
    {
        "len" : 5,
        "steps" : 8,
        "ppos" : 0,
        "page" : "gimbalconfig",
        "max" : 16383,
        "size" : 2,
        "adr" : 43,
        "min" : -16384,
        "name" : "Foc Pitch Zero Pos",
        "default" : 0,
        "foc" : 2,
        "unit" : "",
        "type" : "INT",
        "hidden" : 0
    },
    {
        "len" : 5,
        "steps" : 5,
        "ppos" : 2,
        "page" : "gimbalconfig",
        "max" : 300,
        "size" : 2,
        "adr" : 58,
        "pos" : [
            2,
            4
        ],
        "min" : -300,
        "name" : "Pitch Offset",
        "default" : 0,
        "foc" : 0,
        "unit" : "°",
        "type" : "INT",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 2,
        "ppos" : 0,
        "page" : "gimbalconfig",
        "max" : 42,
        "size" : 2,
        "adr" : 16,
        "pos" : [
            3,
            1
        ],
        "min" : 8,
        "name" : "Roll Motor Poles",
        "default" : 14,
        "foc" : 1,
        "unit" : "",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "gimbalconfig",
        "max" : 2,
        "choices" : [
            "normal",
            "reversed",
            "auto"
        ],
        "size" : 1,
        "adr" : 17,
        "min" : 0,
        "name" : "Roll Motor Direction",
        "default" : 2,
        "foc" : 1,
        "unit" : "",
        "type" : "LIST",
        "hidden" : 0
    },
    {
        "len" : 5,
        "steps" : 1,
        "ppos" : 0,
        "page" : "gimbalconfig",
        "max" : 1008,
        "size" : 2,
        "adr" : 18,
        "min" : 0,
        "name" : "Roll Startup Motor Pos",
        "default" : 504,
        "foc" : 1,
        "unit" : "",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "gimbalconfig",
        "max" : 1,
        "choices" : [
            "normal",
            "reversed",
            "auto"
        ],
        "size" : 1,
        "adr" : 44,
        "pos" : [
            3,
            1
        ],
        "min" : 0,
        "name" : "Foc Roll Motor Direction",
        "default" : 0,
        "foc" : 2,
        "unit" : "",
        "hidden" : 0,
        "type" : "LIST"
    },
    {
        "len" : 5,
        "steps" : 8,
        "ppos" : 0,
        "page" : "gimbalconfig",
        "max" : 16383,
        "size" : 2,
        "adr" : 45,
        "min" : -16384,
        "name" : "Foc Roll Zero Pos",
        "default" : 0,
        "foc" : 2,
        "unit" : "",
        "type" : "INT",
        "hidden" : 0
    },
    {
        "len" : 5,
        "steps" : 5,
        "ppos" : 2,
        "page" : "gimbalconfig",
        "max" : 300,
        "size" : 2,
        "adr" : 59,
        "pos" : [
            3,
            4
        ],
        "min" : -300,
        "name" : "Roll Offset",
        "default" : 0,
        "foc" : 0,
        "unit" : "°",
        "type" : "INT",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 2,
        "ppos" : 0,
        "page" : "gimbalconfig",
        "max" : 42,
        "size" : 2,
        "adr" : 19,
        "pos" : [
            4,
            1
        ],
        "min" : 8,
        "name" : "Yaw Motor Poles",
        "default" : 14,
        "foc" : 1,
        "unit" : "",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "gimbalconfig",
        "max" : 2,
        "choices" : [
            "normal",
            "reversed",
            "auto"
        ],
        "size" : 1,
        "adr" : 20,
        "min" : 0,
        "name" : "Yaw Motor Direction",
        "default" : 2,
        "foc" : 1,
        "unit" : "",
        "type" : "LIST",
        "hidden" : 0
    },
    {
        "len" : 5,
        "steps" : 1,
        "ppos" : 0,
        "page" : "gimbalconfig",
        "max" : 1008,
        "size" : 2,
        "adr" : 21,
        "min" : 0,
        "name" : "Yaw Startup Motor Pos",
        "default" : 504,
        "foc" : 1,
        "unit" : "",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "gimbalconfig",
        "max" : 1,
        "choices" : [
            "normal",
            "reversed",
            "auto"
        ],
        "size" : 1,
        "adr" : 46,
        "pos" : [
            4,
            1
        ],
        "min" : 0,
        "name" : "Foc Yaw Motor Direction",
        "default" : 0,
        "foc" : 2,
        "unit" : "",
        "hidden" : 0,
        "type" : "LIST"
    },
    {
        "len" : 5,
        "steps" : 8,
        "ppos" : 0,
        "page" : "gimbalconfig",
        "max" : 16383,
        "size" : 2,
        "adr" : 47,
        "min" : -16384,
        "name" : "Foc Yaw Zero Pos",
        "default" : 0,
        "foc" : 2,
        "unit" : "",
        "type" : "INT",
        "hidden" : 0
    },
    {
        "len" : 5,
        "steps" : 5,
        "ppos" : 2,
        "page" : "gimbalconfig",
        "max" : 300,
        "size" : 2,
        "adr" : 60,
        "pos" : [
            4,
            4
        ],
        "min" : -300,
        "name" : "Yaw Offset",
        "default" : 0,
        "foc" : 0,
        "unit" : "°",
        "type" : "INT",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "expert",
        "max" : 5,
        "choices" : [
            "M0=pitch , M1=roll",
            "M0=roll , M1=pitch",
            "roll yaw pitch",
            "yaw roll pitch",
            "pitch yaw roll",
            "yaw pitch roll"
        ],
        "size" : 1,
        "adr" : 22,
        "column" : 3,
        "min" : 0,
        "name" : "Motor Mapping",
        "default" : 0,
        "foc" : 3,
        "unit" : "",
        "hidden" : 0,
        "type" : "LIST"
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "expert",
        "max" : 1,
        "choices" : [
            "1 = id1 , 2 = id2",
            "1 = id2 , 2 = id1"
        ],
        "size" : 1,
        "adr" : 52,
        "min" : 0,
        "name" : "Imu Mapping",
        "default" : 0,
        "foc" : 0,
        "unit" : "",
        "type" : "LIST",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "expert",
        "max" : 6,
        "choices" : [
            "auto",
            "1 S",
            "2 S",
            "3 S",
            "4 S",
            "5 S",
            "6 S"
        ],
        "size" : 1,
        "adr" : 49,
        "pos" : [
            3,
            4
        ],
        "min" : 0,
        "name" : "Lipo Cells",
        "default" : 0,
        "foc" : 0,
        "unit" : "",
        "hidden" : 0,
        "type" : "LIST"
    },
    {
        "len" : 0,
        "steps" : 5,
        "ppos" : 2,
        "page" : "expert",
        "max" : 500,
        "size" : 2,
        "adr" : 50,
        "min" : 300,
        "name" : "Lipo Voltage per Cell",
        "default" : 420,
        "foc" : 0,
        "unit" : "V",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 10,
        "ppos" : 0,
        "page" : "expert",
        "max" : 2000,
        "size" : 2,
        "adr" : 76,
        "min" : 1000,
        "name" : "ADC Calibration",
        "default" : 1550,
        "foc" : 0,
        "unit" : "",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "expert",
        "max" : 5,
        "choices" : [
            "off",
            "default",
            "2 = id2, 3 = onboard",
            "2 = onboard, 3 = id2",
            "2 = onboard, 3 = id3",
            "2 = onboard, 3 = off"
        ],
        "size" : 1,
        "adr" : 135,
        "column" : 4,
        "min" : 0,
        "name" : "Imu3 Configuration",
        "default" : 0,
        "foc" : 0,
        "unit" : "",
        "hidden" : 0,
        "type" : "LIST"
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "expert",
        "max" : 23,
        "choices" : [
            "no.0:  z0°   x  y  z",
            "no.1:  z90°  -y  x  z",
            "no.2:  z180°  -x -y  z",
            "no.3:  z270°   y -x  z",
            "no.4:  x0°   y  z  x",
            "no.5:  x90°  -z  y  x",
            "no.6:  x180°  -y -z  x",
            "no.7:  x270°   z -y  x",
            "no.8:  y0°   z  x  y",
            "no.9:  y90°  -x  z  y",
            "no.10:  y180°  -z -x  y",
            "no.11:  y270°   x -z  y",
            "no.12:  -z0°   y  x -z",
            "no.13:  -z90°  -x  y -z",
            "no.14:  -z180°  -y -x -z",
            "no.15:  -z270°   x -y -z",
            "no.16:  -x0°   z  y -x",
            "no.17:  -x90°  -y  z -x",
            "no.18:  -x180°  -z -y -x",
            "no.19:  -x270°   y -z -x",
            "no.20:  -y0°   x  z -y",
            "no.21:  -y90°  -z  x -y",
            "no.22:  -y180°  -x -z -y",
            "no.23:  -y270°   z -x -y"
        ],
        "size" : 1,
        "adr" : 136,
        "min" : 0,
        "name" : "Imu3 Orientation",
        "default" : 0,
        "foc" : 0,
        "unit" : "",
        "type" : "LIST",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "expert",
        "max" : 6,
        "choices" : [
            "off",
            "1.5 ms",
            "4.5 ms",
            "12 ms",
            "25 ms",
            "50 ms",
            "100 ms"
        ],
        "size" : 1,
        "adr" : 71,
        "column" : 1,
        "min" : 0,
        "name" : "Acc LPF",
        "default" : 2,
        "foc" : 0,
        "unit" : "",
        "hidden" : 0,
        "type" : "LIST"
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "expert",
        "max" : 6,
        "choices" : [
            "off",
            "1.5 ms",
            "4.5 ms",
            "12 ms",
            "25 ms",
            "50 ms",
            "100 ms"
        ],
        "size" : 1,
        "adr" : 98,
        "min" : 0,
        "name" : "Rc Adc LPF",
        "default" : 0,
        "foc" : 0,
        "unit" : "",
        "type" : "LIST",
        "hidden" : 0
    },
    {
        "len" : 5,
        "steps" : 25,
        "ppos" : 0,
        "page" : "expert",
        "max" : 1000,
        "size" : 2,
        "adr" : 95,
        "min" : 0,
        "name" : "Hold To Pan Transition Time",
        "default" : 250,
        "foc" : 0,
        "unit" : "ms",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "expert",
        "max" : 1,
        "choices" : [
            "standard",
            "advanced"
        ],
        "size" : 1,
        "adr" : 65,
        "pos" : [
            1,
            6
        ],
        "min" : 0,
        "name" : "Acc Compensation Method",
        "default" : 1,
        "foc" : 0,
        "unit" : "",
        "hidden" : 0,
        "type" : "LIST"
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "expert",
        "max" : 7,
        "choices" : [
            "default",
            "9600",
            "19200",
            "38400",
            "57600",
            "115200",
            "230400",
            "460800"
        ],
        "size" : 1,
        "adr" : 68,
        "pos" : [
            2,
            1
        ],
        "min" : 0,
        "name" : "Uart Baudrate",
        "default" : 0,
        "foc" : 0,
        "unit" : "",
        "hidden" : 0,
        "type" : "LIST"
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "expert",
        "max" : 7,
        "choices" : [
            "default",
            "9600",
            "19200",
            "38400",
            "57600",
            "115200",
            "230400",
            "460800"
        ],
        "size" : 1,
        "adr" : 69,
        "min" : 0,
        "name" : "Uart2 Baudrate",
        "default" : 0,
        "foc" : 0,
        "unit" : "",
        "type" : "LIST",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "expert",
        "max" : 7,
        "choices" : [
            "default",
            "9600",
            "19200",
            "38400",
            "57600",
            "115200",
            "230400",
            "460800"
        ],
        "size" : 1,
        "adr" : 70,
        "min" : 0,
        "name" : "Usb Baudrate",
        "default" : 0,
        "foc" : 0,
        "unit" : "",
        "type" : "LIST",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "interfaces",
        "max" : 3,
        "choices" : [
            "no heartbeat",
            "emit heartbeat",
            "heartbeat + attitude",
            "h.b. + mountstatus"
        ],
        "size" : 1,
        "adr" : 144,
        "pos" : [
            1,
            1
        ],
        "min" : 0,
        "name" : "Mavlink Configuration",
        "default" : 0,
        "foc" : 0,
        "unit" : "",
        "hidden" : 0,
        "type" : "LIST"
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "interfaces",
        "max" : 2,
        "choices" : [
            "uart",
            "usb",
            "uart2"
        ],
        "size" : 1,
        "adr" : 66,
        "min" : 0,
        "name" : "Mavlink ComPort",
        "default" : 0,
        "foc" : 0,
        "unit" : "",
        "type" : "LIST",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "interfaces",
        "max" : 255,
        "size" : 2,
        "adr" : 145,
        "min" : 0,
        "name" : "Mavlink System ID",
        "default" : 71,
        "foc" : 0,
        "unit" : "",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "interfaces",
        "max" : 255,
        "size" : 2,
        "adr" : 146,
        "min" : 0,
        "name" : "Mavlink Component ID",
        "default" : 67,
        "foc" : 0,
        "unit" : "",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "interfaces",
        "max" : 1,
        "choices" : [
            "off",
            "apcrap+v0.96"
        ],
        "size" : 1,
        "adr" : 67,
        "min" : 0,
        "name" : "AP Compatibility",
        "default" : 0,
        "foc" : 0,
        "unit" : "",
        "type" : "LIST",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "interfaces",
        "max" : 2,
        "choices" : [
            "off",
            "uavcan",
            "dji naza"
        ],
        "size" : 1,
        "adr" : 148,
        "pos" : [
            2,
            1
        ],
        "min" : 0,
        "name" : "Can Configuration",
        "default" : 0,
        "foc" : 0,
        "unit" : "",
        "hidden" : 0,
        "type" : "LIST"
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "interfaces",
        "max" : 124,
        "size" : 2,
        "adr" : 149,
        "min" : 11,
        "name" : "Uavcan Node ID",
        "default" : 71,
        "foc" : 0,
        "unit" : "",
        "type" : "UINT",
        "hidden" : 0
    },
    {
        "len" : 0,
        "steps" : 1,
        "ppos" : 0,
        "page" : "interfaces",
        "max" : 2,
        "choices" : [
            "off",
            "yaw drift comp.",
            "v1"
        ],
        "size" : 1,
        "adr" : 137,
        "pos" : [
            3,
            1
        ],
        "min" : 0,
        "name" : "STorM32Link Configuration",
        "default" : 0,
        "foc" : 0,
        "unit" : "",
        "hidden" : 0,
        "type" : "LIST"
    },
    {
        "len" : 5,
        "steps" : 1,
        "ppos" : 2,
        "page" : "interfaces",
        "max" : 200,
        "size" : 2,
        "adr" : 34,
        "min" : 0,
        "name" : "STorM32Link AHRS Factor",
        "default" : 100,
        "foc" : 0,
        "unit" : "",
        "type" : "UINT",
        "hidden" : 0
    }
]
