import QtQuick 2.9
import QtQuick.Controls 1.5
import QtQuick.Controls 2.2 as Cntrl2
import QtQuick.Controls.Styles 1.4
import QtQuick.Dialogs 1.2



Dialog {
//------------------------
// Interface        

//------------------------

    id: _dialog
    
    title: 'Edit Uart Baudrate'
    
    contentItem: Rectangle {
    
        id: _rect
        color: 'white'
        implicitWidth: _text2.width + 2*s.winScale(20)
        implicitHeight: _text.height + _combobox.height + _text2.height + _ok.height + 5*s.winScale(20)
        
        MyText {
            id: _text
            x: s.winScale(20)
            y: s.winScale(20)
            text: qsTr('Please select the new baudrate for the UART port:','uartbaudrateeditdialog')
        }
        
        MyComboBox2 {
            id: _combobox
            anchors.top: _text.bottom
            anchors.topMargin: s.winScale(20)
            anchors.horizontalCenter: parent.horizontalCenter
            width: s.winScale(100)
            borderWidth: 1
            //focusPolicy: Qt.WheelFocus //has not the desired effect
            model: ["9600", "19200", "38400", "57600", "115200"]
        }
        
        MyText {
            id: _text2
            anchors.top: _combobox.bottom
            anchors.topMargin: s.winScale(20)
            x: s.winScale(20)
            text: qsTr('NOTE: On >OK< the new baudrate name will be stoed immediately\n' +
                  'into the EEPROM! It will become effective however only at the\nnext power up or reset of the controller.','uartbaudrateeditdialog')
        }
        
        Row{        
            anchors.top: _text2.bottom
            anchors.topMargin: s.winScale(20)
            anchors.bottom: parent.bottom
            anchors.bottomMargin: s.winScale(20)
            anchors.horizontalCenter: parent.horizontalCenter
            spacing: s.winScale(20)
            
            MyButton {
                id: _ok
                width: s.winScale(100)
                text: qsTr('OK','uartbaudrateeditdialog')
                onClicked: {
                    //0: 9600, 1: 19200, 2: 38400, 3: 57600, 4: 115200
                    btChangeUartBaudrateToolQmlClicked(_combobox.currentIndex)
                    _dialog.visible = false
                }
            }
            MyButton {
                width: s.winScale(100)
                text: qsTr('Cancel','uartbaudrateeditdialog')
                onClicked: {
                    _dialog.visible = false
                }
            }
        }        
    }
    
    function prepareBeforeShow() {
        var i = pyQml.getUartBaudrate()
        _combobox.currentIndex = (i < _combobox.count) ? i : 4
    }
    
    function prepareAfterShow() {
        _ok.focus = true
    }
}    

