import QtQuick 2.9


QtObject {

    function uint8ListToHexstr(L) {
        var s = ''
        for(var i=0; i<L.length; i++)
            s += ('0' + L[i].toString(16).toUpperCase()).slice(-2)
        return s
    }
    

    function findOptionNameTypeByAdr(adr) {
        for(var i=0; i<navBar.paramItems.length; i++) {
            if( navBar.paramItems[i].adr == adr ) {
                var name = navBar.paramItems[i].name.replace(/\s*\(.*\)$/,'')
                return { name: name, type: navBar.paramItems[i].type }
            }    
        }
        return null
    }

    function findOptionAdrTypeByName(name) {
        for(var i=0; i<navBar.paramItems.length; i++) {
            var pname = navBar.paramItems[i].name.toUpperCase().replace(/\s*\(.*\)$/,'')
            if( (pname == name.toUpperCase()) && (navBar.paramItems[i].adr >= 0) ) {
                return { adr: navBar.paramItems[i].adr, type: navBar.paramItems[i].type }
            }    
        }
        return null
    }
    
    
    readonly property var cSCRIPT_CMDS: [ 
        'STOP', 'RESTART',
        'REPEAT', 'CASE#DEFAULT', 'CASE#1', 'CASE#2', 'CASE#3', 'JUMP',
        'RESTOREALL', 'WAIT', 'SET', 'SETMINMAX', 'RESTORE',
        'SETANGLEPITCH', 'SETANGLEROLL', 'SETANGLEYAW', 'SETANGLE',
	    'SETPITCH', 'SETROLL', 'SETYAW', 'SETPITCHROLLYAW',
	    'SETSTANDBY', 'DOCAMERA', 'DORECENTER', 'SETPWM',
	    'SETPANOWAITS', 'SETPANORANGE', 'DOPANO',
        'SETANGLEPITCH_W', 'SETANGLEROLL_W', 'SETANGLEYAW_W',
        'REMOTEENABLE', 'REMOTEDISABLE',
        '' 
    ]
    
    // this we may want to speed up, but setting an array at first call
    function opOfToken(token) {
        for(var i=0; i<cSCRIPT_CMDS.length; i++) {
            if( cSCRIPT_CMDS[i] == token ) return i
        }
        return -1
    }


    function convertScriptToTextForSingleScript(scriptNr,showPc) {
        var script = navBar.paramValues.slice(navBar.cCMD_g_PARAMETER_ZAHL)
        
        function int16At(pc, type) {
            var v = script[pc] + 256 * script[pc+1]
            if( type == 'INT' ){ if( v > 32768-1 ) v -= 65536 }
            return v
        }        

        function int8At(pc, type) {
            var v = script[pc]
            if( type == 'INT' ){ if( v > 128-1 ) v -= 256 }
            return v
        }        
        
        var pc0 = script[scriptNr-1]  //get base pc of script
        var scriptText = ''
        var pc = 0
        var indent = ''

        if( pc0 >= navBar.cSCRIPTSIZE ) {  //0xFF, script is not active
            if( showPc ) scriptText += ' 0: ' + 'STOPFF'
            return scriptText
        }

        for( pc = pc0; pc < navBar.cSCRIPTSIZE; pc += 1 ){
            if( showPc ) {
                if( pc-pc0 < 10 ) scriptText += ' ' + (pc-pc0).toString() + ': '
                else              scriptText += (pc-pc0).toString() + ': '
            }
            var op = script[pc]
            var s = (op == 0xFF) ? 'STOPFF' : cSCRIPT_CMDS[op]
            if( op == 0xFF ) {
                if( showPc ) scriptText += 'STOPFF'
                break
            }else if( s == 'STOP' ){
                scriptText += indent + s
            }else if( s == 'RESTART' ){
                scriptText += indent + s

            }else if( s == 'REPEAT' ){
                scriptText += indent + s
                if( showPc ) scriptText += '  (' + script[pc+1].toString() + ')'
                pc += 1
            }else if( (s == 'CASE#DEFAULT') || (s == 'CASE#1') || (s == 'CASE#2') || (s == 'CASE#3') ){
                scriptText += s
                if( showPc ) scriptText += '  (' + script[pc+1].toString() + ')'
                indent = '    '
                pc += 1
                
            }else if( s == 'RESTOREALL' ){
                scriptText += indent + s
            }else if( s == 'WAIT' ){ // uint8
                scriptText += indent + s
                var time = script[pc+1]
                scriptText += ' ' + time.toString()
                pc += 1
            }else if( s == 'SET' ){ // uint8 int16
                scriptText += indent + s
                var o = findOptionNameTypeByAdr(script[pc+1])
                scriptText += ' "' + o.name + '"'
                var v = int16At(pc+2, o.type)
                scriptText += ' ' + v.toString()
                pc += 1+2
            }else if( s == 'SETMINMAX' ){ // uint8 int16 int16
                scriptText += indent + s
                var o = findOptionNameTypeByAdr(script[pc+1])
                scriptText += ' "' + o.name + '"'
                scriptText += ' ' +  int16At(pc+2,'').toString()
                scriptText += ' ' +  int16At(pc+4,'').toString()
                pc += 1+2+2
            }else if( s == 'RESTORE' ){ // uint8
                scriptText += indent + s
                var o = findOptionNameTypeByAdr(script[pc+1])
                scriptText += ' "' + o.name + '"'
                pc += 1

            }else if( (s == 'SETANGLEPITCH') || (s == 'SETANGLEROLL') || (s == 'SETANGLEYAW') ){ // int16
                scriptText += indent + s
                var v = int16At(pc+1,'INT')
                scriptText += ' ' + (v*0.01).toString()
                pc += 2
            }else if( s == 'SETANGLE' ){// int16 int16 int16
                scriptText += indent + s
                var v = int16At(pc+1,'INT')
                scriptText += ' ' + (v*0.01).toString()
                v =  int16At(pc+3,'INT')
                scriptText += ' ' + (v*0.01).toString()
                v =  int16At(pc+5,'INT')
                scriptText += ' ' + (v*0.01).toString()
                pc+= 2+2+2

            }else if( (s == 'SETPITCH') || (s == 'SETROLL') || (s == 'SETYAW') ){ // uint16
                scriptText += indent + s
                var v = int16At(pc+1,'')
                scriptText += ' ' + v.toString()
                pc += 2
            }else if( s == 'SETPITCHROLLYAW' ){ // uint16 uint16 uint16
                scriptText += indent + s
                var v = int16At(pc+1,'')
                scriptText += ' ' + v.toString()
                v =  int16At(pc+3,'')
                scriptText += ' ' + v.toString()
                v =  int16At(pc+5,'')
                scriptText += ' ' + v.toString()
                pc+= 2+2+2

            }else if( s == 'SETSTANDBY' ){ // uint8
                scriptText += indent + s
                var v = script[pc+1]
                scriptText += ' ' + v.toString()
                pc += 1
            }else if( s == 'DOCAMERA' ){ // uint8
                scriptText += indent + s
                var v = script[pc+1]
                scriptText += ' ' + v.toString()
                pc += 1
            }else if( s == 'DORECENTER' ){ // no param
                scriptText += indent + s
            }else if( s == 'SETPWM' ){ // uint16
                scriptText += indent + s
                var v = int16At(pc+1,'')
                scriptText += ' ' + v.toString()
                pc+= 2

            }else if( s == 'SETPANOWAITS' ){ ////uint8 uint8 uint8
                scriptText += indent + s
                var v = script[pc+1]
                scriptText += ' ' + v.toString()
                v = script[pc+2]
                scriptText += ' ' + v.toString()
                v = script[pc+3]
                scriptText += ' ' + v.toString()
                pc += 1+1+1
            }else if( s == 'SETPANORANGE' ){ //int16
                scriptText += indent + s
                var v = int16At(pc+1,'INT')
                scriptText += ' ' + v.toString()
                pc += 2
            }else if( s == 'DOPANO' ){ // int8 int8
                scriptText += indent + s
                var v = int8At(pc+1,'INT')
                scriptText += ' ' + v.toString()
                v = int8At(pc+2,'INT')
                scriptText += ' ' + v.toString()
                pc += 1+1

            }else if( (s == 'SETANGLEPITCH_W') || (s == 'SETANGLEROLL_W') || (s == 'SETANGLEYAW_W') ){ // int16 uint8
                scriptText += indent + s
                var v = int16At(pc+1,'INT')
                scriptText += ' ' + (v*0.01).toString()
                v = script[pc+3]
                scriptText += ' ' + v.toString()
                pc += 2+1

            }else if( s == 'REMOTEENABLE' ){ // no param
                scriptText += indent + s
            }else if( s == 'REMOTEDISABLE' ){ // no param
                scriptText += indent + s
            }

            scriptText += '\n'
        }
        return scriptText
    }

    
    
    function compileScriptText(scriptText) {
        
        function getNextCommand(codeText) {
            // code =~ s/^\s*([A-Z0-9#_]+?)\s(.*)/$2/
            var res = codeText.match( /^\s*([A-Z0-9#_]+?)\s(.*)/ )
            return res
        }
        
        function getParameterAdrType(codeText) {
            // code =~ s/^\s*"([A-Z0-9# ]+?)"\s(.*)/$2/; #finds parameter name string, and removes it
            var res = codeText.match( /^\s*"([A-Z0-9# ]+?)"\s(.*)/ )
            if( !res ) return null
            var o = findOptionAdrTypeByName( res[1] ) //o.adr = adr, o.type = type
            if( !o ) return null
            res[1] = o.adr
            res[3] = o.type
            return res
        }
        
        function pushAdrAndGetType(codeText) {
            var res = getParameterAdrType(codeText)
            if( res == null ){ errorMsg = 'Valid parameter name expected!'; return null; }
            var adr = res[1]
            //var type = res[3]
            //codeText = res[2]
            scriptList.push(adr); pc += 1;
            return res
        }

        //this returns the value as string, so that we can do tests
        function getIntegerValue(codeText) {
            // code =~ s/^\s*([-|+]?[0-9]+)\s(.*)/$2/; #also allow negativ values!!!
            var res = codeText.match( /^\s*([-|+]?[0-9]+)\s(.*)/ )
            return res
        }
        
        function pushUInt8(codeText) {
            var res = getIntegerValue(codeText)
            if( !res ){ errorMsg = 'Valid parameter value expected!'; return null; }
            var value = parseInt(res[1],10)
            //codeText = res[2]
            if( (value < 0) || (value > 255) ){ errorMsg = 'Value out of range!'; return null; }
            scriptList.push(value); pc += 1;  //low byte
            return res
        }            

        function pushUInt8WithLimit(codeText,max) {
            var res = getIntegerValue(codeText)
            if( !res ){ errorMsg = 'Valid parameter value expected!'; return null; }
            var value = parseInt(res[1],10)
            //codeText = res[2]
            if( (value < 0) || (value > max) ){ errorMsg = 'Value out of range!'; return null; }
            scriptList.push(value); pc += 1;  //low byte
            return res
        }
        
        function pushUInt8Bool(codeText) {
            var res = getIntegerValue(codeText)
            if( !res ){ errorMsg = 'Valid parameter value expected!'; return null; }
            var value = parseInt(res[1],10)
            //codeText = res[2]
            if( value > 0 ) value = 1; else value = 0
            scriptList.push(value); pc += 1;  //low byte
            return res
        }
        
        function pushInt8(codeText) {
            var res = getIntegerValue(codeText)
            if( !res ){ errorMsg = 'Valid parameter value expected!'; return null; }
            var value = parseInt(res[1],10)
            //codeText = res[2]
            if( (value < -128) || (value > 127) ){ errorMsg = 'Value out of range!'; return null; }
            if( value < 0 ) value += 256
            scriptList.push(value); pc += 1;  //low byte
            return res
        }            
        
        function pushInt16WithType(codeText,type) {
            var res = getIntegerValue(codeText)
            if( !res ){ errorMsg = 'Valid parameter value expected!'; return null; }
            var value = parseInt(res[1],10)
            //codeText = res[2]
            if( value < 0 ){
                if( type != 'INT' ){ errorMsg = 'Non-negative parameter value expected!'; return null; }
                value += 65536
            }
            scriptList.push(parseInt(value%256)); scriptList.push(parseInt(value/256)); pc += 2;  //low byte, highbyte
            return res
        }

        function pushInt16WithRange(codeText,min,max) {
            var res = getIntegerValue(codeText)
            if( !res ){ errorMsg = 'Valid parameter value expected!'; return null; }
            var value = parseInt(res[1],10)
            //codeText = res[2]
            if( value < 0 ) value += 65536
            if( (value < min) || (value > max) ){ errorMsg = 'Value out of range!'; return null; }
            scriptList.push(parseInt(value%256)); scriptList.push(parseInt(value/256)); pc += 2;  //low byte, highbyte
            return res
        }

        //this returns the value as string, so that we can do tests
        function getFloatValue(codeText) {
            // code =~ s/^\s*([-|+]?[0-9\.]+)\s(.*)/$2/; #also allow negativ values!!!
            var res = codeText.match( /^\s*([-|+]?[0-9\.]+)\s(.*)/ )
            return res
         }
        
        function pushFloatWithScaleAndRange(codeText,fscale,fmin,fmax) {
            var res = getFloatValue(codeText) 
            if( !res ){ errorMsg = 'Valid angle value expected!'; return null; }
            var fvalue = parseFloat(res[1])
            if( (fvalue < fmin) || (fvalue > fmax) ){ errorMsg = 'Value out of range!'; return null; }
            var value = parseInt(fscale*fvalue)
            if( value < 0 ) value += 65536
            scriptList.push(parseInt(value%256)); scriptList.push(parseInt(value/256)); pc += 2;  //low byte, highbyte
            return res
        }
        
        
        var codeText = scriptText.toUpperCase() + ' '  // add a white char to simplify regex
        codeText = codeText.replace( /\n/g, ' ' ) //this is required since . doesn't include \n, and the getNextCommand match won't work

        var token = ''
        var type = ''
        var scriptList = []
        var state = 'cmd'
        var pc = 0
        var errorMsg = ''
        var lastCasePc = 0
        var lastCmd = ''
        var casePcList = [-1,-1,-1,-1]

        var endit = false
        while(!endit) {
            if( codeText.match(/^\s*$/gi) ) { endit = true; break; }  // done
            
            var res  = getNextCommand(codeText)
            if( !res ){ errorMsg = 'Valid command expected!'; endit = true; break; }
            token = res[1]
            codeText = res[2]
            if( token == '' ){ errorMsg = 'Valid command expected!'; endit = true; break; }
            
            switch( token ) {
            case 'STOPFF':
                endit = true //get out of loop
                break

            case 'STOP':
                lastCmd = token
                scriptList.push(opOfToken(token)); pc += 1;
                break
                
            case 'RESTART':
                lastCmd = token
                scriptList.push(opOfToken(token)); pc += 1;
                break

            case 'REPEAT':
                lastCmd = token
                scriptList.push(opOfToken(token)); pc += 1;
                if( state == 'case' ) {  //we are in a case statement
                    scriptList.push(lastCasePc); pc += 1;
                } else {
                    scriptList.push(opOfToken('STOP')); pc += 1;  //go to start pc
                }
                break
                
                
            case 'CASE#DEFAULT':
            case 'CASE#1':
            case 'CASE#2':
            case 'CASE#3':
                var casei = opOfToken(token) - opOfToken('CASE#DEFAULT')  //index of case
                if( casePcList[casei] != -1 ){ errorMsg = token+' used twice!'; endit = true; break;}  //was used already before
                casePcList[casei] = 1
                if( (lastCmd != '') && (lastCmd != 'STOP') && (lastCmd != 'RESTART') && (lastCmd != 'REPEAT') ){
                    scriptList.push(opOfToken('STOP')); pc += 1;  //go to start pc
                }
                if( state == 'case' ) {  //we had been in a case statement before
                    scriptList[lastCasePc+1] = pc
                }
                lastCasePc = pc
                state = 'case'
                lastCmd = token
                scriptList.push(opOfToken(token)); pc += 1;
                scriptList.push(-10); pc += 1; //this is the place for the jump adr, which is later inserted
                break

                
            case 'RESTOREALL':
                lastCmd = token
                scriptList.push(opOfToken(token)); pc += 1;
                break

            case 'WAIT':  //uint8
                lastCmd = token
                scriptList.push(opOfToken(token)); pc += 1;
                // value
                res = pushUInt8(codeText)
                if( !res ){ endit = true; break; }
                codeText = res[2]
                break
                
            case 'SET':  // uint8 int16
                lastCmd = token
                scriptList.push(opOfToken(token)); pc += 1;
                // parameter adr & type
                res = pushAdrAndGetType(codeText)
                if( res == null ){ endit = true; break; }
                codeText = res[2]
                var type = res[3]
                // value
                res = pushInt16WithType(codeText,type)
                if( !res ){ endit = true; break; }
                codeText = res[2]
                break

            case 'SETMINMAX': // uint8 int16 int16
                lastCmd = token
                scriptList.push(opOfToken(token)); pc += 1;
                // parameter adr & type
                res = pushAdrAndGetType(codeText)
                if( res == null ){ endit = true; break; }
                codeText = res[2]
                var type = res[3]
                // min value
                res = pushInt16WithType(codeText,type)
                if( !res ){ endit = true; break; }
                codeText = res[2]
                // max value
                res = pushInt16WithType(codeText,type)
                if( !res ){ endit = true; break; }
                codeText = res[2]
                break
                
            case 'RESTORE': // uint8
                lastCmd = token
                scriptList.push(opOfToken(token)); pc += 1;
                // parameter adr
                res = pushAdrAndGetType(codeText)
                if( res == null ){ endit = true; break; }
                codeText = res[2]
                break

                
            case 'SETANGLEPITCH':
            case 'SETANGLEROLL':
            case 'SETANGLEYAW':
                lastCmd = token
                scriptList.push(opOfToken(token)); pc += 1;
                // angle     
                res = pushFloatWithScaleAndRange(codeText,100.0,-325.0,+325.0)
                if( !res ){ endit = true; break; }
                codeText = res[2]
                break

            case 'SETANGLE':
                lastCmd = token
                scriptList.push(opOfToken(token)); pc += 1;
                // 3 x angle     
                res = pushFloatWithScaleAndRange(codeText,100.0,-325.0,+325.0)
                if( !res ){ endit = true; break; }
                codeText = res[2]
                res = pushFloatWithScaleAndRange(codeText,100.0,-325.0,+325.0)
                if( !res ){ endit = true; break; }
                codeText = res[2]
                res = pushFloatWithScaleAndRange(codeText,100.0,-325.0,+325.0)
                if( !res ){ endit = true; break; }
                codeText = res[2]
                break
                
            case 'SETANGLEPITCH_W':
            case 'SETANGLEROLL_W':
            case 'SETANGLEYAW_W':
                lastCmd = token
                scriptList.push(opOfToken(token)); pc += 1;
                // angle     
                res = pushFloatWithScaleAndRange(codeText,100.0,-325.0,+325.0)
                if( !res ){ endit = true; break; }
                codeText = res[2]
                // wait time
                res = pushUInt8(codeText)
                if( !res ){ endit = true; break; }
                codeText = res[2]
                break
                
                
            case 'SETSTANDBY':
                lastCmd = token
                scriptList.push(opOfToken(token)); pc += 1;
                res = pushUInt8Bool(codeText)
                res = pushUInt8WithLimit(codeText,4)
                if( !res ){ endit = true; break; }
                codeText = res[2]
                break

            case 'DOCAMERA':
                lastCmd = token
                scriptList.push(opOfToken(token)); pc += 1;
                res = pushUInt8WithLimit(codeText,4)
                if( !res ){ endit = true; break; }
                codeText = res[2]
                break

            case 'DORECENTER':
                lastCmd = token
                scriptList.push(opOfToken(token)); pc += 1;
                break

            case 'SETPWM':
                lastCmd = token
                scriptList.push(opOfToken(token)); pc += 1;
                res = pushInt16WithRange(codeText,700,2300)
                if( !res ){ endit = true; break; }
                codeText = res[2]
                break
                
            case 'SETPANOWAITS':  //uint8 pitchtime (in 100ms) uint8 yawtime (in 100ms) uint8 shottime (in 100ms)
                lastCmd = token
                scriptList.push(opOfToken(token)); pc += 1;
                // 3 x value
                res = pushUInt8(codeText)
                if( !res ){ endit = true; break; }
                codeText = res[2]
                res = pushUInt8(codeText)
                if( !res ){ endit = true; break; }
                codeText = res[2]
                res = pushUInt8(codeText)
                if( !res ){ endit = true; break; }
                codeText = res[2]
                break

            case 'SETPANORANGE':  //uint16 yawrange (in degrees)
                lastCmd = token
                scriptList.push(opOfToken(token)); pc += 1;
                // yawrange
                res = pushInt16WithRange(codeText,0,720)
                if( !res ){ endit = true; break; }
                codeText = res[2]
                break

            case 'DOPANO':  //int8 pitch (in degrees)  int8 yawsteps
                lastCmd = token
                scriptList.push(opOfToken(token)); pc += 1;
                // pitch
                res = pushInt8(codeText)
                if( !res ){ endit = true; break; }
                codeText = res[2]
                // yaw steps
                res = pushInt8(codeText)
                if( !res ){ endit = true; break; }
                codeText = res[2]
                break

            case 'REMOTEENABLE':
                lastCmd = token
                scriptList.push(opOfToken(token)); pc += 1;
                break
            case 'REMOTEDISABLE':
                lastCmd = token
                scriptList.push(opOfToken(token)); pc += 1;
                break
                
            default:
                errorMsg = 'Valid command expected!'
                endit = true; break;

            } //end of switch()
        } //end of while()
        
        if( state == 'case' ) { //we had been in a case statement before, needs to be finished
            if( (lastCmd != '') && (lastCmd != 'STOP') && (lastCmd != 'RESTART') && (lastCmd != 'REPEAT') ) {
                scriptList.push(opOfToken('STOP')); pc += 1;  //go to start pc
            }
            scriptList[lastCasePc+1] = pc
        }
        
        scriptList.push(0xFF)
        
        //check consistency of states
        // every case must occur only once, if any occurs it must start with CASE#1, and no holes must occur
        if( errorMsg == '' ) {
            if( casePcList[3] > 0 ){
                if( (casePcList[0] < 0) || (casePcList[1] < 0) || (casePcList[2] < 0) ){ errorMsg = 'CASE#3 used without other cases!' }
            }else if( casePcList[2] > 0 ){
                if( (casePcList[0] < 0) || (casePcList[1] < 0) ){ errorMsg = 'CASE#2 used without CASE#DEFAULT and CASE#1!' }
            }else if( casePcList[1] > 0 ){
                if( casePcList[0] < 0 ){ errorMsg = 'CASE#1 used without CASE#DEFAULT!' }
            }else if( casePcList[0] > 0 ){
                errorMsg = 'CASE#DEFUALT used but no other cases'
            }
        }    

        if( errorMsg != '' ) 
            return { ok: false, script: [0xFF], errorMsg: errorMsg, errorLine: 0}
        return { ok: true, script: scriptList, errorMsg: '', errorLine: 0}
    }

    

    
    // somehow I couldn't get a list of list working, how nasty is this
    
    function mergeSingleScriptIntoScript(scriptNr,singleScript) {
    
        var curScript = navBar.paramValues.slice(navBar.cCMD_g_PARAMETER_ZAHL)
        var scriptList1 = []
        var scriptList2 = []
        var scriptList3 = []
        var scriptList4 = []
    
        // split curScript and insert new script
        // we start from the back and slice of a script
        for(var nr = 4; nr >= 1; nr -= 1) {
            var pc0 = curScript[nr-1] //get base pc of script
            var s = []
            if( pc0 >= navBar.cSCRIPTSIZE ) {  //0xFF, there is no script
            } else {
                s = curScript.slice(pc0)
                curScript = curScript.slice(0,pc0)
            }
            while( (s.length > 0) && (s[s.length-1] == 0xFF) ) s.pop()  //$s =~ s/FF+$/FF/; #cut down to one FF at the end
            s.push(0xFF)  //ensure 'FF' at end
            if( nr == 4 ) scriptList4 = s
            if( nr == 3 ) scriptList3 = s
            if( nr == 2 ) scriptList2 = s
            if( nr == 1 ) scriptList1 = s
        }
        
        // insert new hexcode
        while( (singleScript.length > 0) && (singleScript[singleScript.length-1] == 0xFF) ) singleScript.pop()  //$s =~ s/FF+$/FF/; #cut down to one FF at the end
        singleScript.push(0xFF)  //ensure 'FF' at end
        if( scriptNr == 4 ) scriptList4 = singleScript
        if( scriptNr == 3 ) scriptList3 = singleScript
        if( scriptNr == 2 ) scriptList2 = singleScript
        if( scriptNr == 1 ) scriptList1 = singleScript
        
        // combine hexcodes to new script
        var newScript = [];
        var pc0 = 4
        if( scriptList1[0] == 0xFF ) { 
            newScript.push(0xFF)
            scriptList1 = []
        } else {
            newScript.push(pc0) //pc0 script1
            pc0 += scriptList1.length
        }
        if( scriptList2[0] == 0xFF ) { 
            newScript.push(0xFF)
            scriptList2 = []
        } else {
            newScript.push(pc0) //pc0 script1
            pc0 += scriptList2.length
        }
        if( scriptList3[0] == 0xFF ) { 
            newScript.push(0xFF)
            scriptList3 = []
        } else {
            newScript.push(pc0) //pc0 script1
            pc0 += scriptList3.length
        }
        if( scriptList4[0] == 0xFF ) { 
            newScript.push(0xFF)
            scriptList4 = []
        } else {
            newScript.push(pc0) //pc0 script1
            pc0 += scriptList4.length
        }
        for(var i = 0; i < scriptList1.length; i += 1) newScript.push(scriptList1[i])
        for(var i = 0; i < scriptList2.length; i += 1) newScript.push(scriptList2[i])
        for(var i = 0; i < scriptList3.length; i += 1) newScript.push(scriptList3[i])
        for(var i = 0; i < scriptList4.length; i += 1) newScript.push(scriptList4[i])
       
/*
        TextOut( substr($script_hex,0,2 * 4 )."\r\n" );
        for(my $script_nr=1; $script_nr<=4; $script_nr++){
            my $s = $script_hexcodes[$script_nr];
            if( length($s)<1 ){ $s.='-'; }
            TextOut( $s."\r\n" );
        }
        my $codelength= length($script_hex)/2;
        TextOut( "$codelength of $SCRIPTSIZE bytes used"."\r\n" );
*/        
        // set 
        return { scripts: newScript, script1: scriptList1, script2: scriptList2, script3: scriptList3, script4: scriptList4 }
    }
    
}