import QtQuick 2.9
import QtQuick.Controls 1.5
import QtQuick.Controls.Styles 1.4


MyParamItem {
//------------------------
// Interface        

//------------------------
    
    height: s.h
    
    MyComboBox2 {
        id: _combobox2
        x: s.x1
        width: s.width1

        rectangleColor: cModifiedState
        
        model: ListModel {}
        
        onCurrentIndexChanged: {
            intValue = _combobox2.currentIndex
            updateParamValues()
            setModified(s.cMODIFIED)
        }
    }
    
    onIntValueChanged: { _combobox2.currentIndex = intValue }
    
    Connections {
        target: wMain
        onSignalParametersChanged: {
            var adr = paramItem.adr
            if( adr >= 0 ) {
                intValue = newParameters[adr]
                updateParamValues()
                setValid()
//console.log(adr,intValue)
            }
        }
    }
    Connections {
        target: wMain
        onSignalParamValueByNameChanged: {
            //if( paramItem.name == paramName ) {
            // the issue is that some 'name' entries have extensions such as (0 = off)
            if( paramItem.name.toUpperCase().indexOf(paramName.toUpperCase()) >= 0 ) {
//console.log(paramName,newParamValue)
                intValue = newParamValue
                updateParamValues()
                setModified(s.cMODIFIED)
            }
        }
    }
    
    
    Component.onCompleted: {
        var choices = paramItem.choices
        for(var i=0; i<choices.length; i++) {
            _combobox2.model.append({text: choices[i]})
        }
        _combobox2.currentIndex = paramItem.default
        setInvalid()
    }
    
    function updateParamValues() {
        var adr = paramItem.adr
        if( adr >= 0 ) navBar.paramValues[adr] = intValue
    }
}