import QtQuick 2.9
import QtQuick.Controls 1.5
import QtQuick.Controls.Styles 1.4


MyParamItem {

    id: _paramitemint

    height: s.h
    
    property bool signed: false
    
    MyTextField {
        id: _textfield
        x: s.x1
        width: s.width1
        rectangleColor: cModifiedState
        
        onAccepted: {
//console.log('edit', text)
            // extract the likely value
            var fvalue = parseFloat(text)
            if( !fvalue ){ //this is not a valid str, so retry with removing the first chars
                console.log('NAN')
            }
            if( paramItem.ppos != 0 ) {
                for(var p=0; p<paramItem.ppos; p++) fvalue *= 10.0
            }
            var ivalue = parseInt(fvalue+0.5)
            // limit to range and steps
            ivalue = _limit(ivalue)
            intValue = ivalue
            updateParamValues()
        }
        
        Connections {
            target: _paramitemint
            onIntValueChanged: {
//console.log(paramItem.name, 'textfield value changed', intValue )
                _setTextField(intValue)
                setModified(s.cMODIFIED)
            }
        }
    }
    
    MySlider {
        id: _slider
        x: s.x2
        width: s.width2

        minimumValue: paramItem.min
        maximumValue: paramItem.max
        stepSize: paramItem.steps
        
        onValueChanged: {
//console.log('slider value changed', value )
            // slider value is already ranged, so _limit() need not be called
            intValue = parseInt(value)
            updateParamValues()
        }
        
        Connections {
            target: _paramitemint
            onIntValueChanged: {
//console.log(paramItem.name, 'slider value changed', intValue )
                // slider value is already ranged, so _limit() need not be called
                _setSlider(intValue)
            }
        }
    }    
    
    Connections {
        target: wMain
        onSignalParametersChanged: {
            var adr = paramItem.adr
            if( adr >= 0 ) {
                setIntValue(newParameters[adr])
                updateParamValues()
                setValid()
//console.log(adr,intValue)
            }
        }
    }
    Connections {
        target: wMain
        onSignalParamValueByNameChanged: {
            //if( paramItem.name == paramName ) {
            // the issue is that some 'name' entries have extensions such as (0 = off)
            if( paramItem.name.toUpperCase().indexOf(paramName.toUpperCase()) >= 0 ) {
console.log(paramName,newParamValue)
                setIntValue(newParamValue)
                updateParamValues()
                setModified(s.cMODIFIED)
            }
        }
    }
    
    
    Component.onCompleted: {
        if( paramItem.type == 'INT' ) signed = true
        setIntValue(paramItem.default)
        updateParamValues()
        setInvalid() //needs to be called again since setValue() may have changed it
    }
    
    //functions for external access
    // value is an integer, in the correct range
    // the functions return or take an unsigned value, as appropriate for STorM32 commands 
    // this is needed since we do not have uint16 or int16 types
    
    function getValue() {
        var retValue = intValue
        if( signed ){
            if( retValue < 0 ) { retValue += 65536 }
        }
        return retValue
    }
    
    function setIntValue(newValue) {
        if( signed ){
            if( newValue > 32566 ) { newValue -= 65536 }
        }
        newValue = _limit(newValue)
        intValue = newValue
    }
    
    function updateParamValues() {
        var adr = paramItem.adr
        if( adr >= 0 ) navBar.paramValues[adr] = getValue()
    }
    
    
    //internal functions, do not use from external
    
    function _limit(newValue) {
        // respect range
        if( newValue > paramItem.max ){ return paramItem.max }
        if( newValue < paramItem.min ){ return paramItem.min }
        // respect steps
        // that's not really needed, we can allow anything
        /*
        if( paramItem.steps > 1 ){
            newValue = parseInt( (newValue + 0.5*paramItem.steps)/paramItem.steps )
            newValue *= paramItem.steps
        }
        */
        // ok, ensure it's an integer
        return parseInt(newValue)
    }
    
    function _setTextField(newValue) {
        var fvalue = newValue
        var svalue = fvalue.toString();
        if( paramItem.ppos != 0 ) {
            for(var p=0; p<paramItem.ppos; p++) fvalue *= 0.1
            svalue = fvalue.toFixed(paramItem.ppos);
        }
        if( paramItem.unit != '' ){ svalue += ' ' + paramItem.unit }
        _textfield.text = svalue
    }
    
    function _setSlider(newValue) {
        _slider.value = newValue
    }
}