import QtQuick 2.9
import QtQuick.Controls 1.5
import QtQuick.Controls.Styles 1.4


//basic class for a ParamItem object

//responds to signals
// signalFocChanged(bool newFoc)


Item {
//------------------------
// Interface        
    
    //functions for external access
    
    function setValid() { cModifiedState = s.cVALID }
    function setInvalid() { cModifiedState = s.cINVALID }
    function setModified(newModifiedState) {
        if( cModifiedState == newModifiedState ) return
        if( cModifiedState == s.cINVALID ) return
        cModifiedState = newModifiedState
    }

    property alias label: _name.text
    
//------------------------

    property int paramIndex: -1 //gives the position in paramItems[] list, is NOT the adr

    //property to store the value for int-type parameters
    // one MUST call updateParamValues() whenever it is set! 
    // initialize with something abnormal, so that a onChange is triggered at startup   property string strValue: 'X'
    // slider has a value property, so call it intValue
    
    property int intValue: 1000000  //initialize with something abnormal, so that a onChange is triggered at startup
    
    //property to store the string for string-type parameters
    // initialize with something abnormal, so that a onChange is triggered at startup   
    
    property string strValue: 'X'
    
    property color cModifiedState: s.cINVALID
    
    property var paramItem: null //ATTENTION: do not confuse with paramItems !!!
    
    MyLabel {
        id: _name
        font.bold: true
        text: (parent.paramItem == null) ? '' : parent.paramItem.name
    }
    
    Connections {
        target: wMain
        onSignalFocChanged: {
            if( paramItem == null ) return //this is to handle MayScriptTextArea
            var focEnabled = newFoc
            var focMode = paramItem.foc  //0: show in both cases, 1: show in non-foc, 2: show in foc, 3: disable in foc
//console.log('signal received', paramItem.name, focEnabled, focMode)
            var vis = true
            if( focMode == 3 ) {
                vis = (focEnabled) ? true : false
            } else
            if( focMode == 2 ) {
                vis = (focEnabled) ? true : false
            } else
            if( focMode == 1 ) {
                vis = (focEnabled) ? false : true
            }
            if( paramItem.hidden ) vis = false
            //if( visible ){ height = h } else { height = 1 }
            //BUG???? this does not ensure that visible is equal to vis ??? 
            // but the object is indeed visible or not, depending on how it was set here!!
            visible = vis 
            height = vis ? s.h : 0
//console.log(vis, visible, height)
        }
    }
    Connections {  //this should also go into each parameterItem !!
        target: wMain
        onSignalConnectedChanged: {
            if( paramItem == null ) return
            if( !newConnected ) {
                if( paramItem.type == 'STR+READONLY' ) {
                    strValue = paramItem.default
                } else
                if( paramItem.type == 'SCRIPT' ) {
                    //dataValue = ''
                    intValue = paramItem.default //recall: every entry with adr>=0 must be int type
                } else {
                    intValue = paramItem.default
                }
                setInvalid()
            }
        }
    }
/* handle in respective param item
        onSignalVersionChanged: {}
        onSignalParametersChanged: {}
        onSignalParamValueByNameChanged: {}
*/    


}