
import QtQuick 2.9
import QtQuick.Controls 1.5
import QtQuick.Controls.Styles 1.4
import QtQml.Models 2.2

// py auto-generated navigation pane and parameter objects 
// the navBar also holds the lists of the parameter objects
// LayoutVersion: L234

Column {
    //id: navBar
       
    property string currentNavIndexStr: 'Dashboard'
    
    //list of nav pages in the nav bar    
    readonly property var navBarItems: [
        { nav: 'Dashboard', icon: s.iconNavbarDashboard },
        { nav: 'PID', icon: s.iconNavbarPID },
        { nav: 'Pan', icon: s.iconNavbarPan },
        { nav: 'Rc Inputs', icon: s.iconNavbarRcInputs },
        { nav: 'Functions', icon: s.iconNavbarFunctions },
        { nav: 'Scripts', icon: s.iconNavbarScripts },
        { nav: 'Setup', icon: s.iconNavbarSetup },
        { nav: 'Gimbal Configuration', icon: s.iconNavbarGimbalConfiguration },
        { nav: 'Calibrations', icon: s.iconNavbarCalibrations },
        { nav: 'Interfaces', icon: s.iconNavbarInterfaces },
        { nav: 'Expert', icon: s.iconNavbarExpert },
        { nav: 'Tools', icon: s.iconNavbarTools },
        { nav: 'Firmware Update', icon: s.iconNavbarFirmwareUpdate },
    ]

    //int constants for indexing the nav pages 
    readonly property int iDashboard: 0
    readonly property int iPID: 1
    readonly property int iPan: 2
    readonly property int iRcInputs: 3
    readonly property int iFunctions: 4
    readonly property int iScripts: 5
    readonly property int iSetup: 6
    readonly property int iGimbalConfiguration: 7
    readonly property int iCalibrations: 8
    readonly property int iInterfaces: 9
    readonly property int iExpert: 10
    readonly property int iTools: 11
    readonly property int iFirmwareUpdate: 12

    //create the MyNavButton objects in the nav bar    
    Repeater {
        model: parent.navBarItems
        MyNavButton {
            text: modelData.nav
            iconSource: modelData.icon
            navIndexStr: modelData.nav //index
        }
    }

    //list of all parameters, and associated meta data 
    readonly property var paramItems: [
        { name: 'Firmware Version', nav: 'Dashboard', type: 'STR+READONLY', size: 16, foc: 0, hidden: 0, adr: -1, default: '' },
        { name: 'Board', nav: 'Dashboard', type: 'STR+READONLY', size: 16, foc: 0, hidden: 0, adr: -1, default: '' },
        { name: 'Name', nav: 'Dashboard', type: 'STR+READONLY', size: 16, foc: 0, hidden: 0, adr: -1, default: '' },
        { name: 'Gyro LPF', nav: 'PID', type: 'LIST', size: 1, foc: 1, hidden: 0, adr: 12, default: 1, min: 0, max: 6, choices: ['off','1.5 ms','3.0 ms','4.5 ms','6.0 ms','7.5 ms','9 ms'] },
        { name: 'Foc Gyro LPF', nav: 'PID', type: 'LIST', size: 1, foc: 2, hidden: 0, adr: 41, default: 1, min: 0, max: 6, choices: ['off','1.5 ms','3.0 ms','4.5 ms','6.0 ms','7.5 ms','9 ms'] },
        { name: 'Imu2 FeedForward LPF', nav: 'PID', type: 'LIST', size: 1, foc: 3, hidden: 0, adr: 72, default: 1, min: 0, max: 6, choices: ['off','1.5 ms','4 ms','10 ms','22 ms','46 ms','94 ms'] },
        { name: 'Voltage Correction', nav: 'PID', type: 'UINT', size: 2, foc: 3, hidden: 0, adr: 75, default: 0, steps: 1, len: 7, ppos: 0, min: 0, max: 200, unit: '%' },
        { name: 'Roll Yaw PD Mixing', nav: 'PID', type: 'UINT', size: 2, foc: 0, hidden: 0, adr: 73, default: 0, steps: 1, len: 5, ppos: 0, min: 0, max: 100, unit: '%' },
        { name: 'Pitch P', nav: 'PID', type: 'UINT', size: 2, foc: 1, hidden: 0, adr: 0, default: 400, steps: 10, len: 5, ppos: 2, min: 0, max: 3000, unit: '' },
        { name: 'Pitch I', nav: 'PID', type: 'UINT', size: 2, foc: 1, hidden: 0, adr: 1, default: 1000, steps: 50, len: 7, ppos: 1, min: 0, max: 32000, unit: '' },
        { name: 'Pitch D', nav: 'PID', type: 'UINT', size: 2, foc: 1, hidden: 0, adr: 2, default: 500, steps: 50, len: 3, ppos: 4, min: 0, max: 8000, unit: '' },
        { name: 'Pitch Motor Vmax', nav: 'PID', type: 'UINT', size: 2, foc: 1, hidden: 0, adr: 3, default: 150, steps: 1, len: 5, ppos: 0, min: 0, max: 255, unit: '' },
        { name: 'Roll P', nav: 'PID', type: 'UINT', size: 2, foc: 1, hidden: 0, adr: 4, default: 400, steps: 10, len: 5, ppos: 2, min: 0, max: 3000, unit: '' },
        { name: 'Roll I', nav: 'PID', type: 'UINT', size: 2, foc: 1, hidden: 0, adr: 5, default: 1000, steps: 50, len: 7, ppos: 1, min: 0, max: 32000, unit: '' },
        { name: 'Roll D', nav: 'PID', type: 'UINT', size: 2, foc: 1, hidden: 0, adr: 6, default: 500, steps: 50, len: 3, ppos: 4, min: 0, max: 8000, unit: '' },
        { name: 'Roll Motor Vmax', nav: 'PID', type: 'UINT', size: 2, foc: 1, hidden: 0, adr: 7, default: 150, steps: 1, len: 5, ppos: 0, min: 0, max: 255, unit: '' },
        { name: 'Yaw P', nav: 'PID', type: 'UINT', size: 2, foc: 1, hidden: 0, adr: 8, default: 400, steps: 10, len: 5, ppos: 2, min: 0, max: 3000, unit: '' },
        { name: 'Yaw I', nav: 'PID', type: 'UINT', size: 2, foc: 1, hidden: 0, adr: 9, default: 1000, steps: 50, len: 7, ppos: 1, min: 0, max: 32000, unit: '' },
        { name: 'Yaw D', nav: 'PID', type: 'UINT', size: 2, foc: 1, hidden: 0, adr: 10, default: 500, steps: 50, len: 3, ppos: 4, min: 0, max: 8000, unit: '' },
        { name: 'Yaw Motor Vmax', nav: 'PID', type: 'UINT', size: 2, foc: 1, hidden: 0, adr: 11, default: 150, steps: 1, len: 5, ppos: 0, min: 0, max: 255, unit: '' },
        { name: 'Foc Pitch P', nav: 'PID', type: 'UINT', size: 2, foc: 2, hidden: 0, adr: 23, default: 400, steps: 10, len: 5, ppos: 2, min: 0, max: 3000, unit: '' },
        { name: 'Foc Pitch I', nav: 'PID', type: 'UINT', size: 2, foc: 2, hidden: 0, adr: 24, default: 100, steps: 50, len: 7, ppos: 1, min: 0, max: 32000, unit: '' },
        { name: 'Foc Pitch D', nav: 'PID', type: 'UINT', size: 2, foc: 2, hidden: 0, adr: 25, default: 2000, steps: 50, len: 3, ppos: 4, min: 0, max: 8000, unit: '' },
        { name: 'Foc Pitch K', nav: 'PID', type: 'UINT', size: 2, foc: 2, hidden: 0, adr: 26, default: 10, steps: 1, len: 5, ppos: 1, min: 1, max: 100, unit: '' },
        { name: 'Foc Roll P', nav: 'PID', type: 'UINT', size: 2, foc: 2, hidden: 0, adr: 29, default: 400, steps: 10, len: 5, ppos: 2, min: 0, max: 3000, unit: '' },
        { name: 'Foc Roll I', nav: 'PID', type: 'UINT', size: 2, foc: 2, hidden: 0, adr: 30, default: 100, steps: 50, len: 7, ppos: 1, min: 0, max: 32000, unit: '' },
        { name: 'Foc Roll D', nav: 'PID', type: 'UINT', size: 2, foc: 2, hidden: 0, adr: 31, default: 2000, steps: 50, len: 3, ppos: 4, min: 0, max: 8000, unit: '' },
        { name: 'Foc Roll K', nav: 'PID', type: 'UINT', size: 2, foc: 2, hidden: 0, adr: 32, default: 10, steps: 1, len: 5, ppos: 1, min: 1, max: 100, unit: '' },
        { name: 'Foc Yaw P', nav: 'PID', type: 'UINT', size: 2, foc: 2, hidden: 0, adr: 35, default: 400, steps: 10, len: 5, ppos: 2, min: 0, max: 3000, unit: '' },
        { name: 'Foc Yaw I', nav: 'PID', type: 'UINT', size: 2, foc: 2, hidden: 0, adr: 36, default: 100, steps: 50, len: 7, ppos: 1, min: 0, max: 32000, unit: '' },
        { name: 'Foc Yaw D', nav: 'PID', type: 'UINT', size: 2, foc: 2, hidden: 0, adr: 37, default: 2000, steps: 50, len: 3, ppos: 4, min: 0, max: 8000, unit: '' },
        { name: 'Foc Yaw K', nav: 'PID', type: 'UINT', size: 2, foc: 2, hidden: 0, adr: 38, default: 10, steps: 1, len: 5, ppos: 1, min: 1, max: 100, unit: '' },
        { name: 'Pan Mode Control', nav: 'Pan', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 79, default: 0, min: 0, max: 42, choices: ['off','Rc-0','Rc-1','Rc-2','Rc2-0','Rc2-1','Rc2-2','Rc2-3','Pot-0','Pot-1','Pot-2','Virtual-1','Virtual-2','Virtual-3','Virtual-4','Virtual-5','Virtual-6','Virtual-7','Virtual-8','Virtual-9','Virtual-10','Virtual-11','Virtual-12','Virtual-13','Virtual-14','Virtual-15','Virtual-16','But switch','But latch','But step','Aux-0 switch','Aux-1 switch','Aux-2 switch','Aux-01 switch','Aux-012 switch','Aux-0 latch','Aux-1 latch','Aux-2 latch','Aux-01 latch','Aux-012 latch','Aux-0 step','Aux-1 step','Aux-2 step'] },
        { name: 'Pan Mode Default Setting', nav: 'Pan', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 80, default: 0, min: 0, max: 5, choices: ['hold hold pan','hold hold hold','pan pan pan','pan hold hold','pan hold pan','hold pan pan','off'] },
        { name: 'Pan Mode Setting #1', nav: 'Pan', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 81, default: 1, min: 0, max: 6, choices: ['hold hold pan','hold hold hold','pan pan pan','pan hold hold','pan hold pan','hold pan pan','off'] },
        { name: 'Pan Mode Setting #2', nav: 'Pan', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 82, default: 4, min: 0, max: 6, choices: ['hold hold pan','hold hold hold','pan pan pan','pan hold hold','pan hold pan','hold pan pan','off'] },
        { name: 'Pan Mode Setting #3', nav: 'Pan', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 83, default: 2, min: 0, max: 6, choices: ['hold hold pan','hold hold hold','pan pan pan','pan hold hold','pan hold pan','hold pan pan','off'] },
        { name: 'Pitch Pan (0 = hold)', nav: 'Pan', type: 'UINT', size: 2, foc: 0, hidden: 0, adr: 84, default: 20, steps: 1, len: 5, ppos: 1, min: 0, max: 50, unit: '' },
        { name: 'Pitch Pan Deadband', nav: 'Pan', type: 'UINT', size: 2, foc: 0, hidden: 0, adr: 85, default: 0, steps: 10, len: 5, ppos: 1, min: 0, max: 600, unit: '°' },
        { name: 'Pitch Pan Expo', nav: 'Pan', type: 'UINT', size: 2, foc: 0, hidden: 0, adr: 86, default: 0, steps: 1, len: 5, ppos: 0, min: 0, max: 100, unit: '%' },
        { name: 'Roll Pan (0 = hold)', nav: 'Pan', type: 'UINT', size: 2, foc: 0, hidden: 0, adr: 87, default: 20, steps: 1, len: 5, ppos: 1, min: 0, max: 50, unit: '' },
        { name: 'Roll Pan Deadband', nav: 'Pan', type: 'UINT', size: 2, foc: 0, hidden: 0, adr: 88, default: 0, steps: 10, len: 5, ppos: 1, min: 0, max: 600, unit: '°' },
        { name: 'Roll Pan Expo', nav: 'Pan', type: 'UINT', size: 2, foc: 0, hidden: 0, adr: 89, default: 0, steps: 1, len: 5, ppos: 0, min: 0, max: 100, unit: '%' },
        { name: 'Yaw Pan (0 = hold)', nav: 'Pan', type: 'UINT', size: 2, foc: 0, hidden: 0, adr: 90, default: 20, steps: 1, len: 5, ppos: 1, min: 0, max: 50, unit: '' },
        { name: 'Yaw Pan Deadband', nav: 'Pan', type: 'UINT', size: 2, foc: 0, hidden: 0, adr: 91, default: 50, steps: 5, len: 5, ppos: 1, min: 0, max: 100, unit: '°' },
        { name: 'Yaw Pan Expo', nav: 'Pan', type: 'UINT', size: 2, foc: 0, hidden: 0, adr: 92, default: 0, steps: 1, len: 5, ppos: 0, min: 0, max: 100, unit: '%' },
        { name: 'Yaw Pan Deadband LPF', nav: 'Pan', type: 'UINT', size: 2, foc: 0, hidden: 0, adr: 93, default: 150, steps: 5, len: 5, ppos: 2, min: 0, max: 400, unit: 's' },
        { name: 'Rc Dead Band', nav: 'Rc Inputs', type: 'UINT', size: 2, foc: 0, hidden: 0, adr: 96, default: 10, steps: 1, len: 0, ppos: 0, min: 0, max: 50, unit: 'us' },
        { name: 'Rc Hysteresis', nav: 'Rc Inputs', type: 'UINT', size: 2, foc: 0, hidden: 0, adr: 97, default: 5, steps: 1, len: 0, ppos: 0, min: 0, max: 50, unit: 'us' },
        { name: 'Rc Pitch Trim', nav: 'Rc Inputs', type: 'INT', size: 2, foc: 0, hidden: 0, adr: 104, default: 0, steps: 1, len: 0, ppos: 0, min: -100, max: 100, unit: 'us' },
        { name: 'Rc Roll Trim', nav: 'Rc Inputs', type: 'INT', size: 2, foc: 0, hidden: 0, adr: 111, default: 0, steps: 1, len: 0, ppos: 0, min: -100, max: 100, unit: 'us' },
        { name: 'Rc Yaw Trim', nav: 'Rc Inputs', type: 'INT', size: 2, foc: 0, hidden: 0, adr: 118, default: 0, steps: 1, len: 0, ppos: 0, min: -100, max: 100, unit: 'us' },
        { name: 'Rc Pitch', nav: 'Rc Inputs', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 102, default: 0, min: 0, max: 42, choices: ['off','Rc-0','Rc-1','Rc-2','Rc2-0','Rc2-1','Rc2-2','Rc2-3','Pot-0','Pot-1','Pot-2','Virtual-1','Virtual-2','Virtual-3','Virtual-4','Virtual-5','Virtual-6','Virtual-7','Virtual-8','Virtual-9','Virtual-10','Virtual-11','Virtual-12','Virtual-13','Virtual-14','Virtual-15','Virtual-16','But switch','But latch','But step','Aux-0 switch','Aux-1 switch','Aux-2 switch','Aux-01 switch','Aux-012 switch','Aux-0 latch','Aux-1 latch','Aux-2 latch','Aux-01 latch','Aux-012 latch','Aux-0 step','Aux-1 step','Aux-2 step'] },
        { name: 'Rc Pitch Mode', nav: 'Rc Inputs', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 103, default: 0, min: 0, max: 2, choices: ['absolute','relative','absolute centered'] },
        { name: 'Rc Pitch Min', nav: 'Rc Inputs', type: 'INT', size: 2, foc: 0, hidden: 0, adr: 105, default: -250, steps: 5, len: 0, ppos: 1, min: -1200, max: 1200, unit: '°' },
        { name: 'Rc Pitch Max', nav: 'Rc Inputs', type: 'INT', size: 2, foc: 0, hidden: 0, adr: 106, default: 250, steps: 5, len: 0, ppos: 1, min: -1200, max: 1200, unit: '°' },
        { name: 'Rc Pitch Speed Limit (0 = off)', nav: 'Rc Inputs', type: 'UINT', size: 2, foc: 0, hidden: 0, adr: 107, default: 400, steps: 5, len: 0, ppos: 1, min: 0, max: 1000, unit: '°/s' },
        { name: 'Rc Pitch Accel Limit (0 = off)', nav: 'Rc Inputs', type: 'UINT', size: 2, foc: 0, hidden: 0, adr: 108, default: 300, steps: 10, len: 0, ppos: 3, min: 0, max: 1000, unit: '' },
        { name: 'Rc Roll', nav: 'Rc Inputs', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 109, default: 0, min: 0, max: 42, choices: ['off','Rc-0','Rc-1','Rc-2','Rc2-0','Rc2-1','Rc2-2','Rc2-3','Pot-0','Pot-1','Pot-2','Virtual-1','Virtual-2','Virtual-3','Virtual-4','Virtual-5','Virtual-6','Virtual-7','Virtual-8','Virtual-9','Virtual-10','Virtual-11','Virtual-12','Virtual-13','Virtual-14','Virtual-15','Virtual-16','But switch','But latch','But step','Aux-0 switch','Aux-1 switch','Aux-2 switch','Aux-01 switch','Aux-012 switch','Aux-0 latch','Aux-1 latch','Aux-2 latch','Aux-01 latch','Aux-012 latch','Aux-0 step','Aux-1 step','Aux-2 step'] },
        { name: 'Rc Roll Mode', nav: 'Rc Inputs', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 110, default: 0, min: 0, max: 2, choices: ['absolute','relative','absolute centered'] },
        { name: 'Rc Roll Min', nav: 'Rc Inputs', type: 'INT', size: 2, foc: 0, hidden: 0, adr: 112, default: -250, steps: 5, len: 0, ppos: 1, min: -450, max: 450, unit: '°' },
        { name: 'Rc Roll Max', nav: 'Rc Inputs', type: 'INT', size: 2, foc: 0, hidden: 0, adr: 113, default: 250, steps: 5, len: 0, ppos: 1, min: -450, max: 450, unit: '°' },
        { name: 'Rc Roll Speed Limit (0 = off)', nav: 'Rc Inputs', type: 'UINT', size: 2, foc: 0, hidden: 0, adr: 114, default: 400, steps: 5, len: 0, ppos: 1, min: 0, max: 1000, unit: '°/s' },
        { name: 'Rc Roll Accel Limit (0 = off)', nav: 'Rc Inputs', type: 'UINT', size: 2, foc: 0, hidden: 0, adr: 115, default: 300, steps: 10, len: 0, ppos: 3, min: 0, max: 1000, unit: '' },
        { name: 'Rc Yaw', nav: 'Rc Inputs', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 116, default: 0, min: 0, max: 42, choices: ['off','Rc-0','Rc-1','Rc-2','Rc2-0','Rc2-1','Rc2-2','Rc2-3','Pot-0','Pot-1','Pot-2','Virtual-1','Virtual-2','Virtual-3','Virtual-4','Virtual-5','Virtual-6','Virtual-7','Virtual-8','Virtual-9','Virtual-10','Virtual-11','Virtual-12','Virtual-13','Virtual-14','Virtual-15','Virtual-16','But switch','But latch','But step','Aux-0 switch','Aux-1 switch','Aux-2 switch','Aux-01 switch','Aux-012 switch','Aux-0 latch','Aux-1 latch','Aux-2 latch','Aux-01 latch','Aux-012 latch','Aux-0 step','Aux-1 step','Aux-2 step'] },
        { name: 'Rc Yaw Mode', nav: 'Rc Inputs', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 117, default: 0, min: 0, max: 3, choices: ['absolute','relative','absolute centered','relative turn around'] },
        { name: 'Rc Yaw Min', nav: 'Rc Inputs', type: 'INT', size: 2, foc: 0, hidden: 0, adr: 119, default: -250, steps: 10, len: 0, ppos: 1, min: -2700, max: 2700, unit: '°' },
        { name: 'Rc Yaw Max', nav: 'Rc Inputs', type: 'INT', size: 2, foc: 0, hidden: 0, adr: 120, default: 250, steps: 10, len: 0, ppos: 1, min: -2700, max: 2700, unit: '°' },
        { name: 'Rc Yaw Speed Limit (0 = off)', nav: 'Rc Inputs', type: 'UINT', size: 2, foc: 0, hidden: 0, adr: 121, default: 400, steps: 5, len: 0, ppos: 1, min: 0, max: 1000, unit: '°/s' },
        { name: 'Rc Yaw Accel Limit (0 = off)', nav: 'Rc Inputs', type: 'UINT', size: 2, foc: 0, hidden: 0, adr: 122, default: 300, steps: 10, len: 0, ppos: 3, min: 0, max: 1000, unit: '' },
        { name: 'Standby', nav: 'Functions', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 123, default: 0, min: 0, max: 42, choices: ['off','Rc-0','Rc-1','Rc-2','Rc2-0','Rc2-1','Rc2-2','Rc2-3','Pot-0','Pot-1','Pot-2','Virtual-1','Virtual-2','Virtual-3','Virtual-4','Virtual-5','Virtual-6','Virtual-7','Virtual-8','Virtual-9','Virtual-10','Virtual-11','Virtual-12','Virtual-13','Virtual-14','Virtual-15','Virtual-16','But switch','But latch','But step','Aux-0 switch','Aux-1 switch','Aux-2 switch','Aux-01 switch','Aux-012 switch','Aux-0 latch','Aux-1 latch','Aux-2 latch','Aux-01 latch','Aux-012 latch','Aux-0 step','Aux-1 step','Aux-2 step'] },
        { name: 'Re-center Camera', nav: 'Functions', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 124, default: 0, min: 0, max: 42, choices: ['off','Rc-0','Rc-1','Rc-2','Rc2-0','Rc2-1','Rc2-2','Rc2-3','Pot-0','Pot-1','Pot-2','Virtual-1','Virtual-2','Virtual-3','Virtual-4','Virtual-5','Virtual-6','Virtual-7','Virtual-8','Virtual-9','Virtual-10','Virtual-11','Virtual-12','Virtual-13','Virtual-14','Virtual-15','Virtual-16','But switch','But latch','But step','Aux-0 switch','Aux-1 switch','Aux-2 switch','Aux-01 switch','Aux-012 switch','Aux-0 latch','Aux-1 latch','Aux-2 latch','Aux-01 latch','Aux-012 latch','Aux-0 step','Aux-1 step','Aux-2 step'] },
        { name: 'IR Camera Control', nav: 'Functions', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 125, default: 0, min: 0, max: 42, choices: ['off','Rc-0','Rc-1','Rc-2','Rc2-0','Rc2-1','Rc2-2','Rc2-3','Pot-0','Pot-1','Pot-2','Virtual-1','Virtual-2','Virtual-3','Virtual-4','Virtual-5','Virtual-6','Virtual-7','Virtual-8','Virtual-9','Virtual-10','Virtual-11','Virtual-12','Virtual-13','Virtual-14','Virtual-15','Virtual-16','But switch','But latch','But step','Aux-0 switch','Aux-1 switch','Aux-2 switch','Aux-01 switch','Aux-012 switch','Aux-0 latch','Aux-1 latch','Aux-2 latch','Aux-01 latch','Aux-012 latch','Aux-0 step','Aux-1 step','Aux-2 step'] },
        { name: 'Camera Model', nav: 'Functions', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 126, default: 0, min: 0, max: 5, choices: ['Sony Nex','Canon','Panasonic','Nikon','Git2 Rc','CAMremote'] },
        { name: 'IR Camera Setting #1', nav: 'Functions', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 127, default: 0, min: 0, max: 2, choices: ['shutter','shutter delay','video on/off'] },
        { name: 'IR Camera Setting #2', nav: 'Functions', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 128, default: 2, min: 0, max: 3, choices: ['shutter','shutter delay','video on/off','off'] },
        { name: 'Time Interval (0 = off)', nav: 'Functions', type: 'UINT', size: 2, foc: 0, hidden: 0, adr: 129, default: 0, steps: 1, len: 0, ppos: 1, min: 0, max: 150, unit: 's' },
        { name: 'Pwm Out Control', nav: 'Functions', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 130, default: 0, min: 0, max: 42, choices: ['off','Rc-0','Rc-1','Rc-2','Rc2-0','Rc2-1','Rc2-2','Rc2-3','Pot-0','Pot-1','Pot-2','Virtual-1','Virtual-2','Virtual-3','Virtual-4','Virtual-5','Virtual-6','Virtual-7','Virtual-8','Virtual-9','Virtual-10','Virtual-11','Virtual-12','Virtual-13','Virtual-14','Virtual-15','Virtual-16','But switch','But latch','But step','Aux-0 switch','Aux-1 switch','Aux-2 switch','Aux-01 switch','Aux-012 switch','Aux-0 latch','Aux-1 latch','Aux-2 latch','Aux-01 latch','Aux-012 latch','Aux-0 step','Aux-1 step','Aux-2 step'] },
        { name: 'Pwm Out Mid', nav: 'Functions', type: 'UINT', size: 2, foc: 0, hidden: 0, adr: 131, default: 1500, steps: 1, len: 0, ppos: 0, min: 900, max: 2100, unit: 'us' },
        { name: 'Pwm Out Min', nav: 'Functions', type: 'UINT', size: 2, foc: 0, hidden: 0, adr: 132, default: 1100, steps: 10, len: 0, ppos: 0, min: 900, max: 2100, unit: 'us' },
        { name: 'Pwm Out Max', nav: 'Functions', type: 'UINT', size: 2, foc: 0, hidden: 0, adr: 133, default: 1900, steps: 10, len: 0, ppos: 0, min: 900, max: 2100, unit: 'us' },
        { name: 'Pwm Out Speed Limit (0 = off)', nav: 'Functions', type: 'UINT', size: 2, foc: 0, hidden: 0, adr: 134, default: 0, steps: 5, len: 0, ppos: 0, min: 0, max: 1000, unit: 'us/s' },
        { name: 'Script1 Control', nav: 'Scripts', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 150, default: 0, min: 0, max: 42, choices: ['off','Rc-0','Rc-1','Rc-2','Rc2-0','Rc2-1','Rc2-2','Rc2-3','Pot-0','Pot-1','Pot-2','Virtual-1','Virtual-2','Virtual-3','Virtual-4','Virtual-5','Virtual-6','Virtual-7','Virtual-8','Virtual-9','Virtual-10','Virtual-11','Virtual-12','Virtual-13','Virtual-14','Virtual-15','Virtual-16','But switch','But latch','But step','Aux-0 switch','Aux-1 switch','Aux-2 switch','Aux-01 switch','Aux-012 switch','Aux-0 latch','Aux-1 latch','Aux-2 latch','Aux-01 latch','Aux-012 latch','Aux-0 step','Aux-1 step','Aux-2 step'] },
        { name: 'Script2 Control', nav: 'Scripts', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 151, default: 0, min: 0, max: 42, choices: ['off','Rc-0','Rc-1','Rc-2','Rc2-0','Rc2-1','Rc2-2','Rc2-3','Pot-0','Pot-1','Pot-2','Virtual-1','Virtual-2','Virtual-3','Virtual-4','Virtual-5','Virtual-6','Virtual-7','Virtual-8','Virtual-9','Virtual-10','Virtual-11','Virtual-12','Virtual-13','Virtual-14','Virtual-15','Virtual-16','But switch','But latch','But step','Aux-0 switch','Aux-1 switch','Aux-2 switch','Aux-01 switch','Aux-012 switch','Aux-0 latch','Aux-1 latch','Aux-2 latch','Aux-01 latch','Aux-012 latch','Aux-0 step','Aux-1 step','Aux-2 step'] },
        { name: 'Script3 Control', nav: 'Scripts', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 152, default: 0, min: 0, max: 42, choices: ['off','Rc-0','Rc-1','Rc-2','Rc2-0','Rc2-1','Rc2-2','Rc2-3','Pot-0','Pot-1','Pot-2','Virtual-1','Virtual-2','Virtual-3','Virtual-4','Virtual-5','Virtual-6','Virtual-7','Virtual-8','Virtual-9','Virtual-10','Virtual-11','Virtual-12','Virtual-13','Virtual-14','Virtual-15','Virtual-16','But switch','But latch','But step','Aux-0 switch','Aux-1 switch','Aux-2 switch','Aux-01 switch','Aux-012 switch','Aux-0 latch','Aux-1 latch','Aux-2 latch','Aux-01 latch','Aux-012 latch','Aux-0 step','Aux-1 step','Aux-2 step'] },
        { name: 'Script4 Control', nav: 'Scripts', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 153, default: 0, min: 0, max: 42, choices: ['off','Rc-0','Rc-1','Rc-2','Rc2-0','Rc2-1','Rc2-2','Rc2-3','Pot-0','Pot-1','Pot-2','Virtual-1','Virtual-2','Virtual-3','Virtual-4','Virtual-5','Virtual-6','Virtual-7','Virtual-8','Virtual-9','Virtual-10','Virtual-11','Virtual-12','Virtual-13','Virtual-14','Virtual-15','Virtual-16','But switch','But latch','But step','Aux-0 switch','Aux-1 switch','Aux-2 switch','Aux-01 switch','Aux-012 switch','Aux-0 latch','Aux-1 latch','Aux-2 latch','Aux-01 latch','Aux-012 latch','Aux-0 step','Aux-1 step','Aux-2 step'] },
        { name: 'Scripts', nav: 'Scripts', type: 'SCRIPT', size: 128, foc: 0, hidden: 1, adr: 154, default: 0, steps: 0, len: 0, ppos: 0, min: 0, max: 0 },
        { name: 'Imu2 Configuration', nav: 'Setup', type: 'LIST', size: 1, foc: 3, hidden: 0, adr: 53, default: 0, min: 0, max: 2, choices: ['off','full','full xy'] },
        { name: 'Startup Mode', nav: 'Setup', type: 'LIST', size: 1, foc: 3, hidden: 0, adr: 140, default: 0, min: 0, max: 1, choices: ['normal','fast'] },
        { name: 'Startup Delay', nav: 'Setup', type: 'UINT', size: 2, foc: 0, hidden: 0, adr: 141, default: 0, steps: 5, len: 0, ppos: 1, min: 0, max: 250, unit: 's' },
        { name: 'Imu AHRS', nav: 'Setup', type: 'UINT', size: 2, foc: 0, hidden: 0, adr: 61, default: 1000, steps: 100, len: 5, ppos: 2, min: 0, max: 2500, unit: 's' },
        { name: 'Virtual Channel Configuration', nav: 'Setup', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 77, default: 0, min: 0, max: 11, choices: ['off','sum ppm 6','sum ppm 7','sum ppm 8','sum ppm 10','sum ppm 12','spektrum 10 bit','spektrum 11 bit','sbus','hott sumd','srxl','serial'] },
        { name: 'Pwm Out Configuration', nav: 'Setup', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 78, default: 0, min: 0, max: 2, choices: ['off','1520 us 55 Hz','1520 us 250 Hz'] },
        { name: 'Rc Pitch Offset', nav: 'Setup', type: 'INT', size: 2, foc: 0, hidden: 0, adr: 99, default: 0, steps: 5, len: 0, ppos: 1, min: -1200, max: 1200, unit: '°' },
        { name: 'Rc Roll Offset', nav: 'Setup', type: 'INT', size: 2, foc: 0, hidden: 0, adr: 100, default: 0, steps: 5, len: 0, ppos: 1, min: -1200, max: 1200, unit: '°' },
        { name: 'Rc Yaw Offset', nav: 'Setup', type: 'INT', size: 2, foc: 0, hidden: 0, adr: 101, default: 0, steps: 5, len: 0, ppos: 1, min: -1200, max: 1200, unit: '°' },
        { name: 'Esp Configuration', nav: 'Setup', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 147, default: 0, min: 0, max: 2, choices: ['off','uart','uart2'] },
        { name: 'Uart1 Tx Configuration', nav: 'Setup', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 48, default: 0, min: 0, max: 1, choices: ['off','oled display'] },
        { name: 'Low Voltage Limit', nav: 'Setup', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 74, default: 1, min: 0, max: 11, choices: ['off','2.5 V/cell','2.6 V/cell','2.7 V/cell','2.8 V/cell','2.9 V/cell','3.0 V/cell','3.1 V/cell','3.2 V/cell','3.3 V/cell','3.4 V/cell','3.5 V/cell'] },
        { name: 'Beep with Motors', nav: 'Setup', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 143, default: 0, min: 0, max: 2, choices: ['off','basic','all'] },
        { name: 'NT Logging', nav: 'Setup', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 142, default: 0, min: 0, max: 7, choices: ['off','basic','basic + pid','basic + accgyro','basic + accgyro_raw','basic + pid + accgyro','basic + pid + ag_raw','full'] },
        { name: 'Pitch Motor Usage', nav: 'Setup', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 55, default: 3, min: 0, max: 3, choices: ['normal','level','startup pos','disabled'] },
        { name: 'Roll Motor Usage', nav: 'Setup', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 56, default: 3, min: 0, max: 3, choices: ['normal','level','startup pos','disabled'] },
        { name: 'Yaw Motor Usage', nav: 'Setup', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 57, default: 3, min: 0, max: 3, choices: ['normal','level','startup pos','disabled'] },
        { name: 'Imu Orientation', nav: 'Gimbal Configuration', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 51, default: 0, min: 0, max: 23, choices: ['no.0:  z0°   x  y  z','no.1:  z90°  -y  x  z','no.2:  z180°  -x -y  z','no.3:  z270°   y -x  z','no.4:  x0°   y  z  x','no.5:  x90°  -z  y  x','no.6:  x180°  -y -z  x','no.7:  x270°   z -y  x','no.8:  y0°   z  x  y','no.9:  y90°  -x  z  y','no.10:  y180°  -z -x  y','no.11:  y270°   x -z  y','no.12:  -z0°   y  x -z','no.13:  -z90°  -x  y -z','no.14:  -z180°  -y -x -z','no.15:  -z270°   x -y -z','no.16:  -x0°   z  y -x','no.17:  -x90°  -y  z -x','no.18:  -x180°  -z -y -x','no.19:  -x270°   y -z -x','no.20:  -y0°   x  z -y','no.21:  -y90°  -z  x -y','no.22:  -y180°  -x -z -y','no.23:  -y270°   z -x -y'] },
        { name: 'Imu2 Orientation', nav: 'Gimbal Configuration', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 54, default: 0, min: 0, max: 23, choices: ['no.0:  z0°   x  y  z','no.1:  z90°  -y  x  z','no.2:  z180°  -x -y  z','no.3:  z270°   y -x  z','no.4:  x0°   y  z  x','no.5:  x90°  -z  y  x','no.6:  x180°  -y -z  x','no.7:  x270°   z -y  x','no.8:  y0°   z  x  y','no.9:  y90°  -x  z  y','no.10:  y180°  -z -x  y','no.11:  y270°   x -z  y','no.12:  -z0°   y  x -z','no.13:  -z90°  -x  y -z','no.14:  -z180°  -y -x -z','no.15:  -z270°   x -y -z','no.16:  -x0°   z  y -x','no.17:  -x90°  -y  z -x','no.18:  -x180°  -z -y -x','no.19:  -x270°   y -z -x','no.20:  -y0°   x  z -y','no.21:  -y90°  -z  x -y','no.22:  -y180°  -x -z -y','no.23:  -y270°   z -x -y'] },
        { name: 'Pitch Motor Poles', nav: 'Gimbal Configuration', type: 'UINT', size: 2, foc: 1, hidden: 0, adr: 13, default: 14, steps: 2, len: 0, ppos: 0, min: 8, max: 28, unit: '' },
        { name: 'Pitch Motor Direction', nav: 'Gimbal Configuration', type: 'LIST', size: 1, foc: 1, hidden: 0, adr: 14, default: 2, min: 0, max: 2, choices: ['normal','reversed','auto'] },
        { name: 'Pitch Startup Motor Pos', nav: 'Gimbal Configuration', type: 'UINT', size: 2, foc: 1, hidden: 0, adr: 15, default: 504, steps: 1, len: 5, ppos: 0, min: 0, max: 1008, unit: '' },
        { name: 'Foc Pitch Motor Direction', nav: 'Gimbal Configuration', type: 'LIST', size: 1, foc: 2, hidden: 0, adr: 42, default: 0, min: 0, max: 1, choices: ['normal','reversed','auto'] },
        { name: 'Foc Pitch Zero Pos', nav: 'Gimbal Configuration', type: 'INT', size: 2, foc: 2, hidden: 0, adr: 43, default: 0, steps: 8, len: 5, ppos: 0, min: -16384, max: 16383, unit: '' },
        { name: 'Pitch Offset', nav: 'Gimbal Configuration', type: 'INT', size: 2, foc: 0, hidden: 0, adr: 58, default: 0, steps: 5, len: 5, ppos: 2, min: -300, max: 300, unit: '°' },
        { name: 'Roll Motor Poles', nav: 'Gimbal Configuration', type: 'UINT', size: 2, foc: 1, hidden: 0, adr: 16, default: 14, steps: 2, len: 0, ppos: 0, min: 8, max: 28, unit: '' },
        { name: 'Roll Motor Direction', nav: 'Gimbal Configuration', type: 'LIST', size: 1, foc: 1, hidden: 0, adr: 17, default: 2, min: 0, max: 2, choices: ['normal','reversed','auto'] },
        { name: 'Roll Startup Motor Pos', nav: 'Gimbal Configuration', type: 'UINT', size: 2, foc: 1, hidden: 0, adr: 18, default: 504, steps: 1, len: 5, ppos: 0, min: 0, max: 1008, unit: '' },
        { name: 'Foc Roll Motor Direction', nav: 'Gimbal Configuration', type: 'LIST', size: 1, foc: 2, hidden: 0, adr: 44, default: 0, min: 0, max: 1, choices: ['normal','reversed','auto'] },
        { name: 'Foc Roll Zero Pos', nav: 'Gimbal Configuration', type: 'INT', size: 2, foc: 2, hidden: 0, adr: 45, default: 0, steps: 8, len: 5, ppos: 0, min: -16384, max: 16383, unit: '' },
        { name: 'Roll Offset', nav: 'Gimbal Configuration', type: 'INT', size: 2, foc: 0, hidden: 0, adr: 59, default: 0, steps: 5, len: 5, ppos: 2, min: -300, max: 300, unit: '°' },
        { name: 'Yaw Motor Poles', nav: 'Gimbal Configuration', type: 'UINT', size: 2, foc: 1, hidden: 0, adr: 19, default: 14, steps: 2, len: 0, ppos: 0, min: 8, max: 28, unit: '' },
        { name: 'Yaw Motor Direction', nav: 'Gimbal Configuration', type: 'LIST', size: 1, foc: 1, hidden: 0, adr: 20, default: 2, min: 0, max: 2, choices: ['normal','reversed','auto'] },
        { name: 'Yaw Startup Motor Pos', nav: 'Gimbal Configuration', type: 'UINT', size: 2, foc: 1, hidden: 0, adr: 21, default: 504, steps: 1, len: 5, ppos: 0, min: 0, max: 1008, unit: '' },
        { name: 'Foc Yaw Motor Direction', nav: 'Gimbal Configuration', type: 'LIST', size: 1, foc: 2, hidden: 0, adr: 46, default: 0, min: 0, max: 1, choices: ['normal','reversed','auto'] },
        { name: 'Foc Yaw Zero Pos', nav: 'Gimbal Configuration', type: 'INT', size: 2, foc: 2, hidden: 0, adr: 47, default: 0, steps: 8, len: 5, ppos: 0, min: -16384, max: 16383, unit: '' },
        { name: 'Yaw Offset', nav: 'Gimbal Configuration', type: 'INT', size: 2, foc: 0, hidden: 0, adr: 60, default: 0, steps: 5, len: 5, ppos: 2, min: -300, max: 300, unit: '°' },
        { name: 'Motor Mapping', nav: 'Expert', type: 'LIST', size: 1, foc: 3, hidden: 0, adr: 22, default: 0, min: 0, max: 5, choices: ['M0=pitch , M1=roll','M0=roll , M1=pitch','roll yaw pitch','yaw roll pitch','pitch yaw roll','yaw pitch roll'] },
        { name: 'Imu Mapping', nav: 'Expert', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 52, default: 0, min: 0, max: 1, choices: ['1 = id1 , 2 = id2','1 = id2 , 2 = id1'] },
        { name: 'Lipo Cells', nav: 'Expert', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 49, default: 0, min: 0, max: 6, choices: ['auto','1 S','2 S','3 S','4 S','5 S','6 S'] },
        { name: 'Lipo Voltage per Cell', nav: 'Expert', type: 'UINT', size: 2, foc: 0, hidden: 0, adr: 50, default: 420, steps: 5, len: 0, ppos: 2, min: 300, max: 500, unit: 'V' },
        { name: 'ADC Calibration', nav: 'Expert', type: 'UINT', size: 2, foc: 0, hidden: 0, adr: 76, default: 1550, steps: 10, len: 0, ppos: 0, min: 1000, max: 2000, unit: '' },
        { name: 'Imu3 Configuration', nav: 'Expert', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 135, default: 0, min: 0, max: 5, choices: ['off','default','2 = id2, 3 = onboard','2 = onboard, 3 = id2','2 = onboard, 3 = id3','2 = onboard, 3 = off'] },
        { name: 'Imu3 Orientation', nav: 'Expert', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 136, default: 0, min: 0, max: 23, choices: ['no.0:  z0°   x  y  z','no.1:  z90°  -y  x  z','no.2:  z180°  -x -y  z','no.3:  z270°   y -x  z','no.4:  x0°   y  z  x','no.5:  x90°  -z  y  x','no.6:  x180°  -y -z  x','no.7:  x270°   z -y  x','no.8:  y0°   z  x  y','no.9:  y90°  -x  z  y','no.10:  y180°  -z -x  y','no.11:  y270°   x -z  y','no.12:  -z0°   y  x -z','no.13:  -z90°  -x  y -z','no.14:  -z180°  -y -x -z','no.15:  -z270°   x -y -z','no.16:  -x0°   z  y -x','no.17:  -x90°  -y  z -x','no.18:  -x180°  -z -y -x','no.19:  -x270°   y -z -x','no.20:  -y0°   x  z -y','no.21:  -y90°  -z  x -y','no.22:  -y180°  -x -z -y','no.23:  -y270°   z -x -y'] },
        { name: 'Acc LPF', nav: 'Expert', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 71, default: 2, min: 0, max: 6, choices: ['off','1.5 ms','4.5 ms','12 ms','25 ms','50 ms','100 ms'] },
        { name: 'Rc Adc LPF', nav: 'Expert', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 98, default: 0, min: 0, max: 6, choices: ['off','1.5 ms','4.5 ms','12 ms','25 ms','50 ms','100 ms'] },
        { name: 'Hold To Pan Transition Time', nav: 'Expert', type: 'UINT', size: 2, foc: 0, hidden: 0, adr: 95, default: 250, steps: 25, len: 5, ppos: 0, min: 0, max: 1000, unit: 'ms' },
        { name: 'Acc Compensation Method', nav: 'Expert', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 65, default: 1, min: 0, max: 1, choices: ['standard','advanced'] },
        { name: 'Uart Baudrate', nav: 'Expert', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 68, default: 0, min: 0, max: 7, choices: ['default','9600','19200','38400','57600','115200','230400','460800'] },
        { name: 'Uart2 Baudrate', nav: 'Expert', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 69, default: 0, min: 0, max: 7, choices: ['default','9600','19200','38400','57600','115200','230400','460800'] },
        { name: 'Usb Baudrate', nav: 'Expert', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 70, default: 0, min: 0, max: 7, choices: ['default','9600','19200','38400','57600','115200','230400','460800'] },
        { name: 'Mavlink Configuration', nav: 'Interfaces', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 144, default: 0, min: 0, max: 3, choices: ['no heartbeat','emit heartbeat','heartbeat + attitude','h.b. + mountstatus'] },
        { name: 'Mavlink ComPort', nav: 'Interfaces', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 66, default: 0, min: 0, max: 2, choices: ['uart','usb','uart2'] },
        { name: 'Mavlink System ID', nav: 'Interfaces', type: 'UINT', size: 2, foc: 0, hidden: 0, adr: 145, default: 71, steps: 1, len: 0, ppos: 0, min: 0, max: 255, unit: '' },
        { name: 'Mavlink Component ID', nav: 'Interfaces', type: 'UINT', size: 2, foc: 0, hidden: 0, adr: 146, default: 67, steps: 1, len: 0, ppos: 0, min: 0, max: 255, unit: '' },
        { name: 'AP Compatibility', nav: 'Interfaces', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 67, default: 0, min: 0, max: 1, choices: ['off','apshit+v0.96'] },
        { name: 'Can Configuration', nav: 'Interfaces', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 148, default: 0, min: 0, max: 2, choices: ['off','uavcan','dji naza'] },
        { name: 'Uavcan Node ID', nav: 'Interfaces', type: 'UINT', size: 2, foc: 0, hidden: 0, adr: 149, default: 71, steps: 1, len: 0, ppos: 0, min: 11, max: 124, unit: '' },
        { name: 'STorM32Link Configuration', nav: 'Interfaces', type: 'LIST', size: 1, foc: 0, hidden: 0, adr: 137, default: 0, min: 0, max: 1, choices: ['off','basic'] },
        { name: 'STorM32Link Wait Time', nav: 'Interfaces', type: 'UINT', size: 2, foc: 0, hidden: 0, adr: 138, default: 50, steps: 5, len: 0, ppos: 1, min: 0, max: 250, unit: 's' },
        { name: 'STorM32Link Pitch Offset', nav: 'Interfaces', type: 'INT', size: 2, foc: 0, hidden: 0, adr: 39, default: 0, steps: 1, len: 5, ppos: 2, min: -500, max: 500, unit: '°' },
        { name: 'STorM32Link Roll Offset', nav: 'Interfaces', type: 'INT', size: 2, foc: 0, hidden: 0, adr: 40, default: 0, steps: 1, len: 5, ppos: 2, min: -500, max: 500, unit: '°' },
    ]
        
    // every entry in paramItems MUST have an adr (adr<0 indicates that it's not in read/write)
    // but not every adr must have an entry in paramItems
    // every entry with adr>=0 must be int type, inclusive SCRIPT 
    
    // in contrast to paramItems, this list is arranged by adr
    // it mirrors the 'g' and 'p' simple serial commands, exclusive SCRIPT
    // fill it with enough vaues, so that we have a contiguous array
    // it could be longer, but ideally it would have the correct size

    readonly property int cCMD_g_PARAMETER_ZAHL: 155
    readonly property int cSCRIPTSIZE: 128

    property var paramValues: [
        0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 
        0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 
        0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 
        0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 
        0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 
        0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 
        0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 
        0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 
        //scripts
        0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 
        0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 
        0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 
        0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 
        0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 
        0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 
        0,0,0,0,0, 0,0,0,
    ]
    
    //list of MyParamItem objects, arranged by their nav page    
    property list<ObjectModel> paramList: [
        ObjectModel {
            MyParamItemStrReadOnly{ paramIndex: 0; paramItem: paramItems[0] }
            MyParamItemStrReadOnly{ paramIndex: 1; paramItem: paramItems[1] }
            MyParamItemStrReadOnly{ paramIndex: 2; paramItem: paramItems[2] }
        },
        ObjectModel {
            MyParamItemList{ paramIndex: 3; paramItem: paramItems[3] }
            MyParamItemList{ paramIndex: 4; paramItem: paramItems[4] }
            MyParamItemList{ paramIndex: 5; paramItem: paramItems[5] }
            MyParamItemInt{ paramIndex: 6; paramItem: paramItems[6] }
            MyParamItemInt{ paramIndex: 7; paramItem: paramItems[7] }
            MyParamItemInt{ paramIndex: 8; paramItem: paramItems[8] }
            MyParamItemInt{ paramIndex: 9; paramItem: paramItems[9] }
            MyParamItemInt{ paramIndex: 10; paramItem: paramItems[10] }
            MyParamItemInt{ paramIndex: 11; paramItem: paramItems[11] }
            MyParamItemInt{ paramIndex: 12; paramItem: paramItems[12] }
            MyParamItemInt{ paramIndex: 13; paramItem: paramItems[13] }
            MyParamItemInt{ paramIndex: 14; paramItem: paramItems[14] }
            MyParamItemInt{ paramIndex: 15; paramItem: paramItems[15] }
            MyParamItemInt{ paramIndex: 16; paramItem: paramItems[16] }
            MyParamItemInt{ paramIndex: 17; paramItem: paramItems[17] }
            MyParamItemInt{ paramIndex: 18; paramItem: paramItems[18] }
            MyParamItemInt{ paramIndex: 19; paramItem: paramItems[19] }
            MyParamItemInt{ paramIndex: 20; paramItem: paramItems[20] }
            MyParamItemInt{ paramIndex: 21; paramItem: paramItems[21] }
            MyParamItemInt{ paramIndex: 22; paramItem: paramItems[22] }
            MyParamItemInt{ paramIndex: 23; paramItem: paramItems[23] }
            MyParamItemInt{ paramIndex: 24; paramItem: paramItems[24] }
            MyParamItemInt{ paramIndex: 25; paramItem: paramItems[25] }
            MyParamItemInt{ paramIndex: 26; paramItem: paramItems[26] }
            MyParamItemInt{ paramIndex: 27; paramItem: paramItems[27] }
            MyParamItemInt{ paramIndex: 28; paramItem: paramItems[28] }
            MyParamItemInt{ paramIndex: 29; paramItem: paramItems[29] }
            MyParamItemInt{ paramIndex: 30; paramItem: paramItems[30] }
            MyParamItemInt{ paramIndex: 31; paramItem: paramItems[31] }
        },
        ObjectModel {
            MyParamItemList{ paramIndex: 32; paramItem: paramItems[32] }
            MyParamItemList{ paramIndex: 33; paramItem: paramItems[33] }
            MyParamItemList{ paramIndex: 34; paramItem: paramItems[34] }
            MyParamItemList{ paramIndex: 35; paramItem: paramItems[35] }
            MyParamItemList{ paramIndex: 36; paramItem: paramItems[36] }
            MyParamItemInt{ paramIndex: 37; paramItem: paramItems[37] }
            MyParamItemInt{ paramIndex: 38; paramItem: paramItems[38] }
            MyParamItemInt{ paramIndex: 39; paramItem: paramItems[39] }
            MyParamItemInt{ paramIndex: 40; paramItem: paramItems[40] }
            MyParamItemInt{ paramIndex: 41; paramItem: paramItems[41] }
            MyParamItemInt{ paramIndex: 42; paramItem: paramItems[42] }
            MyParamItemInt{ paramIndex: 43; paramItem: paramItems[43] }
            MyParamItemInt{ paramIndex: 44; paramItem: paramItems[44] }
            MyParamItemInt{ paramIndex: 45; paramItem: paramItems[45] }
            MyParamItemInt{ paramIndex: 46; paramItem: paramItems[46] }
        },
        ObjectModel {
            MyParamItemInt{ paramIndex: 47; paramItem: paramItems[47] }
            MyParamItemInt{ paramIndex: 48; paramItem: paramItems[48] }
            MyParamItemInt{ paramIndex: 49; paramItem: paramItems[49] }
            MyParamItemInt{ paramIndex: 50; paramItem: paramItems[50] }
            MyParamItemInt{ paramIndex: 51; paramItem: paramItems[51] }
            MyParamItemList{ paramIndex: 52; paramItem: paramItems[52] }
            MyParamItemList{ paramIndex: 53; paramItem: paramItems[53] }
            MyParamItemInt{ paramIndex: 54; paramItem: paramItems[54] }
            MyParamItemInt{ paramIndex: 55; paramItem: paramItems[55] }
            MyParamItemInt{ paramIndex: 56; paramItem: paramItems[56] }
            MyParamItemInt{ paramIndex: 57; paramItem: paramItems[57] }
            MyParamItemList{ paramIndex: 58; paramItem: paramItems[58] }
            MyParamItemList{ paramIndex: 59; paramItem: paramItems[59] }
            MyParamItemInt{ paramIndex: 60; paramItem: paramItems[60] }
            MyParamItemInt{ paramIndex: 61; paramItem: paramItems[61] }
            MyParamItemInt{ paramIndex: 62; paramItem: paramItems[62] }
            MyParamItemInt{ paramIndex: 63; paramItem: paramItems[63] }
            MyParamItemList{ paramIndex: 64; paramItem: paramItems[64] }
            MyParamItemList{ paramIndex: 65; paramItem: paramItems[65] }
            MyParamItemInt{ paramIndex: 66; paramItem: paramItems[66] }
            MyParamItemInt{ paramIndex: 67; paramItem: paramItems[67] }
            MyParamItemInt{ paramIndex: 68; paramItem: paramItems[68] }
            MyParamItemInt{ paramIndex: 69; paramItem: paramItems[69] }
        },
        ObjectModel {
            MyParamItemList{ paramIndex: 70; paramItem: paramItems[70] }
            MyParamItemList{ paramIndex: 71; paramItem: paramItems[71] }
            MyParamItemList{ paramIndex: 72; paramItem: paramItems[72] }
            MyParamItemList{ paramIndex: 73; paramItem: paramItems[73] }
            MyParamItemList{ paramIndex: 74; paramItem: paramItems[74] }
            MyParamItemList{ paramIndex: 75; paramItem: paramItems[75] }
            MyParamItemInt{ paramIndex: 76; paramItem: paramItems[76] }
            MyParamItemList{ paramIndex: 77; paramItem: paramItems[77] }
            MyParamItemInt{ paramIndex: 78; paramItem: paramItems[78] }
            MyParamItemInt{ paramIndex: 79; paramItem: paramItems[79] }
            MyParamItemInt{ paramIndex: 80; paramItem: paramItems[80] }
            MyParamItemInt{ paramIndex: 81; paramItem: paramItems[81] }
        },
        ObjectModel {
            MyParamItemList{ paramIndex: 82; paramItem: paramItems[82] }
            MyParamItemList{ paramIndex: 83; paramItem: paramItems[83] }
            MyParamItemList{ paramIndex: 84; paramItem: paramItems[84] }
            MyParamItemList{ paramIndex: 85; paramItem: paramItems[85] }
            MyParamItemScript{ paramIndex: 86; paramItem: paramItems[86] }
            MyScriptTextArea{ id: scriptTextArea1; label: 'Script1' }
            MyScriptTextArea{ id: scriptTextArea2; label: 'Script2' }
            MyScriptTextArea{ id: scriptTextArea3; label: 'Script3' }
            MyScriptTextArea{ id: scriptTextArea4; label: 'Script4' }
        },
        ObjectModel {
            MyParamItemList{ paramIndex: 87; paramItem: paramItems[87] }
            MyParamItemList{ paramIndex: 88; paramItem: paramItems[88] }
            MyParamItemInt{ paramIndex: 89; paramItem: paramItems[89] }
            MyParamItemInt{ paramIndex: 90; paramItem: paramItems[90] }
            MyParamItemList{ paramIndex: 91; paramItem: paramItems[91] }
            MyParamItemList{ paramIndex: 92; paramItem: paramItems[92] }
            MyParamItemInt{ paramIndex: 93; paramItem: paramItems[93] }
            MyParamItemInt{ paramIndex: 94; paramItem: paramItems[94] }
            MyParamItemInt{ paramIndex: 95; paramItem: paramItems[95] }
            MyParamItemList{ paramIndex: 96; paramItem: paramItems[96] }
            MyParamItemList{ paramIndex: 97; paramItem: paramItems[97] }
            MyParamItemList{ paramIndex: 98; paramItem: paramItems[98] }
            MyParamItemList{ paramIndex: 99; paramItem: paramItems[99] }
            MyParamItemList{ paramIndex: 100; paramItem: paramItems[100] }
            MyParamItemList{ paramIndex: 101; paramItem: paramItems[101] }
            MyParamItemList{ paramIndex: 102; paramItem: paramItems[102] }
            MyParamItemList{ paramIndex: 103; paramItem: paramItems[103] }
        },
        ObjectModel {
            MyParamItemList{ paramIndex: 104; paramItem: paramItems[104] }
            MyParamItemList{ paramIndex: 105; paramItem: paramItems[105] }
            MyParamItemInt{ paramIndex: 106; paramItem: paramItems[106] }
            MyParamItemList{ paramIndex: 107; paramItem: paramItems[107] }
            MyParamItemInt{ paramIndex: 108; paramItem: paramItems[108] }
            MyParamItemList{ paramIndex: 109; paramItem: paramItems[109] }
            MyParamItemInt{ paramIndex: 110; paramItem: paramItems[110] }
            MyParamItemInt{ paramIndex: 111; paramItem: paramItems[111] }
            MyParamItemInt{ paramIndex: 112; paramItem: paramItems[112] }
            MyParamItemList{ paramIndex: 113; paramItem: paramItems[113] }
            MyParamItemInt{ paramIndex: 114; paramItem: paramItems[114] }
            MyParamItemList{ paramIndex: 115; paramItem: paramItems[115] }
            MyParamItemInt{ paramIndex: 116; paramItem: paramItems[116] }
            MyParamItemInt{ paramIndex: 117; paramItem: paramItems[117] }
            MyParamItemInt{ paramIndex: 118; paramItem: paramItems[118] }
            MyParamItemList{ paramIndex: 119; paramItem: paramItems[119] }
            MyParamItemInt{ paramIndex: 120; paramItem: paramItems[120] }
            MyParamItemList{ paramIndex: 121; paramItem: paramItems[121] }
            MyParamItemInt{ paramIndex: 122; paramItem: paramItems[122] }
            MyParamItemInt{ paramIndex: 123; paramItem: paramItems[123] }
        },
        ObjectModel {
        },
        ObjectModel {
            MyParamItemList{ paramIndex: 138; paramItem: paramItems[138] }
            MyParamItemList{ paramIndex: 139; paramItem: paramItems[139] }
            MyParamItemInt{ paramIndex: 140; paramItem: paramItems[140] }
            MyParamItemInt{ paramIndex: 141; paramItem: paramItems[141] }
            MyParamItemList{ paramIndex: 142; paramItem: paramItems[142] }
            MyParamItemList{ paramIndex: 143; paramItem: paramItems[143] }
            MyParamItemInt{ paramIndex: 144; paramItem: paramItems[144] }
            MyParamItemList{ paramIndex: 145; paramItem: paramItems[145] }
            MyParamItemInt{ paramIndex: 146; paramItem: paramItems[146] }
            MyParamItemInt{ paramIndex: 147; paramItem: paramItems[147] }
            MyParamItemInt{ paramIndex: 148; paramItem: paramItems[148] }
        },
        ObjectModel {
            MyParamItemList{ paramIndex: 124; paramItem: paramItems[124] }
            MyParamItemList{ paramIndex: 125; paramItem: paramItems[125] }
            MyParamItemList{ paramIndex: 126; paramItem: paramItems[126] }
            MyParamItemInt{ paramIndex: 127; paramItem: paramItems[127] }
            MyParamItemInt{ paramIndex: 128; paramItem: paramItems[128] }
            MyParamItemList{ paramIndex: 129; paramItem: paramItems[129] }
            MyParamItemList{ paramIndex: 130; paramItem: paramItems[130] }
            MyParamItemList{ paramIndex: 131; paramItem: paramItems[131] }
            MyParamItemList{ paramIndex: 132; paramItem: paramItems[132] }
            MyParamItemInt{ paramIndex: 133; paramItem: paramItems[133] }
            MyParamItemList{ paramIndex: 134; paramItem: paramItems[134] }
            MyParamItemList{ paramIndex: 135; paramItem: paramItems[135] }
            MyParamItemList{ paramIndex: 136; paramItem: paramItems[136] }
            MyParamItemList{ paramIndex: 137; paramItem: paramItems[137] }
        },
        ObjectModel {
        },
        ObjectModel {
        }
    ]    
}
