import QtQuick 2.9
import QtQuick.Controls 1.5
import QtQuick.Controls.Styles 1.4


//basic class for the top line

Rectangle{     
//------------------------
// Interface        

    property color labelColor: 'blue'
    
    property int xPos1: s.winScale(10)
    property int xPos2: s.winScale(400)
    property int xSpacing1: s.winScale(100)
    property int xSpacing2: s.winScale(85)
    
    property int yPos: s.winScale(25)
    property int ySpacing: s.winScale(23)
    
//------------------------
                
    MyText {
        id: lbInfoCenter
        text: 'Info Center'
        font.bold: true
    }
                
    function xLabel1(){ return xPos1; }
    function xInfo1() { return xPos1 + xSpacing1; }
    function xLabel2(){ return xPos2; }
    function xInfo2() { return xPos2 + xSpacing2; }
    function yI(i)    { return yPos + i*ySpacing; }
                
    MyText{ x: parent.xLabel1(); y: parent.yI(0); text: 'Imu1'; color: parent.labelColor; font.bold: true } 
    MyText{ x: parent.xInfo1();  y: parent.yI(0); id: _imu1A; text: '-' }

    MyText{ x: parent.xLabel1(); y: parent.yI(1); text: 'Imu2'; color: parent.labelColor; font.bold: true } 
    MyText{ x: parent.xInfo1();  y: parent.yI(1); id: _imu2A; text: '-' }

    MyText{ x: parent.xLabel1(); y: parent.yI(2); text: 'Encoders'; color: parent.labelColor; font.bold: true } 
    MyText{ x: parent.xInfo1();  y: parent.yI(2); id: _encodersA; text: '-' }

    MyText{ x: parent.xLabel1(); y: parent.yI(3); text: 'STorM32-Link'; color: parent.labelColor; font.bold: true } 
    MyText{ x: parent.xInfo1();  y: parent.yI(3); id: _link; text: '-' }

    MyText{ x: parent.xLabel1(); y: parent.yI(4); text: 'Wifi'; color: parent.labelColor; font.bold: true } 
    MyText{ x: parent.xInfo1();  y: parent.yI(4); id: _wifi; text: '-' }

    MyText{ x: parent.xLabel1(); y: parent.yI(5); text: 'Bat'; color: parent.labelColor; font.bold: true } 
    MyText{ x: parent.xInfo1();  y: parent.yI(5); id: _bat; text: '-' }

    MyText{ x: parent.xLabel1(); y: parent.yI(6); text: 'Motors'; color: parent.labelColor; font.bold: true } 
    MyText{ x: parent.xInfo1();  y: parent.yI(6); id: _motors; text: '-' }

    MyText{ x: parent.xLabel2(); y: parent.yI(0); text: 'State'; color: parent.labelColor; font.bold: true } 
    MyText{ x: parent.xInfo2();  y: parent.yI(0); id: _state; text: '-' }
                
    MyText{ x: parent.xLabel2(); y: parent.yI(1); text: 'Voltage'; color: parent.labelColor; font.bold: true } 
    MyText{ x: parent.xInfo2();  y: parent.yI(1); id: _voltage; text: '-' }
                
    MyText{ x: parent.xLabel2(); y: parent.yI(2); text: 'Imu1'; color: parent.labelColor; font.bold: true } 
    MyText{ x: parent.xInfo2();  y: parent.yI(2); id: _imu1B; text: '-' }
                
    MyText{ x: parent.xLabel2(); y: parent.yI(3); text: 'Imu2'; color: parent.labelColor; font.bold: true } 
    MyText{ x: parent.xInfo2();  y: parent.yI(3); id: _imu2B; text: '-' }
                
    MyText{ x: parent.xLabel2(); y: parent.yI(4); text: 'Encoders'; color: parent.labelColor; font.bold: true } 
    MyText{ x: parent.xInfo2();  y: parent.yI(4); id: _encodersB; text: '-' }
                
    MyText{ x: parent.xLabel2(); y: parent.yI(5); text: 'Bus Errors'; color: parent.labelColor; font.bold: true } 
    MyText{ x: parent.xInfo2();  y: parent.yI(5); id: _errors; text: '-' }
    
    Connections {
        target: wMain
        onSignalConnectedChanged: {
            if( !newConnected ) {
                _imu1A.text = '-'; _imu2A.text = '-'; _encodersA.text = '-'; _link.text = '-'; 
                _bat.text = '-'; _motors.text = '-'; _wifi.text = '-';
                _state.text = '-'; _voltage.text = '-'; _imu1B.text = '-'; _imu2B.text = '-'; 
                _encodersB.text = '-'; _errors.text = '-'
            }
        }
    }
    Connections {
        target: wMain
        onSignalInfoChanged: {
            _imu1A.text = newInfo.imu1A
            _imu2A.text = newInfo.imu2A
            _encodersA.text = newInfo.encodersA
            _link.text = newInfo.link
            _bat.text = newInfo.bat
            _motors.text = newInfo.motors
            _wifi.text = newInfo.wifi
            
            _state.text = newInfo.state
            _voltage.text = newInfo.voltage
            _imu1B.text = newInfo.imu1B
            _imu2B.text = newInfo.imu2B
            _encodersB.text = newInfo.encodersB
            _errors.text = newInfo.errors
        }
    }
}    
