import QtQuick 2.9
import QtQuick.Controls 1.5 as Cntrl1
import QtQuick.Controls 2.2 as Cntrl2

/*
Controls 1 ComboBox has (at least) two bugs:
- a touch press frequently induces to presses, so that the dropdown opens and closes quickly
- changing the list on aboutToShow() makes the dropdown to be missplaced
- dropdown can go out of main window area
thus the Controls2 ComboBox is used here 
*/


Cntrl2.ComboBox {
//------------------------
// Interface        
// the popup object can be accessed from py by the objectName: _combobox.objectName+'Popup'    

    property color rectangleColor: 'white'
    property int borderWidth: 0
    property color borderColor: 'black'
    property int dropDownExtraWidth: 0
    property var scrollbarPolicy: Cntrl2.ScrollBar.AlwaysOn
    
//------------------------

    id: _combobox

    contentItem: MyText {
        id: _text
        color: (_combobox.enabled) ? 'black' : 'gray'
        text: _combobox.displayText
        font: _combobox.font
        verticalAlignment: Text.AlignVCenter;
        anchors.left: parent.left
        anchors.leftMargin: s.winScale(5)
    }
            
    indicator: Rectangle{}
            
    background: Rectangle {
        color: rectangleColor
        implicitHeight: s.winScale(19)
        Image {
            height: s.winScale(17)
            width: height
            fillMode: Image.PreserveAspectFit
            source: s.iconComboBoxDown
            anchors.right: parent.right
            anchors.verticalCenter: parent.verticalCenter
            opacity: (_combobox.enabled) ? 1.0 : 0.35
        }
        border.width: borderWidth
        border.color: borderColor
    }

    delegate: Cntrl2.ItemDelegate {
        width: _combobox.width + dropDownExtraWidth
        //height: 38 //this gives pretty much the same space as the "old" MyComboBox 
        height: 1.2*_combobox.height  //s.winScale(38) ////I like this better though //_port.font.pixelSize + 10 //_port.height
        contentItem: MyText {
            text: modelData
            font: _combobox.font
            color: (hovered) ? 'white' : (_combobox.highlightedIndex === index) ? 'white' : 'black'
                   
            verticalAlignment: Text.AlignVCenter
        }
        background: Rectangle{
            //color: (hovered) ? 'blue' : (_port.highlightedIndex === index) ? 'lightblue' : 'white'
            color: (hovered) ? '#0080c0' : (_combobox.highlightedIndex === index) ? '#3b9dca' : 'white'
        }
        highlighted: _combobox.highlightedIndex === index
    }            
            
    popup: Cntrl2.Popup {
        id: _popup
        objectName: _combobox.objectName+'Popup' //'cbPortPopup'
        x: -1
        y: _combobox.height - 1
        width: _combobox.width + dropDownExtraWidth
        implicitHeight: contentItem.implicitHeight
        padding: 1
        contentItem: ListView {
            clip: true  
            implicitHeight: contentHeight
            //implicitHeight: 200
            model: _combobox.delegateModel
            currentIndex: _combobox.highlightedIndex
            //ScrollIndicator.vertical: Cntrl2.ScrollIndicator { }
            Cntrl2.ScrollBar.vertical: Cntrl2.ScrollBar{ 
                width: s.winScale(6)
                policy: _combobox.scrollbarPolicy
            }
        }
        background: Rectangle {
            border.color: 'black'
        }
    }            

    model: ListModel {}

/* is handled by py            
            Connections {
                target: cbPortPopup //_port.popup
                onAboutToShow: { console.log('s'); _port.populateList(); }
            }

            function populateList(portList) { 
               // model = ['COMx','COMy']
               model = portList
            }
*/            
}
        
        