import QtQuick 2.9
import QtQuick.Controls 1.5
import QtQuick.Controls 2.2 as Cntrl2
import QtQuick.Controls.Styles 1.4
import QtQuick.Dialogs 1.2



Dialog {
//------------------------
// Interface        

//------------------------

    id: _dialog
    
    title: 'Edit Board Name'
    
    contentItem: Rectangle {
    
        id: _rect
        color: 'white'
        implicitWidth: _text2.width + 2*s.winScale(20)
        //implicitHeight: 300

        MyText {
            id: _text
            x: s.winScale(20)
            y: s.winScale(20)
            text: qsTr('Please enter the new name for the STorM32 controller board:','boardnameeditdialog')
        }
        
        MyTextField {
            id: _textfield
            anchors.top: _text.bottom
            anchors.topMargin: s.winScale(20)
            anchors.horizontalCenter: parent.horizontalCenter
            width: s.winScale(200)
            borderWidth: 1
            onAccepted: {
                btChangeBoardNameToolQmlClicked(_textfield.text.slice(0,16))
                _dialog.visible = false
            }
        }
        
        MyText {
            id: _text2
            anchors.top: _textfield.bottom
            anchors.topMargin: s.winScale(20)
            x: s.winScale(20)
            text: qsTr('NOTE: On >OK< the new name will be stoed immediately into the EEPROM!','boardnameeditdialog')
        }
        
        Row{        
            anchors.top: _text2.bottom
            anchors.topMargin: s.winScale(20)
            anchors.bottom: parent.bottom
            anchors.bottomMargin: s.winScale(20)
            anchors.horizontalCenter: parent.horizontalCenter
            spacing: s.winScale(20)
            
            MyButton {
                width: s.winScale(100)
                text: qsTr('OK','boardnameeditdialog')
                onClicked: {
                    btChangeBoardNameToolQmlClicked(_textfield.text.slice(0,16))
                    _dialog.visible = false
                }
            }
            MyButton {
                width: s.winScale(100)
                text: qsTr('Cancel','boardnameeditdialog')
                onClicked: {
                    _dialog.visible = false
                }
            }
        }        
    }
    
    function prepareBeforeShow() {
        //find the board name
        // this is daunting, we have to traverse paramList
        for(var n=0; n<navBar.paramList.length; n++) {
            var objModel = navBar.paramList[n]
            for(var i=0; i<objModel.count; i++) {
                var obj = objModel.get(i)
                if( obj.label == 'Name' ) { _textfield.text = obj.strValue; return; }
            }
        }
         _textfield.text = '?'
    }
    
    function prepareAfterShow() {
        _textfield.focus = true
        //_textfield.cursorPosition = 0
    }
}    

