paramJson = [
    {
        "name" : "Firmware Version",
        "ext" : "",
        "page" : "dashboard",
        "type" : "STR+READONLY",
        "size" : 16,
        "adr" : -1,
        "default" : "",
        "foc" : 0,
        "hidden" : 0,
        "column" : 1
    },{
        "name" : "Board",
        "ext" : "",
        "page" : "dashboard",
        "type" : "STR+READONLY",
        "size" : 16,
        "adr" : -1,
        "default" : "",
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Name",
        "ext" : "",
        "page" : "dashboard",
        "type" : "STR+READONLY",
        "size" : 16,
        "adr" : -1,
        "default" : "",
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Gyro LPF",
        "ext" : "",
        "page" : "pid",
        "type" : "LIST",
        "size" : 1,
        "adr" : 12,
        "default" : 1,
        "steps" : 1, "min" : 0, "max" : 6,
        "choices" : ["off", "1.5 ms", "3.0 ms", "4.5 ms", "6.0 ms", "7.5 ms", "9 ms"],
        "foc" : 1,
        "hidden" : 0,
        "pos" : [1,1]
    },{
        "name" : "Foc Gyro LPF",
        "ext" : "",
        "page" : "pid",
        "type" : "LIST",
        "size" : 1,
        "adr" : 41,
        "default" : 1,
        "steps" : 1, "min" : 0, "max" : 6,
        "choices" : ["off", "1.5 ms", "3.0 ms", "4.5 ms", "6.0 ms", "7.5 ms", "9 ms"],
        "foc" : 2,
        "hidden" : 0,
        "pos" : [1,1]
    },{
        "name" : "Imu2 FeedForward LPF",
        "ext" : "",
        "page" : "pid",
        "type" : "LIST",
        "size" : 1,
        "adr" : 72,
        "default" : 1,
        "steps" : 1, "min" : 0, "max" : 6,
        "choices" : ["off", "1.5 ms", "4 ms", "10 ms", "22 ms", "46 ms", "94 ms"],
        "foc" : 3,
        "hidden" : 0
    },{
        "name" : "Voltage Correction",
        "ext" : "",
        "page" : "pid",
        "type" : "UINT",
        "size" : 2,
        "adr" : 75,
        "default" : 0,
        "steps" : 1, "min" : 0, "max" : 200,
        "len" : 7, "ppos" : 0, "unit" : "%",
        "foc" : 3,
        "hidden" : 0,
        "pos" : [1,4]
    },{
        "name" : "Roll Yaw PD Mixing",
        "ext" : "",
        "page" : "pid",
        "type" : "UINT",
        "size" : 2,
        "adr" : 73,
        "default" : 0,
        "steps" : 1, "min" : 0, "max" : 100,
        "len" : 5, "ppos" : 0, "unit" : "%",
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Pitch P",
        "ext" : "",
        "page" : "pid",
        "type" : "UINT",
        "size" : 2,
        "adr" : 0,
        "default" : 400,
        "steps" : 10, "min" : 0, "max" : 3000,
        "len" : 5, "ppos" : 2, "unit" : "",
        "foc" : 1,
        "hidden" : 0,
        "pos" : [2,1]
    },{
        "name" : "Pitch I",
        "ext" : "",
        "page" : "pid",
        "type" : "UINT",
        "size" : 2,
        "adr" : 1,
        "default" : 1000,
        "steps" : 50, "min" : 0, "max" : 32000,
        "len" : 7, "ppos" : 1, "unit" : "",
        "foc" : 1,
        "hidden" : 0
    },{
        "name" : "Pitch D",
        "ext" : "",
        "page" : "pid",
        "type" : "UINT",
        "size" : 2,
        "adr" : 2,
        "default" : 500,
        "steps" : 50, "min" : 0, "max" : 8000,
        "len" : 3, "ppos" : 4, "unit" : "",
        "foc" : 1,
        "hidden" : 0
    },{
        "name" : "Pitch Motor Vmax",
        "ext" : "",
        "page" : "pid",
        "type" : "UINT",
        "size" : 2,
        "adr" : 3,
        "default" : 150,
        "steps" : 1, "min" : 0, "max" : 255,
        "len" : 5, "ppos" : 0, "unit" : "",
        "foc" : 1,
        "hidden" : 0
    },{
        "name" : "Roll P",
        "ext" : "",
        "page" : "pid",
        "type" : "UINT",
        "size" : 2,
        "adr" : 4,
        "default" : 400,
        "steps" : 10, "min" : 0, "max" : 3000,
        "len" : 5, "ppos" : 2, "unit" : "",
        "foc" : 1,
        "hidden" : 0,
        "pos" : [3,1]
    },{
        "name" : "Roll I",
        "ext" : "",
        "page" : "pid",
        "type" : "UINT",
        "size" : 2,
        "adr" : 5,
        "default" : 1000,
        "steps" : 50, "min" : 0, "max" : 32000,
        "len" : 7, "ppos" : 1, "unit" : "",
        "foc" : 1,
        "hidden" : 0
    },{
        "name" : "Roll D",
        "ext" : "",
        "page" : "pid",
        "type" : "UINT",
        "size" : 2,
        "adr" : 6,
        "default" : 500,
        "steps" : 50, "min" : 0, "max" : 8000,
        "len" : 3, "ppos" : 4, "unit" : "",
        "foc" : 1,
        "hidden" : 0
    },{
        "name" : "Roll Motor Vmax",
        "ext" : "",
        "page" : "pid",
        "type" : "UINT",
        "size" : 2,
        "adr" : 7,
        "default" : 150,
        "steps" : 1, "min" : 0, "max" : 255,
        "len" : 5, "ppos" : 0, "unit" : "",
        "foc" : 1,
        "hidden" : 0
    },{
        "name" : "Yaw P",
        "ext" : "",
        "page" : "pid",
        "type" : "UINT",
        "size" : 2,
        "adr" : 8,
        "default" : 400,
        "steps" : 10, "min" : 0, "max" : 3000,
        "len" : 5, "ppos" : 2, "unit" : "",
        "foc" : 1,
        "hidden" : 0,
        "pos" : [4,1]
    },{
        "name" : "Yaw I",
        "ext" : "",
        "page" : "pid",
        "type" : "UINT",
        "size" : 2,
        "adr" : 9,
        "default" : 1000,
        "steps" : 50, "min" : 0, "max" : 32000,
        "len" : 7, "ppos" : 1, "unit" : "",
        "foc" : 1,
        "hidden" : 0
    },{
        "name" : "Yaw D",
        "ext" : "",
        "page" : "pid",
        "type" : "UINT",
        "size" : 2,
        "adr" : 10,
        "default" : 500,
        "steps" : 50, "min" : 0, "max" : 8000,
        "len" : 3, "ppos" : 4, "unit" : "",
        "foc" : 1,
        "hidden" : 0
    },{
        "name" : "Yaw Motor Vmax",
        "ext" : "",
        "page" : "pid",
        "type" : "UINT",
        "size" : 2,
        "adr" : 11,
        "default" : 150,
        "steps" : 1, "min" : 0, "max" : 255,
        "len" : 5, "ppos" : 0, "unit" : "",
        "foc" : 1,
        "hidden" : 0
    },{
        "name" : "Foc Pitch P",
        "ext" : "",
        "page" : "pid",
        "type" : "UINT",
        "size" : 2,
        "adr" : 23,
        "default" : 400,
        "steps" : 10, "min" : 0, "max" : 3000,
        "len" : 5, "ppos" : 2, "unit" : "",
        "foc" : 2,
        "hidden" : 0,
        "pos" : [2,1]
    },{
        "name" : "Foc Pitch I",
        "ext" : "",
        "page" : "pid",
        "type" : "UINT",
        "size" : 2,
        "adr" : 24,
        "default" : 100,
        "steps" : 50, "min" : 0, "max" : 32000,
        "len" : 7, "ppos" : 1, "unit" : "",
        "foc" : 2,
        "hidden" : 0
    },{
        "name" : "Foc Pitch D",
        "ext" : "",
        "page" : "pid",
        "type" : "UINT",
        "size" : 2,
        "adr" : 25,
        "default" : 2000,
        "steps" : 50, "min" : 0, "max" : 8000,
        "len" : 3, "ppos" : 4, "unit" : "",
        "foc" : 2,
        "hidden" : 0
    },{
        "name" : "Foc Pitch K",
        "ext" : "",
        "page" : "pid",
        "type" : "UINT",
        "size" : 2,
        "adr" : 26,
        "default" : 10,
        "steps" : 1, "min" : 1, "max" : 100,
        "len" : 5, "ppos" : 1, "unit" : "",
        "foc" : 2,
        "hidden" : 0
    },{
        "name" : "Foc Roll P",
        "ext" : "",
        "page" : "pid",
        "type" : "UINT",
        "size" : 2,
        "adr" : 29,
        "default" : 400,
        "steps" : 10, "min" : 0, "max" : 3000,
        "len" : 5, "ppos" : 2, "unit" : "",
        "foc" : 2,
        "hidden" : 0,
        "pos" : [3,1]
    },{
        "name" : "Foc Roll I",
        "ext" : "",
        "page" : "pid",
        "type" : "UINT",
        "size" : 2,
        "adr" : 30,
        "default" : 100,
        "steps" : 50, "min" : 0, "max" : 32000,
        "len" : 7, "ppos" : 1, "unit" : "",
        "foc" : 2,
        "hidden" : 0
    },{
        "name" : "Foc Roll D",
        "ext" : "",
        "page" : "pid",
        "type" : "UINT",
        "size" : 2,
        "adr" : 31,
        "default" : 2000,
        "steps" : 50, "min" : 0, "max" : 8000,
        "len" : 3, "ppos" : 4, "unit" : "",
        "foc" : 2,
        "hidden" : 0
    },{
        "name" : "Foc Roll K",
        "ext" : "",
        "page" : "pid",
        "type" : "UINT",
        "size" : 2,
        "adr" : 32,
        "default" : 10,
        "steps" : 1, "min" : 1, "max" : 100,
        "len" : 5, "ppos" : 1, "unit" : "",
        "foc" : 2,
        "hidden" : 0
    },{
        "name" : "Foc Yaw P",
        "ext" : "",
        "page" : "pid",
        "type" : "UINT",
        "size" : 2,
        "adr" : 35,
        "default" : 400,
        "steps" : 10, "min" : 0, "max" : 3000,
        "len" : 5, "ppos" : 2, "unit" : "",
        "foc" : 2,
        "hidden" : 0,
        "pos" : [4,1]
    },{
        "name" : "Foc Yaw I",
        "ext" : "",
        "page" : "pid",
        "type" : "UINT",
        "size" : 2,
        "adr" : 36,
        "default" : 100,
        "steps" : 50, "min" : 0, "max" : 32000,
        "len" : 7, "ppos" : 1, "unit" : "",
        "foc" : 2,
        "hidden" : 0
    },{
        "name" : "Foc Yaw D",
        "ext" : "",
        "page" : "pid",
        "type" : "UINT",
        "size" : 2,
        "adr" : 37,
        "default" : 2000,
        "steps" : 50, "min" : 0, "max" : 8000,
        "len" : 3, "ppos" : 4, "unit" : "",
        "foc" : 2,
        "hidden" : 0
    },{
        "name" : "Foc Yaw K",
        "ext" : "",
        "page" : "pid",
        "type" : "UINT",
        "size" : 2,
        "adr" : 38,
        "default" : 10,
        "steps" : 1, "min" : 1, "max" : 100,
        "len" : 5, "ppos" : 1, "unit" : "",
        "foc" : 2,
        "hidden" : 0
    },{
        "name" : "Pan Mode Control",
        "ext" : "",
        "page" : "pan",
        "type" : "LIST",
        "size" : 1,
        "adr" : 79,
        "default" : 0,
        "steps" : 1, "min" : 0, "max" : 42,
        "choices" : ["off", "Rc-0", "Rc-1", "Rc-2", "Rc2-0", "Rc2-1", "Rc2-2", "Rc2-3", "Pot-0", "Pot-1", "Pot-2", "Virtual-1", "Virtual-2", "Virtual-3", "Virtual-4", "Virtual-5", "Virtual-6", "Virtual-7", "Virtual-8", "Virtual-9", "Virtual-10", "Virtual-11", "Virtual-12", "Virtual-13", "Virtual-14", "Virtual-15", "Virtual-16", "But switch", "But latch", "But step", "Aux-0 switch", "Aux-1 switch", "Aux-2 switch", "Aux-01 switch", "Aux-012 switch", "Aux-0 latch", "Aux-1 latch", "Aux-2 latch", "Aux-01 latch", "Aux-012 latch", "Aux-0 step", "Aux-1 step", "Aux-2 step"],
        "foc" : 0,
        "hidden" : 0,
        "column" : 1
    },{
        "name" : "Pan Mode Default Setting",
        "ext" : "",
        "page" : "pan",
        "type" : "LIST",
        "size" : 1,
        "adr" : 80,
        "default" : 0,
        "steps" : 1, "min" : 0, "max" : 5,
        "choices" : ["hold hold pan", "hold hold hold", "pan pan pan", "pan hold hold", "pan hold pan", "hold pan pan", "off"],
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Pan Mode Setting #1",
        "ext" : "",
        "page" : "pan",
        "type" : "LIST",
        "size" : 1,
        "adr" : 81,
        "default" : 1,
        "steps" : 1, "min" : 0, "max" : 6,
        "choices" : ["hold hold pan", "hold hold hold", "pan pan pan", "pan hold hold", "pan hold pan", "hold pan pan", "off"],
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Pan Mode Setting #2",
        "ext" : "",
        "page" : "pan",
        "type" : "LIST",
        "size" : 1,
        "adr" : 82,
        "default" : 4,
        "steps" : 1, "min" : 0, "max" : 6,
        "choices" : ["hold hold pan", "hold hold hold", "pan pan pan", "pan hold hold", "pan hold pan", "hold pan pan", "off"],
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Pan Mode Setting #3",
        "ext" : "",
        "page" : "pan",
        "type" : "LIST",
        "size" : 1,
        "adr" : 83,
        "default" : 2,
        "steps" : 1, "min" : 0, "max" : 6,
        "choices" : ["hold hold pan", "hold hold hold", "pan pan pan", "pan hold hold", "pan hold pan", "hold pan pan", "off"],
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Pitch Pan",
        "ext" : "(0 = hold)",
        "page" : "pan",
        "type" : "UINT",
        "size" : 2,
        "adr" : 84,
        "default" : 20,
        "steps" : 1, "min" : 0, "max" : 50,
        "len" : 5, "ppos" : 1, "unit" : "",
        "foc" : 0,
        "hidden" : 0,
        "column" : 2
    },{
        "name" : "Pitch Pan Deadband",
        "ext" : "",
        "page" : "pan",
        "type" : "UINT",
        "size" : 2,
        "adr" : 85,
        "default" : 0,
        "steps" : 10, "min" : 0, "max" : 600,
        "len" : 5, "ppos" : 1, "unit" : "",
        "foc" : 0,
        "hidden" : 0,
        "pos" : [2,3]
    },{
        "name" : "Pitch Pan Expo",
        "ext" : "",
        "page" : "pan",
        "type" : "UINT",
        "size" : 2,
        "adr" : 86,
        "default" : 0,
        "steps" : 1, "min" : 0, "max" : 100,
        "len" : 5, "ppos" : 0, "unit" : "%",
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Roll Pan",
        "ext" : "(0 = hold)",
        "page" : "pan",
        "type" : "UINT",
        "size" : 2,
        "adr" : 87,
        "default" : 20,
        "steps" : 1, "min" : 0, "max" : 50,
        "len" : 5, "ppos" : 1, "unit" : "",
        "foc" : 0,
        "hidden" : 0,
        "column" : 3
    },{
        "name" : "Roll Pan Deadband",
        "ext" : "",
        "page" : "pan",
        "type" : "UINT",
        "size" : 2,
        "adr" : 88,
        "default" : 0,
        "steps" : 10, "min" : 0, "max" : 600,
        "len" : 5, "ppos" : 1, "unit" : "",
        "foc" : 0,
        "hidden" : 0,
        "pos" : [3,3]
    },{
        "name" : "Roll Pan Expo",
        "ext" : "",
        "page" : "pan",
        "type" : "UINT",
        "size" : 2,
        "adr" : 89,
        "default" : 0,
        "steps" : 1, "min" : 0, "max" : 100,
        "len" : 5, "ppos" : 0, "unit" : "%",
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Yaw Pan",
        "ext" : "(0 = hold)",
        "page" : "pan",
        "type" : "UINT",
        "size" : 2,
        "adr" : 90,
        "default" : 20,
        "steps" : 1, "min" : 0, "max" : 50,
        "len" : 5, "ppos" : 1, "unit" : "",
        "foc" : 0,
        "hidden" : 0,
        "column" : 4
    },{
        "name" : "Yaw Pan Deadband",
        "ext" : "",
        "page" : "pan",
        "type" : "UINT",
        "size" : 2,
        "adr" : 91,
        "default" : 50,
        "steps" : 5, "min" : 0, "max" : 100,
        "len" : 5, "ppos" : 1, "unit" : "",
        "foc" : 0,
        "hidden" : 0,
        "pos" : [4,3]
    },{
        "name" : "Yaw Pan Expo",
        "ext" : "",
        "page" : "pan",
        "type" : "UINT",
        "size" : 2,
        "adr" : 92,
        "default" : 0,
        "steps" : 1, "min" : 0, "max" : 100,
        "len" : 5, "ppos" : 0, "unit" : "%",
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Yaw Pan Deadband LPF",
        "ext" : "",
        "page" : "pan",
        "type" : "UINT",
        "size" : 2,
        "adr" : 93,
        "default" : 150,
        "steps" : 5, "min" : 0, "max" : 400,
        "len" : 5, "ppos" : 2, "unit" : "s",
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Rc Dead Band",
        "ext" : "",
        "page" : "rcinputs",
        "type" : "UINT",
        "size" : 2,
        "adr" : 96,
        "default" : 10,
        "steps" : 1, "min" : 0, "max" : 50,
        "len" : 0, "ppos" : 0, "unit" : "us",
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Rc Hysteresis",
        "ext" : "",
        "page" : "rcinputs",
        "type" : "UINT",
        "size" : 2,
        "adr" : 97,
        "default" : 5,
        "steps" : 1, "min" : 0, "max" : 50,
        "len" : 0, "ppos" : 0, "unit" : "us",
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Rc Pitch Trim",
        "ext" : "",
        "page" : "rcinputs",
        "type" : "INT",
        "size" : 2,
        "adr" : 104,
        "default" : 0,
        "steps" : 1, "min" : -100, "max" : 100,
        "len" : 0, "ppos" : 0, "unit" : "us",
        "foc" : 0,
        "hidden" : 0,
        "pos" : [1,4]
    },{
        "name" : "Rc Roll Trim",
        "ext" : "",
        "page" : "rcinputs",
        "type" : "INT",
        "size" : 2,
        "adr" : 111,
        "default" : 0,
        "steps" : 1, "min" : -100, "max" : 100,
        "len" : 0, "ppos" : 0, "unit" : "us",
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Rc Yaw Trim",
        "ext" : "",
        "page" : "rcinputs",
        "type" : "INT",
        "size" : 2,
        "adr" : 118,
        "default" : 0,
        "steps" : 1, "min" : -100, "max" : 100,
        "len" : 0, "ppos" : 0, "unit" : "us",
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Rc Pitch",
        "ext" : "",
        "page" : "rcinputs",
        "type" : "LIST",
        "size" : 1,
        "adr" : 102,
        "default" : 0,
        "steps" : 1, "min" : 0, "max" : 42,
        "choices" : ["off", "Rc-0", "Rc-1", "Rc-2", "Rc2-0", "Rc2-1", "Rc2-2", "Rc2-3", "Pot-0", "Pot-1", "Pot-2", "Virtual-1", "Virtual-2", "Virtual-3", "Virtual-4", "Virtual-5", "Virtual-6", "Virtual-7", "Virtual-8", "Virtual-9", "Virtual-10", "Virtual-11", "Virtual-12", "Virtual-13", "Virtual-14", "Virtual-15", "Virtual-16", "But switch", "But latch", "But step", "Aux-0 switch", "Aux-1 switch", "Aux-2 switch", "Aux-01 switch", "Aux-012 switch", "Aux-0 latch", "Aux-1 latch", "Aux-2 latch", "Aux-01 latch", "Aux-012 latch", "Aux-0 step", "Aux-1 step", "Aux-2 step"],
        "foc" : 0,
        "hidden" : 0,
        "column" : 2
    },{
        "name" : "Rc Pitch Mode",
        "ext" : "",
        "page" : "rcinputs",
        "type" : "LIST",
        "size" : 1,
        "adr" : 103,
        "default" : 0,
        "steps" : 1, "min" : 0, "max" : 2,
        "choices" : ["absolute", "relative", "absolute centered"],
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Rc Pitch Min",
        "ext" : "",
        "page" : "rcinputs",
        "type" : "INT",
        "size" : 2,
        "adr" : 105,
        "default" : -250,
        "steps" : 5, "min" : -1200, "max" : 1200,
        "len" : 0, "ppos" : 1, "unit" : "",
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Rc Pitch Max",
        "ext" : "",
        "page" : "rcinputs",
        "type" : "INT",
        "size" : 2,
        "adr" : 106,
        "default" : 250,
        "steps" : 5, "min" : -1200, "max" : 1200,
        "len" : 0, "ppos" : 1, "unit" : "",
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Rc Pitch Speed Limit",
        "ext" : "(0 = off)",
        "page" : "rcinputs",
        "type" : "UINT",
        "size" : 2,
        "adr" : 107,
        "default" : 400,
        "steps" : 5, "min" : 0, "max" : 1000,
        "len" : 0, "ppos" : 1, "unit" : "/s",
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Rc Pitch Accel Limit",
        "ext" : "(0 = off)",
        "page" : "rcinputs",
        "type" : "UINT",
        "size" : 2,
        "adr" : 108,
        "default" : 300,
        "steps" : 10, "min" : 0, "max" : 1000,
        "len" : 0, "ppos" : 3, "unit" : "",
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Rc Roll",
        "ext" : "",
        "page" : "rcinputs",
        "type" : "LIST",
        "size" : 1,
        "adr" : 109,
        "default" : 0,
        "steps" : 1, "min" : 0, "max" : 42,
        "choices" : ["off", "Rc-0", "Rc-1", "Rc-2", "Rc2-0", "Rc2-1", "Rc2-2", "Rc2-3", "Pot-0", "Pot-1", "Pot-2", "Virtual-1", "Virtual-2", "Virtual-3", "Virtual-4", "Virtual-5", "Virtual-6", "Virtual-7", "Virtual-8", "Virtual-9", "Virtual-10", "Virtual-11", "Virtual-12", "Virtual-13", "Virtual-14", "Virtual-15", "Virtual-16", "But switch", "But latch", "But step", "Aux-0 switch", "Aux-1 switch", "Aux-2 switch", "Aux-01 switch", "Aux-012 switch", "Aux-0 latch", "Aux-1 latch", "Aux-2 latch", "Aux-01 latch", "Aux-012 latch", "Aux-0 step", "Aux-1 step", "Aux-2 step"],
        "foc" : 0,
        "hidden" : 0,
        "column" : 3
    },{
        "name" : "Rc Roll Mode",
        "ext" : "",
        "page" : "rcinputs",
        "type" : "LIST",
        "size" : 1,
        "adr" : 110,
        "default" : 0,
        "steps" : 1, "min" : 0, "max" : 2,
        "choices" : ["absolute", "relative", "absolute centered"],
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Rc Roll Min",
        "ext" : "",
        "page" : "rcinputs",
        "type" : "INT",
        "size" : 2,
        "adr" : 112,
        "default" : -250,
        "steps" : 5, "min" : -450, "max" : 450,
        "len" : 0, "ppos" : 1, "unit" : "",
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Rc Roll Max",
        "ext" : "",
        "page" : "rcinputs",
        "type" : "INT",
        "size" : 2,
        "adr" : 113,
        "default" : 250,
        "steps" : 5, "min" : -450, "max" : 450,
        "len" : 0, "ppos" : 1, "unit" : "",
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Rc Roll Speed Limit",
        "ext" : "(0 = off)",
        "page" : "rcinputs",
        "type" : "UINT",
        "size" : 2,
        "adr" : 114,
        "default" : 400,
        "steps" : 5, "min" : 0, "max" : 1000,
        "len" : 0, "ppos" : 1, "unit" : "/s",
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Rc Roll Accel Limit",
        "ext" : "(0 = off)",
        "page" : "rcinputs",
        "type" : "UINT",
        "size" : 2,
        "adr" : 115,
        "default" : 300,
        "steps" : 10, "min" : 0, "max" : 1000,
        "len" : 0, "ppos" : 3, "unit" : "",
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Rc Yaw",
        "ext" : "",
        "page" : "rcinputs",
        "type" : "LIST",
        "size" : 1,
        "adr" : 116,
        "default" : 0,
        "steps" : 1, "min" : 0, "max" : 42,
        "choices" : ["off", "Rc-0", "Rc-1", "Rc-2", "Rc2-0", "Rc2-1", "Rc2-2", "Rc2-3", "Pot-0", "Pot-1", "Pot-2", "Virtual-1", "Virtual-2", "Virtual-3", "Virtual-4", "Virtual-5", "Virtual-6", "Virtual-7", "Virtual-8", "Virtual-9", "Virtual-10", "Virtual-11", "Virtual-12", "Virtual-13", "Virtual-14", "Virtual-15", "Virtual-16", "But switch", "But latch", "But step", "Aux-0 switch", "Aux-1 switch", "Aux-2 switch", "Aux-01 switch", "Aux-012 switch", "Aux-0 latch", "Aux-1 latch", "Aux-2 latch", "Aux-01 latch", "Aux-012 latch", "Aux-0 step", "Aux-1 step", "Aux-2 step"],
        "foc" : 0,
        "hidden" : 0,
        "column" : 4
    },{
        "name" : "Rc Yaw Mode",
        "ext" : "",
        "page" : "rcinputs",
        "type" : "LIST",
        "size" : 1,
        "adr" : 117,
        "default" : 0,
        "steps" : 1, "min" : 0, "max" : 3,
        "choices" : ["absolute", "relative", "absolute centered", "relative turn around"],
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Rc Yaw Min",
        "ext" : "",
        "page" : "rcinputs",
        "type" : "INT",
        "size" : 2,
        "adr" : 119,
        "default" : -250,
        "steps" : 10, "min" : -2700, "max" : 2700,
        "len" : 0, "ppos" : 1, "unit" : "",
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Rc Yaw Max",
        "ext" : "",
        "page" : "rcinputs",
        "type" : "INT",
        "size" : 2,
        "adr" : 120,
        "default" : 250,
        "steps" : 10, "min" : -2700, "max" : 2700,
        "len" : 0, "ppos" : 1, "unit" : "",
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Rc Yaw Speed Limit",
        "ext" : "(0 = off)",
        "page" : "rcinputs",
        "type" : "UINT",
        "size" : 2,
        "adr" : 121,
        "default" : 400,
        "steps" : 5, "min" : 0, "max" : 1000,
        "len" : 0, "ppos" : 1, "unit" : "/s",
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Rc Yaw Accel Limit",
        "ext" : "(0 = off)",
        "page" : "rcinputs",
        "type" : "UINT",
        "size" : 2,
        "adr" : 122,
        "default" : 300,
        "steps" : 10, "min" : 0, "max" : 1000,
        "len" : 0, "ppos" : 3, "unit" : "",
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Standby",
        "ext" : "",
        "page" : "functions",
        "type" : "LIST",
        "size" : 1,
        "adr" : 123,
        "default" : 0,
        "steps" : 1, "min" : 0, "max" : 42,
        "choices" : ["off", "Rc-0", "Rc-1", "Rc-2", "Rc2-0", "Rc2-1", "Rc2-2", "Rc2-3", "Pot-0", "Pot-1", "Pot-2", "Virtual-1", "Virtual-2", "Virtual-3", "Virtual-4", "Virtual-5", "Virtual-6", "Virtual-7", "Virtual-8", "Virtual-9", "Virtual-10", "Virtual-11", "Virtual-12", "Virtual-13", "Virtual-14", "Virtual-15", "Virtual-16", "But switch", "But latch", "But step", "Aux-0 switch", "Aux-1 switch", "Aux-2 switch", "Aux-01 switch", "Aux-012 switch", "Aux-0 latch", "Aux-1 latch", "Aux-2 latch", "Aux-01 latch", "Aux-012 latch", "Aux-0 step", "Aux-1 step", "Aux-2 step"],
        "foc" : 0,
        "hidden" : 0,
        "column" : 1
    },{
        "name" : "Re-center Camera",
        "ext" : "",
        "page" : "functions",
        "type" : "LIST",
        "size" : 1,
        "adr" : 124,
        "default" : 0,
        "steps" : 1, "min" : 0, "max" : 42,
        "choices" : ["off", "Rc-0", "Rc-1", "Rc-2", "Rc2-0", "Rc2-1", "Rc2-2", "Rc2-3", "Pot-0", "Pot-1", "Pot-2", "Virtual-1", "Virtual-2", "Virtual-3", "Virtual-4", "Virtual-5", "Virtual-6", "Virtual-7", "Virtual-8", "Virtual-9", "Virtual-10", "Virtual-11", "Virtual-12", "Virtual-13", "Virtual-14", "Virtual-15", "Virtual-16", "But switch", "But latch", "But step", "Aux-0 switch", "Aux-1 switch", "Aux-2 switch", "Aux-01 switch", "Aux-012 switch", "Aux-0 latch", "Aux-1 latch", "Aux-2 latch", "Aux-01 latch", "Aux-012 latch", "Aux-0 step", "Aux-1 step", "Aux-2 step"],
        "foc" : 0,
        "hidden" : 0,
        "pos" : [1,3]
    },{
        "name" : "IR Camera Control",
        "ext" : "",
        "page" : "functions",
        "type" : "LIST",
        "size" : 1,
        "adr" : 125,
        "default" : 0,
        "steps" : 1, "min" : 0, "max" : 42,
        "choices" : ["off", "Rc-0", "Rc-1", "Rc-2", "Rc2-0", "Rc2-1", "Rc2-2", "Rc2-3", "Pot-0", "Pot-1", "Pot-2", "Virtual-1", "Virtual-2", "Virtual-3", "Virtual-4", "Virtual-5", "Virtual-6", "Virtual-7", "Virtual-8", "Virtual-9", "Virtual-10", "Virtual-11", "Virtual-12", "Virtual-13", "Virtual-14", "Virtual-15", "Virtual-16", "But switch", "But latch", "But step", "Aux-0 switch", "Aux-1 switch", "Aux-2 switch", "Aux-01 switch", "Aux-012 switch", "Aux-0 latch", "Aux-1 latch", "Aux-2 latch", "Aux-01 latch", "Aux-012 latch", "Aux-0 step", "Aux-1 step", "Aux-2 step"],
        "foc" : 0,
        "hidden" : 0,
        "column" : 2
    },{
        "name" : "Camera Model",
        "ext" : "",
        "page" : "functions",
        "type" : "LIST",
        "size" : 1,
        "adr" : 126,
        "default" : 0,
        "steps" : 1, "min" : 0, "max" : 5,
        "choices" : ["Sony Nex", "Canon", "Panasonic", "Nikon", "Git2 Rc", "CAMremote"],
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "IR Camera Setting #1",
        "ext" : "",
        "page" : "functions",
        "type" : "LIST",
        "size" : 1,
        "adr" : 127,
        "default" : 0,
        "steps" : 1, "min" : 0, "max" : 2,
        "choices" : ["shutter", "shutter delay", "video on/off"],
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "IR Camera Setting #2",
        "ext" : "",
        "page" : "functions",
        "type" : "LIST",
        "size" : 1,
        "adr" : 128,
        "default" : 2,
        "steps" : 1, "min" : 0, "max" : 3,
        "choices" : ["shutter", "shutter delay", "video on/off", "off"],
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Time Interval",
        "ext" : "(0 = off)",
        "page" : "functions",
        "type" : "UINT",
        "size" : 2,
        "adr" : 129,
        "default" : 0,
        "steps" : 1, "min" : 0, "max" : 150,
        "len" : 0, "ppos" : 1, "unit" : "s",
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Pwm Out Control",
        "ext" : "",
        "page" : "functions",
        "type" : "LIST",
        "size" : 1,
        "adr" : 130,
        "default" : 0,
        "steps" : 1, "min" : 0, "max" : 42,
        "choices" : ["off", "Rc-0", "Rc-1", "Rc-2", "Rc2-0", "Rc2-1", "Rc2-2", "Rc2-3", "Pot-0", "Pot-1", "Pot-2", "Virtual-1", "Virtual-2", "Virtual-3", "Virtual-4", "Virtual-5", "Virtual-6", "Virtual-7", "Virtual-8", "Virtual-9", "Virtual-10", "Virtual-11", "Virtual-12", "Virtual-13", "Virtual-14", "Virtual-15", "Virtual-16", "But switch", "But latch", "But step", "Aux-0 switch", "Aux-1 switch", "Aux-2 switch", "Aux-01 switch", "Aux-012 switch", "Aux-0 latch", "Aux-1 latch", "Aux-2 latch", "Aux-01 latch", "Aux-012 latch", "Aux-0 step", "Aux-1 step", "Aux-2 step"],
        "foc" : 0,
        "hidden" : 0,
        "column" : 3
    },{
        "name" : "Pwm Out Mid",
        "ext" : "",
        "page" : "functions",
        "type" : "UINT",
        "size" : 2,
        "adr" : 131,
        "default" : 1500,
        "steps" : 1, "min" : 900, "max" : 2100,
        "len" : 0, "ppos" : 0, "unit" : "us",
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Pwm Out Min",
        "ext" : "",
        "page" : "functions",
        "type" : "UINT",
        "size" : 2,
        "adr" : 132,
        "default" : 1100,
        "steps" : 10, "min" : 900, "max" : 2100,
        "len" : 0, "ppos" : 0, "unit" : "us",
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Pwm Out Max",
        "ext" : "",
        "page" : "functions",
        "type" : "UINT",
        "size" : 2,
        "adr" : 133,
        "default" : 1900,
        "steps" : 10, "min" : 900, "max" : 2100,
        "len" : 0, "ppos" : 0, "unit" : "us",
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Pwm Out Speed Limit",
        "ext" : "(0 = off)",
        "page" : "functions",
        "type" : "UINT",
        "size" : 2,
        "adr" : 134,
        "default" : 0,
        "steps" : 5, "min" : 0, "max" : 1000,
        "len" : 0, "ppos" : 0, "unit" : "us/s",
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Script1 Control",
        "ext" : "",
        "page" : "scripts",
        "type" : "LIST",
        "size" : 1,
        "adr" : 150,
        "default" : 0,
        "steps" : 1, "min" : 0, "max" : 42,
        "choices" : ["off", "Rc-0", "Rc-1", "Rc-2", "Rc2-0", "Rc2-1", "Rc2-2", "Rc2-3", "Pot-0", "Pot-1", "Pot-2", "Virtual-1", "Virtual-2", "Virtual-3", "Virtual-4", "Virtual-5", "Virtual-6", "Virtual-7", "Virtual-8", "Virtual-9", "Virtual-10", "Virtual-11", "Virtual-12", "Virtual-13", "Virtual-14", "Virtual-15", "Virtual-16", "But switch", "But latch", "But step", "Aux-0 switch", "Aux-1 switch", "Aux-2 switch", "Aux-01 switch", "Aux-012 switch", "Aux-0 latch", "Aux-1 latch", "Aux-2 latch", "Aux-01 latch", "Aux-012 latch", "Aux-0 step", "Aux-1 step", "Aux-2 step"],
        "foc" : 0,
        "hidden" : 0,
        "column" : 1
    },{
        "name" : "Script2 Control",
        "ext" : "",
        "page" : "scripts",
        "type" : "LIST",
        "size" : 1,
        "adr" : 151,
        "default" : 0,
        "steps" : 1, "min" : 0, "max" : 42,
        "choices" : ["off", "Rc-0", "Rc-1", "Rc-2", "Rc2-0", "Rc2-1", "Rc2-2", "Rc2-3", "Pot-0", "Pot-1", "Pot-2", "Virtual-1", "Virtual-2", "Virtual-3", "Virtual-4", "Virtual-5", "Virtual-6", "Virtual-7", "Virtual-8", "Virtual-9", "Virtual-10", "Virtual-11", "Virtual-12", "Virtual-13", "Virtual-14", "Virtual-15", "Virtual-16", "But switch", "But latch", "But step", "Aux-0 switch", "Aux-1 switch", "Aux-2 switch", "Aux-01 switch", "Aux-012 switch", "Aux-0 latch", "Aux-1 latch", "Aux-2 latch", "Aux-01 latch", "Aux-012 latch", "Aux-0 step", "Aux-1 step", "Aux-2 step"],
        "foc" : 0,
        "hidden" : 0,
        "column" : 2
    },{
        "name" : "Script3 Control",
        "ext" : "",
        "page" : "scripts",
        "type" : "LIST",
        "size" : 1,
        "adr" : 152,
        "default" : 0,
        "steps" : 1, "min" : 0, "max" : 42,
        "choices" : ["off", "Rc-0", "Rc-1", "Rc-2", "Rc2-0", "Rc2-1", "Rc2-2", "Rc2-3", "Pot-0", "Pot-1", "Pot-2", "Virtual-1", "Virtual-2", "Virtual-3", "Virtual-4", "Virtual-5", "Virtual-6", "Virtual-7", "Virtual-8", "Virtual-9", "Virtual-10", "Virtual-11", "Virtual-12", "Virtual-13", "Virtual-14", "Virtual-15", "Virtual-16", "But switch", "But latch", "But step", "Aux-0 switch", "Aux-1 switch", "Aux-2 switch", "Aux-01 switch", "Aux-012 switch", "Aux-0 latch", "Aux-1 latch", "Aux-2 latch", "Aux-01 latch", "Aux-012 latch", "Aux-0 step", "Aux-1 step", "Aux-2 step"],
        "foc" : 0,
        "hidden" : 0,
        "column" : 3
    },{
        "name" : "Script4 Control",
        "ext" : "",
        "page" : "scripts",
        "type" : "LIST",
        "size" : 1,
        "adr" : 153,
        "default" : 0,
        "steps" : 1, "min" : 0, "max" : 42,
        "choices" : ["off", "Rc-0", "Rc-1", "Rc-2", "Rc2-0", "Rc2-1", "Rc2-2", "Rc2-3", "Pot-0", "Pot-1", "Pot-2", "Virtual-1", "Virtual-2", "Virtual-3", "Virtual-4", "Virtual-5", "Virtual-6", "Virtual-7", "Virtual-8", "Virtual-9", "Virtual-10", "Virtual-11", "Virtual-12", "Virtual-13", "Virtual-14", "Virtual-15", "Virtual-16", "But switch", "But latch", "But step", "Aux-0 switch", "Aux-1 switch", "Aux-2 switch", "Aux-01 switch", "Aux-012 switch", "Aux-0 latch", "Aux-1 latch", "Aux-2 latch", "Aux-01 latch", "Aux-012 latch", "Aux-0 step", "Aux-1 step", "Aux-2 step"],
        "foc" : 0,
        "hidden" : 0,
        "column" : 4
    },{
        "name" : "Scripts",
        "ext" : "",
        "page" : "scripts",
        "type" : "SCRIPT",
        "size" : 128,
        "adr" : 154,
        "default" : 0,
        "foc" : 0,
        "hidden" : 1
    },{
        "name" : "Imu2 Configuration",
        "ext" : "",
        "page" : "setup",
        "type" : "LIST",
        "size" : 1,
        "adr" : 53,
        "default" : 0,
        "steps" : 1, "min" : 0, "max" : 2,
        "choices" : ["off", "full", "full xy"],
        "foc" : 3,
        "hidden" : 0
    },{
        "name" : "Startup Mode",
        "ext" : "",
        "page" : "setup",
        "type" : "LIST",
        "size" : 1,
        "adr" : 140,
        "default" : 0,
        "steps" : 1, "min" : 0, "max" : 1,
        "choices" : ["normal", "fast"],
        "foc" : 3,
        "hidden" : 0,
        "pos" : [1,4]
    },{
        "name" : "Startup Delay",
        "ext" : "",
        "page" : "setup",
        "type" : "UINT",
        "size" : 2,
        "adr" : 141,
        "default" : 0,
        "steps" : 5, "min" : 0, "max" : 250,
        "len" : 0, "ppos" : 1, "unit" : "s",
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Imu AHRS",
        "ext" : "",
        "page" : "setup",
        "type" : "UINT",
        "size" : 2,
        "adr" : 61,
        "default" : 1000,
        "steps" : 100, "min" : 0, "max" : 2500,
        "len" : 5, "ppos" : 2, "unit" : "s",
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Virtual Channel Configuration",
        "ext" : "",
        "page" : "setup",
        "type" : "LIST",
        "size" : 1,
        "adr" : 77,
        "default" : 0,
        "steps" : 1, "min" : 0, "max" : 11,
        "choices" : ["off", "sum ppm 6", "sum ppm 7", "sum ppm 8", "sum ppm 10", "sum ppm 12", "spektrum 10 bit", "spektrum 11 bit", "sbus", "hott sumd", "srxl", "serial"],
        "foc" : 0,
        "hidden" : 0,
        "column" : 2
    },{
        "name" : "Pwm Out Configuration",
        "ext" : "",
        "page" : "setup",
        "type" : "LIST",
        "size" : 1,
        "adr" : 78,
        "default" : 0,
        "steps" : 1, "min" : 0, "max" : 2,
        "choices" : ["off", "1520 us 55 Hz", "1520 us 250 Hz"],
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Rc Pitch Offset",
        "ext" : "",
        "page" : "setup",
        "type" : "INT",
        "size" : 2,
        "adr" : 99,
        "default" : 0,
        "steps" : 5, "min" : -1200, "max" : 1200,
        "len" : 0, "ppos" : 1, "unit" : "",
        "foc" : 0,
        "hidden" : 0,
        "pos" : [2,4]
    },{
        "name" : "Rc Roll Offset",
        "ext" : "",
        "page" : "setup",
        "type" : "INT",
        "size" : 2,
        "adr" : 100,
        "default" : 0,
        "steps" : 5, "min" : -1200, "max" : 1200,
        "len" : 0, "ppos" : 1, "unit" : "",
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Rc Yaw Offset",
        "ext" : "",
        "page" : "setup",
        "type" : "INT",
        "size" : 2,
        "adr" : 101,
        "default" : 0,
        "steps" : 5, "min" : -1200, "max" : 1200,
        "len" : 0, "ppos" : 1, "unit" : "",
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Esp Configuration",
        "ext" : "",
        "page" : "setup",
        "type" : "LIST",
        "size" : 1,
        "adr" : 147,
        "default" : 0,
        "steps" : 1, "min" : 0, "max" : 2,
        "choices" : ["off", "uart", "uart2"],
        "foc" : 0,
        "hidden" : 0,
        "pos" : [3,1]
    },{
        "name" : "Low Voltage Limit",
        "ext" : "",
        "page" : "setup",
        "type" : "LIST",
        "size" : 1,
        "adr" : 74,
        "default" : 1,
        "steps" : 1, "min" : 0, "max" : 7,
        "choices" : ["off", "2.9 V/cell", "3.0 V/cell", "3.1 V/cell", "3.2 V/cell", "3.3 V/cell", "3.4 V/cell", "3.5 V/cell"],
        "foc" : 0,
        "hidden" : 0,
        "pos" : [3,4]
    },{
        "name" : "Beep with Motors",
        "ext" : "",
        "page" : "setup",
        "type" : "LIST",
        "size" : 1,
        "adr" : 143,
        "default" : 0,
        "steps" : 1, "min" : 0, "max" : 2,
        "choices" : ["off", "basic", "all"],
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "NT Logging",
        "ext" : "",
        "page" : "setup",
        "type" : "LIST",
        "size" : 1,
        "adr" : 142,
        "default" : 0,
        "steps" : 1, "min" : 0, "max" : 7,
        "choices" : ["off", "basic", "basic + pid", "basic + accgyro", "basic + accgyro_raw", "basic + pid + accgyro", "basic + pid + ag_raw", "full"],
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Pitch Motor Usage",
        "ext" : "",
        "page" : "setup",
        "type" : "LIST",
        "size" : 1,
        "adr" : 55,
        "default" : 3,
        "steps" : 1, "min" : 0, "max" : 3,
        "choices" : ["normal", "level", "startup pos", "disabled"],
        "foc" : 0,
        "hidden" : 0,
        "column" : 4
    },{
        "name" : "Roll Motor Usage",
        "ext" : "",
        "page" : "setup",
        "type" : "LIST",
        "size" : 1,
        "adr" : 56,
        "default" : 3,
        "steps" : 1, "min" : 0, "max" : 3,
        "choices" : ["normal", "level", "startup pos", "disabled"],
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Yaw Motor Usage",
        "ext" : "",
        "page" : "setup",
        "type" : "LIST",
        "size" : 1,
        "adr" : 57,
        "default" : 3,
        "steps" : 1, "min" : 0, "max" : 3,
        "choices" : ["normal", "level", "startup pos", "disabled"],
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Imu Orientation",
        "ext" : "",
        "page" : "gimbalconfig",
        "type" : "LIST",
        "size" : 1,
        "adr" : 51,
        "default" : 0,
        "steps" : 1, "min" : 0, "max" : 23,
        "choices" : ["no.0:  z0   x  y  z", "no.1:  z90  -y  x  z", "no.2:  z180  -x -y  z", "no.3:  z270   y -x  z", "no.4:  x0   y  z  x", "no.5:  x90  -z  y  x", "no.6:  x180  -y -z  x", "no.7:  x270   z -y  x", "no.8:  y0   z  x  y", "no.9:  y90  -x  z  y", "no.10:  y180  -z -x  y", "no.11:  y270   x -z  y", "no.12:  -z0   y  x -z", "no.13:  -z90  -x  y -z", "no.14:  -z180  -y -x -z", "no.15:  -z270   x -y -z", "no.16:  -x0   z  y -x", "no.17:  -x90  -y  z -x", "no.18:  -x180  -z -y -x", "no.19:  -x270   y -z -x", "no.20:  -y0   x  z -y", "no.21:  -y90  -z  x -y", "no.22:  -y180  -x -z -y", "no.23:  -y270   z -x -y"],
        "foc" : 0,
        "hidden" : 0,
        "pos" : [1,1]
    },{
        "name" : "Imu2 Orientation",
        "ext" : "",
        "page" : "gimbalconfig",
        "type" : "LIST",
        "size" : 1,
        "adr" : 54,
        "default" : 0,
        "steps" : 1, "min" : 0, "max" : 23,
        "choices" : ["no.0:  z0   x  y  z", "no.1:  z90  -y  x  z", "no.2:  z180  -x -y  z", "no.3:  z270   y -x  z", "no.4:  x0   y  z  x", "no.5:  x90  -z  y  x", "no.6:  x180  -y -z  x", "no.7:  x270   z -y  x", "no.8:  y0   z  x  y", "no.9:  y90  -x  z  y", "no.10:  y180  -z -x  y", "no.11:  y270   x -z  y", "no.12:  -z0   y  x -z", "no.13:  -z90  -x  y -z", "no.14:  -z180  -y -x -z", "no.15:  -z270   x -y -z", "no.16:  -x0   z  y -x", "no.17:  -x90  -y  z -x", "no.18:  -x180  -z -y -x", "no.19:  -x270   y -z -x", "no.20:  -y0   x  z -y", "no.21:  -y90  -z  x -y", "no.22:  -y180  -x -z -y", "no.23:  -y270   z -x -y"],
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Pitch Motor Poles",
        "ext" : "",
        "page" : "gimbalconfig",
        "type" : "UINT",
        "size" : 2,
        "adr" : 13,
        "default" : 14,
        "steps" : 2, "min" : 8, "max" : 28,
        "len" : 0, "ppos" : 0, "unit" : "",
        "foc" : 1,
        "hidden" : 0,
        "pos" : [2,1]
    },{
        "name" : "Pitch Motor Direction",
        "ext" : "",
        "page" : "gimbalconfig",
        "type" : "LIST",
        "size" : 1,
        "adr" : 14,
        "default" : 2,
        "steps" : 1, "min" : 0, "max" : 2,
        "choices" : ["normal", "reversed", "auto"],
        "foc" : 1,
        "hidden" : 0
    },{
        "name" : "Pitch Startup Motor Pos",
        "ext" : "",
        "page" : "gimbalconfig",
        "type" : "UINT",
        "size" : 2,
        "adr" : 15,
        "default" : 504,
        "steps" : 1, "min" : 0, "max" : 1008,
        "len" : 5, "ppos" : 0, "unit" : "",
        "foc" : 1,
        "hidden" : 0
    },{
        "name" : "Foc Pitch Motor Direction",
        "ext" : "",
        "page" : "gimbalconfig",
        "type" : "LIST",
        "size" : 1,
        "adr" : 42,
        "default" : 0,
        "steps" : 1, "min" : 0, "max" : 1,
        "choices" : ["normal", "reversed", "auto"],
        "foc" : 2,
        "hidden" : 0,
        "pos" : [2,1]
    },{
        "name" : "Foc Pitch Zero Pos",
        "ext" : "",
        "page" : "gimbalconfig",
        "type" : "INT",
        "size" : 2,
        "adr" : 43,
        "default" : 0,
        "steps" : 8, "min" : -16384, "max" : 16383,
        "len" : 5, "ppos" : 0, "unit" : "",
        "foc" : 2,
        "hidden" : 0
    },{
        "name" : "Pitch Offset",
        "ext" : "",
        "page" : "gimbalconfig",
        "type" : "INT",
        "size" : 2,
        "adr" : 58,
        "default" : 0,
        "steps" : 5, "min" : -300, "max" : 300,
        "len" : 5, "ppos" : 2, "unit" : "",
        "foc" : 0,
        "hidden" : 0,
        "pos" : [2,4]
    },{
        "name" : "Roll Motor Poles",
        "ext" : "",
        "page" : "gimbalconfig",
        "type" : "UINT",
        "size" : 2,
        "adr" : 16,
        "default" : 14,
        "steps" : 2, "min" : 8, "max" : 28,
        "len" : 0, "ppos" : 0, "unit" : "",
        "foc" : 1,
        "hidden" : 0,
        "pos" : [3,1]
    },{
        "name" : "Roll Motor Direction",
        "ext" : "",
        "page" : "gimbalconfig",
        "type" : "LIST",
        "size" : 1,
        "adr" : 17,
        "default" : 2,
        "steps" : 1, "min" : 0, "max" : 2,
        "choices" : ["normal", "reversed", "auto"],
        "foc" : 1,
        "hidden" : 0
    },{
        "name" : "Roll Startup Motor Pos",
        "ext" : "",
        "page" : "gimbalconfig",
        "type" : "UINT",
        "size" : 2,
        "adr" : 18,
        "default" : 504,
        "steps" : 1, "min" : 0, "max" : 1008,
        "len" : 5, "ppos" : 0, "unit" : "",
        "foc" : 1,
        "hidden" : 0
    },{
        "name" : "Foc Roll Motor Direction",
        "ext" : "",
        "page" : "gimbalconfig",
        "type" : "LIST",
        "size" : 1,
        "adr" : 44,
        "default" : 0,
        "steps" : 1, "min" : 0, "max" : 1,
        "choices" : ["normal", "reversed", "auto"],
        "foc" : 2,
        "hidden" : 0,
        "pos" : [3,1]
    },{
        "name" : "Foc Roll Zero Pos",
        "ext" : "",
        "page" : "gimbalconfig",
        "type" : "INT",
        "size" : 2,
        "adr" : 45,
        "default" : 0,
        "steps" : 8, "min" : -16384, "max" : 16383,
        "len" : 5, "ppos" : 0, "unit" : "",
        "foc" : 2,
        "hidden" : 0
    },{
        "name" : "Roll Offset",
        "ext" : "",
        "page" : "gimbalconfig",
        "type" : "INT",
        "size" : 2,
        "adr" : 59,
        "default" : 0,
        "steps" : 5, "min" : -300, "max" : 300,
        "len" : 5, "ppos" : 2, "unit" : "",
        "foc" : 0,
        "hidden" : 0,
        "pos" : [3,4]
    },{
        "name" : "Yaw Motor Poles",
        "ext" : "",
        "page" : "gimbalconfig",
        "type" : "UINT",
        "size" : 2,
        "adr" : 19,
        "default" : 14,
        "steps" : 2, "min" : 8, "max" : 28,
        "len" : 0, "ppos" : 0, "unit" : "",
        "foc" : 1,
        "hidden" : 0,
        "pos" : [4,1]
    },{
        "name" : "Yaw Motor Direction",
        "ext" : "",
        "page" : "gimbalconfig",
        "type" : "LIST",
        "size" : 1,
        "adr" : 20,
        "default" : 2,
        "steps" : 1, "min" : 0, "max" : 2,
        "choices" : ["normal", "reversed", "auto"],
        "foc" : 1,
        "hidden" : 0
    },{
        "name" : "Yaw Startup Motor Pos",
        "ext" : "",
        "page" : "gimbalconfig",
        "type" : "UINT",
        "size" : 2,
        "adr" : 21,
        "default" : 504,
        "steps" : 1, "min" : 0, "max" : 1008,
        "len" : 5, "ppos" : 0, "unit" : "",
        "foc" : 1,
        "hidden" : 0
    },{
        "name" : "Foc Yaw Motor Direction",
        "ext" : "",
        "page" : "gimbalconfig",
        "type" : "LIST",
        "size" : 1,
        "adr" : 46,
        "default" : 0,
        "steps" : 1, "min" : 0, "max" : 1,
        "choices" : ["normal", "reversed", "auto"],
        "foc" : 2,
        "hidden" : 0,
        "pos" : [4,1]
    },{
        "name" : "Foc Yaw Zero Pos",
        "ext" : "",
        "page" : "gimbalconfig",
        "type" : "INT",
        "size" : 2,
        "adr" : 47,
        "default" : 0,
        "steps" : 8, "min" : -16384, "max" : 16383,
        "len" : 5, "ppos" : 0, "unit" : "",
        "foc" : 2,
        "hidden" : 0
    },{
        "name" : "Yaw Offset",
        "ext" : "",
        "page" : "gimbalconfig",
        "type" : "INT",
        "size" : 2,
        "adr" : 60,
        "default" : 0,
        "steps" : 5, "min" : -300, "max" : 300,
        "len" : 5, "ppos" : 2, "unit" : "",
        "foc" : 0,
        "hidden" : 0,
        "pos" : [4,4]
    },{
        "name" : "Motor Mapping",
        "ext" : "",
        "page" : "expert",
        "type" : "LIST",
        "size" : 1,
        "adr" : 22,
        "default" : 0,
        "steps" : 1, "min" : 0, "max" : 5,
        "choices" : ["M0=pitch , M1=roll", "M0=roll , M1=pitch", "roll yaw pitch", "yaw roll pitch", "pitch yaw roll", "yaw pitch roll"],
        "foc" : 3,
        "hidden" : 0,
        "column" : 3
    },{
        "name" : "Imu Mapping",
        "ext" : "",
        "page" : "expert",
        "type" : "LIST",
        "size" : 1,
        "adr" : 52,
        "default" : 0,
        "steps" : 1, "min" : 0, "max" : 1,
        "choices" : ["1 = id1 , 2 = id2", "1 = id2 , 2 = id1"],
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Lipo Cells",
        "ext" : "",
        "page" : "expert",
        "type" : "LIST",
        "size" : 1,
        "adr" : 49,
        "default" : 0,
        "steps" : 1, "min" : 0, "max" : 6,
        "choices" : ["auto", "1 S", "2 S", "3 S", "4 S", "5 S", "6 S"],
        "foc" : 0,
        "hidden" : 0,
        "pos" : [3,4]
    },{
        "name" : "Lipo Voltage per Cell",
        "ext" : "",
        "page" : "expert",
        "type" : "UINT",
        "size" : 2,
        "adr" : 50,
        "default" : 420,
        "steps" : 5, "min" : 300, "max" : 500,
        "len" : 0, "ppos" : 2, "unit" : "V",
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "ADC Calibration",
        "ext" : "",
        "page" : "expert",
        "type" : "UINT",
        "size" : 2,
        "adr" : 76,
        "default" : 1550,
        "steps" : 10, "min" : 1000, "max" : 2000,
        "len" : 0, "ppos" : 0, "unit" : "",
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Imu3 Configuration",
        "ext" : "",
        "page" : "expert",
        "type" : "LIST",
        "size" : 1,
        "adr" : 135,
        "default" : 0,
        "steps" : 1, "min" : 0, "max" : 5,
        "choices" : ["off", "default", "2 = id2, 3 = onboard", "2 = onboard, 3 = id2", "2 = onboard, 3 = id3", "2 = onboard, 3 = off"],
        "foc" : 0,
        "hidden" : 0,
        "column" : 4
    },{
        "name" : "Imu3 Orientation",
        "ext" : "",
        "page" : "expert",
        "type" : "LIST",
        "size" : 1,
        "adr" : 136,
        "default" : 0,
        "steps" : 1, "min" : 0, "max" : 23,
        "choices" : ["no.0:  z0   x  y  z", "no.1:  z90  -y  x  z", "no.2:  z180  -x -y  z", "no.3:  z270   y -x  z", "no.4:  x0   y  z  x", "no.5:  x90  -z  y  x", "no.6:  x180  -y -z  x", "no.7:  x270   z -y  x", "no.8:  y0   z  x  y", "no.9:  y90  -x  z  y", "no.10:  y180  -z -x  y", "no.11:  y270   x -z  y", "no.12:  -z0   y  x -z", "no.13:  -z90  -x  y -z", "no.14:  -z180  -y -x -z", "no.15:  -z270   x -y -z", "no.16:  -x0   z  y -x", "no.17:  -x90  -y  z -x", "no.18:  -x180  -z -y -x", "no.19:  -x270   y -z -x", "no.20:  -y0   x  z -y", "no.21:  -y90  -z  x -y", "no.22:  -y180  -x -z -y", "no.23:  -y270   z -x -y"],
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Uart1 Rx Configuration",
        "ext" : "",
        "page" : "expert",
        "type" : "LIST",
        "size" : 1,
        "adr" : 139,
        "default" : 0,
        "steps" : 1, "min" : 0, "max" : 1,
        "choices" : ["off", "gps target"],
        "foc" : 0,
        "hidden" : 0,
        "pos" : [4,5]
    },{
        "name" : "Uart1 Tx Configuration",
        "ext" : "",
        "page" : "expert",
        "type" : "LIST",
        "size" : 1,
        "adr" : 48,
        "default" : 0,
        "steps" : 1, "min" : 0, "max" : 1,
        "choices" : ["off", "oled display"],
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Acc LPF",
        "ext" : "",
        "page" : "expert",
        "type" : "LIST",
        "size" : 1,
        "adr" : 71,
        "default" : 2,
        "steps" : 1, "min" : 0, "max" : 6,
        "choices" : ["off", "1.5 ms", "4.5 ms", "12 ms", "25 ms", "50 ms", "100 ms"],
        "foc" : 0,
        "hidden" : 0,
        "column" : 1
    },{
        "name" : "Rc Adc LPF",
        "ext" : "",
        "page" : "expert",
        "type" : "LIST",
        "size" : 1,
        "adr" : 98,
        "default" : 0,
        "steps" : 1, "min" : 0, "max" : 6,
        "choices" : ["off", "1.5 ms", "4.5 ms", "12 ms", "25 ms", "50 ms", "100 ms"],
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Hold To Pan Transition Time",
        "ext" : "",
        "page" : "expert",
        "type" : "UINT",
        "size" : 2,
        "adr" : 95,
        "default" : 250,
        "steps" : 25, "min" : 0, "max" : 1000,
        "len" : 5, "ppos" : 0, "unit" : "ms",
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Acc Compensation Method",
        "ext" : "",
        "page" : "expert",
        "type" : "LIST",
        "size" : 1,
        "adr" : 65,
        "default" : 1,
        "steps" : 1, "min" : 0, "max" : 1,
        "choices" : ["standard", "advanced"],
        "foc" : 0,
        "hidden" : 0,
        "pos" : [1,6]
    },{
        "name" : "Imu Acc Threshold",
        "ext" : "(0 = off)",
        "page" : "expert",
        "type" : "UINT",
        "size" : 2,
        "adr" : 64,
        "default" : 25,
        "steps" : 1, "min" : 0, "max" : 100,
        "len" : 5, "ppos" : 2, "unit" : "g",
        "foc" : 0,
        "hidden" : 0,
        "column" : 2
    },{
        "name" : "Acc Noise Level",
        "ext" : "",
        "page" : "expert",
        "type" : "UINT",
        "size" : 2,
        "adr" : 66,
        "default" : 40,
        "steps" : 1, "min" : 0, "max" : 150,
        "len" : 0, "ppos" : 3, "unit" : "g",
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Acc Threshold",
        "ext" : "(0 = off)",
        "page" : "expert",
        "type" : "UINT",
        "size" : 2,
        "adr" : 67,
        "default" : 50,
        "steps" : 1, "min" : 0, "max" : 100,
        "len" : 0, "ppos" : 2, "unit" : "g",
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Acc Vertical Weight",
        "ext" : "",
        "page" : "expert",
        "type" : "UINT",
        "size" : 2,
        "adr" : 68,
        "default" : 25,
        "steps" : 5, "min" : 0, "max" : 100,
        "len" : 0, "ppos" : 0, "unit" : "%",
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Acc Zentrifugal Correction",
        "ext" : "",
        "page" : "expert",
        "type" : "UINT",
        "size" : 2,
        "adr" : 69,
        "default" : 30,
        "steps" : 5, "min" : 0, "max" : 100,
        "len" : 0, "ppos" : 0, "unit" : "%",
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Acc Recover Time",
        "ext" : "",
        "page" : "expert",
        "type" : "UINT",
        "size" : 2,
        "adr" : 70,
        "default" : 250,
        "steps" : 5, "min" : 0, "max" : 1000,
        "len" : 0, "ppos" : 0, "unit" : " ms",
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Mavlink Configuration",
        "ext" : "",
        "page" : "interfaces",
        "type" : "LIST",
        "size" : 1,
        "adr" : 144,
        "default" : 0,
        "steps" : 1, "min" : 0, "max" : 3,
        "choices" : ["no heartbeat", "emit heartbeat", "heartbeat + attitude", "h.b. + mountstatus"],
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Mavlink System ID",
        "ext" : "",
        "page" : "interfaces",
        "type" : "UINT",
        "size" : 2,
        "adr" : 145,
        "default" : 71,
        "steps" : 1, "min" : 0, "max" : 255,
        "len" : 0, "ppos" : 0, "unit" : "",
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Mavlink Component ID",
        "ext" : "",
        "page" : "interfaces",
        "type" : "UINT",
        "size" : 2,
        "adr" : 146,
        "default" : 67,
        "steps" : 1, "min" : 0, "max" : 255,
        "len" : 0, "ppos" : 0, "unit" : "",
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "Uavcan Configuration",
        "ext" : "",
        "page" : "interfaces",
        "type" : "LIST",
        "size" : 1,
        "adr" : 148,
        "default" : 0,
        "steps" : 1, "min" : 0, "max" : 1,
        "choices" : ["off", "normal"],
        "foc" : 0,
        "hidden" : 0,
        "pos" : [2,1]
    },{
        "name" : "Uavcan Node ID",
        "ext" : "",
        "page" : "interfaces",
        "type" : "UINT",
        "size" : 2,
        "adr" : 149,
        "default" : 71,
        "steps" : 1, "min" : 11, "max" : 124,
        "len" : 0, "ppos" : 0, "unit" : "",
        "foc" : 0,
        "hidden" : 0
    },{
        "name" : "STorM32Link Configuration",
        "ext" : "",
        "page" : "interfaces",
        "type" : "LIST",
        "size" : 1,
        "adr" : 137,
        "default" : 0,
        "steps" : 1, "min" : 0, "max" : 1,
        "choices" : ["off", "normal"],
        "foc" : 0,
        "hidden" : 0,
        "pos" : [3,1]
    },{
        "name" : "STorM32Link Wait Time",
        "ext" : "",
        "page" : "interfaces",
        "type" : "UINT",
        "size" : 2,
        "adr" : 138,
        "default" : 50,
        "steps" : 5, "min" : 0, "max" : 250,
        "len" : 0, "ppos" : 1, "unit" : "s",
        "foc" : 0,
        "hidden" : 0
    }
]
